/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import noppes.npcs.CustomNpcs;
import noppes.npcs.entity.EntityChairMount;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPC64x32;
import noppes.npcs.entity.EntityNPCGolem;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.EntityNpcAlex;
import noppes.npcs.entity.EntityNpcClassicPlayer;
import noppes.npcs.entity.EntityNpcCrystal;
import noppes.npcs.entity.EntityNpcDragon;
import noppes.npcs.entity.EntityNpcPony;
import noppes.npcs.entity.EntityNpcSlime;
import noppes.npcs.entity.EntityProjectile;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="customnpcs")
@ObjectHolder(value="customnpcs")
public class CustomEntities {
    @ObjectHolder(value="npcpony")
    public static EntityType<? extends CreatureEntity> entityNpcPony;
    @ObjectHolder(value="npccrystal")
    public static EntityType<? extends CreatureEntity> entityNpcCrystal;
    @ObjectHolder(value="npcslime")
    public static EntityType<? extends CreatureEntity> entityNpcSlime;
    @ObjectHolder(value="npcdragon")
    public static EntityType<? extends CreatureEntity> entityNpcDragon;
    @ObjectHolder(value="npcgolem")
    public static EntityType<? extends CreatureEntity> entityNPCGolem;
    @ObjectHolder(value="customnpc")
    public static EntityType<? extends CreatureEntity> entityCustomNpc;
    @ObjectHolder(value="customnpc64x32")
    public static EntityType<? extends CreatureEntity> entityNPC64x32;
    @ObjectHolder(value="customnpcalex")
    public static EntityType<? extends CreatureEntity> entityNpcAlex;
    @ObjectHolder(value="customnpcclassic")
    public static EntityType<? extends CreatureEntity> entityNpcClassicPlayer;
    @ObjectHolder(value="customnpcchairmount")
    public static EntityType<?> entityChairMount;
    @ObjectHolder(value="customnpcprojectile")
    public static EntityType<? extends ThrowableEntity> entityProjectile;
    private static List<EntityType> types;

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        types.clear();
        CustomEntities.registerNpc(event.getRegistry(), EntityNpcPony.class, "npcpony", EntityNpcPony::new);
        CustomEntities.registerNpc(event.getRegistry(), EntityNpcCrystal.class, "npccrystal", EntityNpcCrystal::new);
        CustomEntities.registerNpc(event.getRegistry(), EntityNpcSlime.class, "npcslime", EntityNpcSlime::new);
        CustomEntities.registerNpc(event.getRegistry(), EntityNpcDragon.class, "npcdragon", EntityNpcDragon::new);
        CustomEntities.registerNpc(event.getRegistry(), EntityNPCGolem.class, "npcgolem", EntityNPCGolem::new);
        CustomEntities.registerNpc(event.getRegistry(), EntityCustomNpc.class, "customnpc", EntityCustomNpc::new);
        CustomEntities.registerNpc(event.getRegistry(), EntityNPC64x32.class, "customnpc64x32", EntityNPC64x32::new);
        CustomEntities.registerNpc(event.getRegistry(), EntityNpcAlex.class, "customnpcalex", EntityNpcAlex::new);
        CustomEntities.registerNpc(event.getRegistry(), EntityNpcClassicPlayer.class, "customnpcclassic", EntityNpcClassicPlayer::new);
        CustomEntities.registerNewentity(event.getRegistry(), EntityChairMount.class, "customnpcchairmount", EntityChairMount::new, 64, 10, false, 0.001f, 0.001f);
        CustomEntities.registerNewentity(event.getRegistry(), EntityProjectile.class, "customnpcprojectile", EntityProjectile::new, 64, 3, true, 0.25f, 0.25f);
    }

    @SubscribeEvent
    public static void attribute(EntityAttributeCreationEvent event) {
        for (EntityType type : types) {
            event.put(type, EntityNPCInterface.createMobAttributes().func_233813_a_());
        }
    }

    private static <T extends Entity> void registerNpc(IForgeRegistry<EntityType<?>> registry, Class<? extends Entity> c, String name, EntityType.IFactory<T> factoryIn) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factoryIn, (EntityClassification)EntityClassification.CREATURE);
        builder.setTrackingRange(10);
        builder.setUpdateInterval(3);
        builder.setShouldReceiveVelocityUpdates(false);
        builder.func_233606_a_(10);
        builder.func_220321_a(1.0f, 1.0f);
        ResourceLocation registryName = new ResourceLocation("customnpcs", name);
        EntityType type = (EntityType)builder.func_206830_a(registryName.toString()).setRegistryName(registryName);
        types.add(type);
        registry.register((IForgeRegistryEntry)type);
        if (CustomNpcs.FixUpdateFromPre_1_12) {
            registryName = new ResourceLocation("customnpcs." + name);
            registry.register(builder.func_206830_a(registryName.toString()).setRegistryName(registryName));
        }
    }

    private static <T extends Entity> void registerNewentity(IForgeRegistry<EntityType<?>> registry, Class<? extends Entity> c, String name, EntityType.IFactory<T> factoryIn, int range, int update, boolean velocity, float width, float height) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factoryIn, (EntityClassification)EntityClassification.MISC);
        builder.setTrackingRange(range);
        builder.setUpdateInterval(update);
        builder.setShouldReceiveVelocityUpdates(velocity);
        builder.func_220321_a(width, height);
        builder.func_233606_a_(4);
        ResourceLocation registryName = new ResourceLocation("customnpcs", name);
        registry.register(builder.func_206830_a(registryName.toString()).setRegistryName(registryName));
    }

    static {
        types = new ArrayList<EntityType>();
    }
}

