/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.CNpcsChunkManagerHelper;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import noppes.npcs.CustomEntities;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.data.SpawnData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;

public class NPCSpawning {
    private static Set<ChunkPos> eligibleChunksForSpawning = Sets.newHashSet();

    public static void findChunksForSpawning(ServerWorld level) {
        if (SpawnController.instance.data.isEmpty() || level.func_82737_E() % 400L != 0L) {
            return;
        }
        eligibleChunksForSpawning.clear();
        for (int i = 0; i < level.field_217491_A.size(); ++i) {
            PlayerEntity entityplayer = (PlayerEntity)level.field_217491_A.get(i);
            if (entityplayer.func_175149_v()) continue;
            int j = MathHelper.func_76128_c((double)(entityplayer.func_226277_ct_() / 16.0));
            int k = MathHelper.func_76128_c((double)(entityplayer.func_226281_cx_() / 16.0));
            int size = 7;
            for (int x = -size; x <= size; ++x) {
                for (int z = -size; z <= size; ++z) {
                    ChunkPos pos = new ChunkPos(x + j, z + k);
                    if (eligibleChunksForSpawning.contains(pos) || !level.func_175723_af().func_177730_a(pos) || !CNpcsChunkManagerHelper.canSpawn(level.func_72863_F().field_217237_a, pos)) continue;
                    eligibleChunksForSpawning.add(pos);
                }
            }
        }
        if (NPCSpawning.countNPCs(level) > eligibleChunksForSpawning.size() / 16) {
            return;
        }
        ArrayList<ChunkPos> tmp = new ArrayList<ChunkPos>(eligibleChunksForSpawning);
        Collections.shuffle(tmp);
        for (ChunkPos chunkcoordintpair1 : tmp) {
            BlockPos chunkposition = NPCSpawning.getChunk((World)level, chunkcoordintpair1.field_77276_a, chunkcoordintpair1.field_77275_b);
            int j1 = chunkposition.func_177958_n();
            int k1 = chunkposition.func_177956_o();
            int l1 = chunkposition.func_177952_p();
            for (int i = 0; i < 3; ++i) {
                int x = j1;
                int y = k1;
                int z = l1;
                int b1 = 6;
                BlockPos pos = new BlockPos(x += level.field_73012_v.nextInt(b1) - level.field_73012_v.nextInt(b1), y += level.field_73012_v.nextInt(1) - level.field_73012_v.nextInt(1), z += level.field_73012_v.nextInt(b1) - level.field_73012_v.nextInt(b1));
                BlockState state = level.func_180495_p(pos);
                ResourceLocation name = level.func_226691_t_(pos).getRegistryName();
                SpawnData data = SpawnController.instance.getRandomSpawnData(name, state.func_185904_a() == Material.field_151579_a);
                if (data == null || !NPCSpawning.canCreatureTypeSpawnAtLocation(data, (World)level, pos) || level.func_217366_a((double)x, (double)y, (double)z, 24.0, false) != null) continue;
                NPCSpawning.spawnData(data, (World)level, pos);
            }
        }
    }

    public static int countNPCs(ServerWorld level) {
        int count = 0;
        Collection list = level.field_175741_N.values();
        for (Entity entity : list) {
            if (!(entity instanceof EntityNPCInterface)) continue;
            ++count;
        }
        return count;
    }

    private static BlockPos getChunk(World level, int x, int y) {
        Chunk chunk = level.func_212866_a_(x, y);
        int i = x * 16 + level.field_73012_v.nextInt(16);
        int j = y * 16 + level.field_73012_v.nextInt(16);
        int k = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, i, j) + 1;
        int l = level.field_73012_v.nextInt(k + 1);
        return new BlockPos(i, l, j);
    }

    public static void performWorldGenSpawning(World level, int x, int z, Random rand) {
        Biome biome = level.func_226691_t_(new BlockPos(x + 8, 0, z + 8));
        if (biome.func_242433_b().func_242557_a() >= 1.0f || !SpawnController.instance.hasSpawnList(biome.getRegistryName())) {
            return;
        }
        block0: while (rand.nextFloat() < biome.func_242433_b().func_242557_a()) {
            SpawnData data = SpawnController.instance.getRandomSpawnData(biome.getRegistryName(), true);
            if (data == null) continue;
            int size = 16;
            int j1 = x + rand.nextInt(size);
            int k1 = z + rand.nextInt(size);
            int l1 = j1;
            int i2 = k1;
            for (int k2 = 0; k2 < 4; ++k2) {
                BlockPos pos = NPCSpawning.getTopSolidOrLiquidBlock((IWorld)level, CustomEntities.entityCustomNpc, 0, k1);
                if (!NPCSpawning.canCreatureTypeSpawnAtLocation(data, level, pos)) {
                    j1 += rand.nextInt(5) - rand.nextInt(5);
                    k1 += rand.nextInt(5) - rand.nextInt(5);
                    while (j1 < x || j1 >= x + size || k1 < z || k1 >= z + size) {
                        j1 = l1 + rand.nextInt(5) - rand.nextInt(5);
                        k1 = i2 + rand.nextInt(5) - rand.nextInt(5);
                    }
                    continue;
                }
                if (NPCSpawning.spawnData(data, level, pos)) continue block0;
            }
        }
    }

    private static boolean spawnData(SpawnData data, World level, BlockPos pos) {
        MobEntity entityliving;
        try {
            Entity entity = EntityType.func_220330_a((CompoundNBT)data.compound1, (World)level).orElse(null);
            if (entity == null || !(entity instanceof MobEntity)) {
                return false;
            }
            entityliving = (MobEntity)entity;
            if (entity instanceof EntityCustomNpc) {
                EntityCustomNpc npc = (EntityCustomNpc)entity;
                npc.stats.spawnCycle = 4;
                npc.stats.respawnTime = 0;
                npc.ais.returnToStart = false;
                npc.ais.setStartPos(pos);
            }
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, level.field_73012_v.nextFloat() * 360.0f, 0.0f);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((MobEntity)entityliving, (IWorld)level, (double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), null, (SpawnReason)SpawnReason.NATURAL);
        if (canSpawn == Event.Result.DENY || canSpawn == Event.Result.DEFAULT && !entityliving.func_213380_a((IWorld)level, SpawnReason.NATURAL)) {
            return false;
        }
        level.func_217376_c((Entity)entityliving);
        return true;
    }

    public static boolean canCreatureTypeSpawnAtLocation(SpawnData data, World level, BlockPos pos) {
        if (!level.func_175723_af().func_177746_a(pos)) {
            return false;
        }
        if (data.type == 1 && level.func_217298_h(pos) > 8 || data.type == 2 && level.func_217298_h(pos) <= 8) {
            return false;
        }
        BlockState state = level.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (data.liquid) {
            return state.func_185904_a().func_76224_d() && level.func_180495_p(pos.func_177977_b()).func_185904_a().func_76224_d() && !level.func_180495_p(pos.func_177984_a()).func_215686_e((IBlockReader)level, pos.func_177984_a());
        }
        BlockPos blockpos1 = pos.func_177977_b();
        BlockState state1 = level.func_180495_p(blockpos1);
        Block block1 = state1.func_177230_c();
        boolean flag = block1 != Blocks.field_150357_h && block1 != Blocks.field_180401_cv;
        BlockPos down = blockpos1.func_177977_b();
        return (flag |= level.func_180495_p(down).func_177230_c().canCreatureSpawn(level.func_180495_p(down), (IBlockReader)level, down, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, CustomEntities.entityCustomNpc)) && !state.func_185897_m() && !state.func_185904_a().func_76224_d() && !level.func_180495_p(pos.func_177984_a()).func_185897_m();
    }

    private static BlockPos getTopSolidOrLiquidBlock(IWorld p_208498_0_, @Nullable EntityType<? extends LivingEntity> p_208498_1_, int p_208498_2_, int p_208498_3_) {
        BlockPos blockpos = new BlockPos(p_208498_2_, p_208498_0_.func_201676_a(EntitySpawnPlacementRegistry.func_209342_b(p_208498_1_), p_208498_2_, p_208498_3_), p_208498_3_);
        BlockPos blockpos1 = blockpos.func_177977_b();
        return p_208498_0_.func_180495_p(blockpos1).func_196957_g((IBlockReader)p_208498_0_, blockpos1, PathType.LAND) ? blockpos1 : blockpos;
    }
}

