/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.WrapperEntityData;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.VisibilityController;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.ItemSoulstoneEmpty;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketGuiCloneOpen;
import noppes.npcs.packets.client.PacketGuiOpen;
import noppes.npcs.packets.client.PacketMarkData;
import noppes.npcs.quests.QuestKill;

public class ServerEventsHandler {
    public static VillagerEntity Merchant;

    @SubscribeEvent
    public void invoke(PlayerInteractEvent.EntityInteract event) {
        ItemStack item = event.getPlayer().func_184614_ca();
        if (item == null) {
            return;
        }
        boolean isClientSide = event.getPlayer().field_70170_p.field_72995_K;
        boolean npcInteracted = event.getTarget() instanceof EntityNPCInterface;
        if (!isClientSide && CustomNpcs.OpsOnly && !event.getPlayer().func_184102_h().func_184103_al().func_152596_g(event.getPlayer().func_146103_bH())) {
            return;
        }
        if (!isClientSide && item.func_77973_b() == CustomItems.soulstoneEmpty && event.getTarget() instanceof LivingEntity) {
            ((ItemSoulstoneEmpty)item.func_77973_b()).store((LivingEntity)event.getTarget(), item, event.getPlayer());
        }
        if (item.func_77973_b() == CustomItems.wand && npcInteracted && !isClientSide) {
            if (!CustomNpcsPermissions.hasPermission(event.getPlayer(), CustomNpcsPermissions.NPC_GUI)) {
                return;
            }
            event.setCanceled(true);
            NoppesUtilServer.sendOpenGui(event.getPlayer(), EnumGuiType.MainMenuDisplay, (EntityNPCInterface)event.getTarget());
        } else if (item.func_77973_b() == CustomItems.cloner && !isClientSide && !(event.getTarget() instanceof PlayerEntity)) {
            CompoundNBT compound = new CompoundNBT();
            if (!event.getTarget().func_184198_c(compound)) {
                return;
            }
            PlayerData data = PlayerData.get(event.getPlayer());
            ServerCloneController.Instance.cleanTags(compound);
            Packets.send((ServerPlayerEntity)event.getPlayer(), new PacketGuiCloneOpen(compound));
            data.cloned = compound;
            event.setCanceled(true);
        } else if (item.func_77973_b() == CustomItems.scripter && !isClientSide && npcInteracted) {
            if (!CustomNpcsPermissions.hasPermission(event.getPlayer(), CustomNpcsPermissions.NPC_GUI)) {
                return;
            }
            NoppesUtilServer.setEditingNpc(event.getPlayer(), (EntityNPCInterface)event.getTarget());
            event.setCanceled(true);
            Packets.send((ServerPlayerEntity)event.getPlayer(), new PacketGuiOpen(EnumGuiType.Script, BlockPos.field_177992_a));
        } else if (item.func_77973_b() == CustomItems.mount) {
            if (!CustomNpcsPermissions.hasPermission(event.getPlayer(), CustomNpcsPermissions.TOOL_MOUNTER)) {
                return;
            }
            PlayerData data = PlayerData.get(event.getPlayer());
            event.setCanceled(true);
            data.mounted = event.getTarget();
            if (isClientSide) {
                CustomNpcs.proxy.openGui(event.getPlayer(), EnumGuiType.MobSpawnerMounter);
            }
        } else if (item.func_77973_b() == CustomItems.wand && event.getTarget() instanceof VillagerEntity) {
            if (!CustomNpcsPermissions.hasPermission(event.getPlayer(), CustomNpcsPermissions.EDIT_VILLAGER)) {
                return;
            }
            event.setCanceled(true);
            Merchant = (VillagerEntity)event.getTarget();
            if (!isClientSide) {
                ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)event.getPlayer();
            }
        }
    }

    @SubscribeEvent
    public void invoke(LivingDeathEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        Entity source = NoppesUtilServer.GetDamageSourcee(event.getSource());
        if (source != null) {
            if (source instanceof EntityNPCInterface && event.getEntityLiving() != null) {
                EntityNPCInterface npc = (EntityNPCInterface)source;
                Line line = npc.advanced.getKillLine();
                if (line != null) {
                    npc.saySurrounding(Line.formatTarget(line, event.getEntityLiving()));
                }
                EventHooks.onNPCKills(npc, event.getEntityLiving());
            }
            PlayerEntity player = null;
            if (source instanceof PlayerEntity) {
                player = (PlayerEntity)source;
            } else if (source instanceof EntityNPCInterface && ((EntityNPCInterface)source).getOwner() instanceof PlayerEntity) {
                player = (PlayerEntity)((EntityNPCInterface)source).getOwner();
            }
            if (player != null) {
                this.doQuest(player, event.getEntityLiving(), true);
                if (event.getEntityLiving() instanceof EntityNPCInterface) {
                    this.doFactionPoints(player, (EntityNPCInterface)event.getEntityLiving());
                }
            }
        }
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerData data = PlayerData.get((PlayerEntity)event.getEntityLiving());
            data.save(false);
        }
    }

    private void doFactionPoints(PlayerEntity player, EntityNPCInterface npc) {
        npc.advanced.factions.addPoints(player);
    }

    private void doQuest(PlayerEntity player, LivingEntity entity, boolean all) {
        PlayerData pdata = PlayerData.get(player);
        PlayerQuestData playerdata = pdata.questData;
        String entityName = entity.func_70022_Q();
        if (entity instanceof PlayerEntity) {
            entityName = "Player";
        }
        for (QuestData data : playerdata.activeQuests.values()) {
            if (data.quest.type != 2 && data.quest.type != 4) continue;
            if (data.quest.type == 4 && all) {
                List list = player.field_70170_p.func_217357_a(PlayerEntity.class, entity.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0));
                for (PlayerEntity pl : list) {
                    if (pl == player) continue;
                    this.doQuest(pl, entity, false);
                }
            }
            String name = entityName;
            QuestKill quest = (QuestKill)data.quest.questInterface;
            if (quest.targets.containsKey(entity.func_200200_C_().getString())) {
                name = entity.func_200200_C_().getString();
            } else if (!quest.targets.containsKey(name)) continue;
            HashMap<String, Integer> killed = quest.getKilled(data);
            if (killed.containsKey(name) && killed.get(name) >= quest.targets.get(name)) continue;
            int amount = 0;
            if (killed.containsKey(name)) {
                amount = killed.get(name);
            }
            killed.put(name, amount + 1);
            quest.setKilled(data, killed);
            pdata.updateClient = true;
        }
        playerdata.checkQuestCompletion(player, 2);
        playerdata.checkQuestCompletion(player, 4);
    }

    @SubscribeEvent
    public void world(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K || !(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerData data = PlayerData.get((PlayerEntity)event.getEntity());
        data.updateCompanion(event.getWorld());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void attachEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            PlayerData.register(event);
        }
        if (event.getObject() instanceof LivingEntity) {
            MarkData.register(event);
        }
        if (((Entity)event.getObject()).field_70170_p != null && !((Entity)event.getObject()).field_70170_p.field_72995_K && ((Entity)event.getObject()).field_70170_p instanceof ServerWorld) {
            WrapperEntityData.register(event);
        }
    }

    @SubscribeEvent
    public void attachItem(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStackWrapper.register(event);
    }

    @SubscribeEvent
    public void savePlayer(PlayerEvent.SaveToFile event) {
        PlayerData.get(event.getPlayer()).save(false);
    }

    @SubscribeEvent
    public void saveChunk(ChunkDataEvent.Save event) {
        if (!(event.getChunk() instanceof Chunk)) {
            return;
        }
        for (ClassInheritanceMultiMap map : ((Chunk)event.getChunk()).func_177429_s()) {
            for (Entity e : map) {
                if (!(e instanceof LivingEntity)) continue;
                MarkData.get((LivingEntity)e).save();
            }
        }
    }

    @SubscribeEvent
    public void playerTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)event.getTarget();
            npc.tracking.add(event.getPlayer().func_145782_y());
            VisibilityController.checkIsVisible(npc, (ServerPlayerEntity)event.getPlayer());
        }
        if (!(event.getTarget() instanceof LivingEntity) || event.getTarget().field_70170_p.field_72995_K) {
            return;
        }
        MarkData data = MarkData.get((LivingEntity)event.getTarget());
        if (data.marks.isEmpty()) {
            return;
        }
        Packets.send((ServerPlayerEntity)event.getPlayer(), new PacketMarkData(event.getTarget().func_145782_y(), data.getNBT()));
    }

    @SubscribeEvent
    public void playerStopTracking(PlayerEvent.StopTracking event) {
        if (event.getTarget() instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)event.getTarget();
            npc.tracking.remove(event.getPlayer().func_145782_y());
        }
    }

    @SubscribeEvent
    public void commandGive(CommandEvent event) {
        String command = event.getParseResults().getReader().getString();
        if (!command.startsWith("/give ")) {
            return;
        }
        try {
            CommandContext context = event.getParseResults().getContext().build(event.getParseResults().getReader().getString());
            Collection players = EntityArgument.func_197090_e((CommandContext)context, (String)"targets");
            for (ServerPlayerEntity player : players) {
                player.func_184102_h().execute((Runnable)ListenableFutureTask.create(Executors.callable(() -> {
                    PlayerQuestData playerdata = PlayerData.get((PlayerEntity)player).questData;
                    playerdata.checkQuestCompletion((PlayerEntity)player, 0);
                })));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void commandTime(CommandEvent event) {
        String command = event.getParseResults().getReader().getString();
        if (!command.startsWith("/time ")) {
            return;
        }
        try {
            List players = CustomNpcs.Server.func_184103_al().func_181057_v();
            for (ServerPlayerEntity playerMP : players) {
                VisibilityController.instance.onUpdate(playerMP);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

