/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SScoreboardObjectivePacket;
import net.minecraft.network.play.server.SUpdateScorePacket;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import noppes.npcs.CustomItems;
import noppes.npcs.NPCSpawning;
import noppes.npcs.client.AnalyticsTracking;
import noppes.npcs.controllers.MassBlockController;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.VisibilityController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.entity.data.DataScenes;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketSync;

public class ServerTickHandler {
    public int ticks = 0;

    @SubscribeEvent
    public void onServerTick(TickEvent.PlayerTickEvent event) {
        if (event.side != LogicalSide.SERVER || event.phase != TickEvent.Phase.START) {
            return;
        }
        PlayerEntity player = event.player;
        PlayerData data = PlayerData.get(player);
        if (player.func_130014_f_().func_72820_D() % 24000L == 1L || player.func_130014_f_().func_72820_D() % 240000L == 12001L) {
            VisibilityController.instance.onUpdate((ServerPlayerEntity)player);
        }
        if (data.updateClient) {
            Packets.send((ServerPlayerEntity)player, new PacketSync(8, data.getSyncNBT(), true));
            VisibilityController.instance.onUpdate((ServerPlayerEntity)player);
            data.updateClient = false;
        }
        if (data.prevHeldItem != player.func_184614_ca() && (data.prevHeldItem.func_77973_b() == CustomItems.wand || player.func_184614_ca().func_77973_b() == CustomItems.wand)) {
            VisibilityController.instance.onUpdate((ServerPlayerEntity)player);
        }
        data.prevHeldItem = player.func_184614_ca();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.WorldTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START) {
            NPCSpawning.findChunksForSpawning((ServerWorld)event.world);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START && this.ticks++ >= 20) {
            SchematicController.Instance.updateBuilding();
            MassBlockController.Update();
            this.ticks = 0;
            for (DataScenes.SceneState state : DataScenes.StartedScenes.values()) {
                if (state.paused) continue;
                ++state.ticks;
            }
            for (DataScenes.SceneContainer entry : DataScenes.ScenesToRun) {
                entry.update();
            }
            DataScenes.ScenesToRun = new ArrayList<DataScenes.SceneContainer>();
        }
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        final ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        MinecraftServer server = event.getPlayer().func_184102_h();
        for (ServerWorld level : server.forgeGetWorldMap().values()) {
            ServerScoreboard board = level.func_96441_U();
            for (String objective : Availability.scores) {
                ScoreObjective so = board.func_96518_b(objective);
                if (so == null) continue;
                if (board.func_96552_h(so) == 0) {
                    player.field_71135_a.func_147359_a((IPacket)new SScoreboardObjectivePacket(so, 0));
                }
                Score sco = board.func_96529_a(player.func_195047_I_(), so);
                player.field_71135_a.func_147359_a((IPacket)new SUpdateScorePacket(ServerScoreboard.Action.CHANGE, sco.func_96645_d().func_96679_b(), sco.func_96653_e(), sco.func_96652_c()));
            }
        }
        player.field_71069_bz.func_75132_a(new IContainerListener(){

            public void func_71110_a(Container container, NonNullList<ItemStack> itemsList) {
            }

            public void func_71111_a(Container container, int slotInd, ItemStack stack) {
                if (player.field_70170_p.field_72995_K) {
                    return;
                }
                PlayerQuestData playerdata = PlayerData.get((PlayerEntity)player).questData;
                playerdata.checkQuestCompletion((PlayerEntity)player, 0);
            }

            public void func_71112_a(Container container, int varToUpdate, int newValue) {
            }
        });
        PlayerData data = PlayerData.get(event.getPlayer());
        String serverName = "local";
        if (server.func_71262_S()) {
            serverName = "server";
        } else if (server.func_71344_c()) {
            serverName = "lan";
        }
        AnalyticsTracking.sendData(data.iAmStealingYourDatas, "join", serverName);
        SyncController.syncPlayer((ServerPlayerEntity)event.getPlayer());
    }
}

