/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IRayTrace;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IEntityItem;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.api.wrapper.RayTraceWrapper;
import noppes.npcs.controllers.ServerCloneController;

public class EntityWrapper<T extends Entity>
implements IEntity {
    protected T entity;
    private Map<String, Object> tempData = new HashMap<String, Object>();
    private IWorld levelWrapper;
    private final IData tempdata = new IData(){

        @Override
        public void put(String key, Object value) {
            EntityWrapper.this.tempData.put(key, value);
        }

        @Override
        public Object get(String key) {
            return EntityWrapper.this.tempData.get(key);
        }

        @Override
        public void remove(String key) {
            EntityWrapper.this.tempData.remove(key);
        }

        @Override
        public boolean has(String key) {
            return EntityWrapper.this.tempData.containsKey(key);
        }

        @Override
        public void clear() {
            EntityWrapper.this.tempData.clear();
        }

        @Override
        public String[] getKeys() {
            return EntityWrapper.this.tempData.keySet().toArray(new String[EntityWrapper.this.tempData.size()]);
        }
    };
    private final IData storeddata = new IData(){

        @Override
        public void put(String key, Object value) {
            CompoundNBT compound = this.getStoredCompound();
            if (value instanceof Number) {
                compound.func_74780_a(key, ((Number)value).doubleValue());
            } else if (value instanceof String) {
                compound.func_74778_a(key, (String)value);
            }
            this.saveStoredCompound(compound);
        }

        @Override
        public Object get(String key) {
            CompoundNBT compound = this.getStoredCompound();
            if (!compound.func_74764_b(key)) {
                return null;
            }
            INBT base = compound.func_74781_a(key);
            if (base instanceof NumberNBT) {
                return ((NumberNBT)base).func_150286_g();
            }
            return ((StringNBT)base).func_150285_a_();
        }

        @Override
        public void remove(String key) {
            CompoundNBT compound = this.getStoredCompound();
            compound.func_82580_o(key);
            this.saveStoredCompound(compound);
        }

        @Override
        public boolean has(String key) {
            return this.getStoredCompound().func_74764_b(key);
        }

        @Override
        public void clear() {
            EntityWrapper.this.entity.getPersistentData().func_82580_o("CNPCStoredData");
        }

        private CompoundNBT getStoredCompound() {
            CompoundNBT compound = EntityWrapper.this.entity.getPersistentData().func_74775_l("CNPCStoredData");
            if (compound == null) {
                compound = new CompoundNBT();
                EntityWrapper.this.entity.getPersistentData().func_218657_a("CNPCStoredData", (INBT)compound);
            }
            return compound;
        }

        private void saveStoredCompound(CompoundNBT compound) {
            EntityWrapper.this.entity.getPersistentData().func_218657_a("CNPCStoredData", (INBT)compound);
        }

        @Override
        public String[] getKeys() {
            CompoundNBT compound = this.getStoredCompound();
            return compound.func_150296_c().toArray(new String[compound.func_150296_c().size()]);
        }
    };

    public EntityWrapper(T entity) {
        this.entity = entity;
        this.levelWrapper = NpcAPI.Instance().getIWorld((ServerWorld)((Entity)entity).field_70170_p);
    }

    @Override
    public double getX() {
        return this.entity.func_226277_ct_();
    }

    @Override
    public void setX(double x) {
        this.entity.func_70107_b(x, this.entity.func_226278_cu_(), this.entity.func_226281_cx_());
    }

    @Override
    public double getY() {
        return this.entity.func_226278_cu_();
    }

    @Override
    public void setY(double y) {
        this.entity.func_70107_b(this.entity.func_226277_ct_(), y, this.entity.func_226281_cx_());
    }

    @Override
    public double getZ() {
        return this.entity.func_226281_cx_();
    }

    @Override
    public void setZ(double z) {
        this.entity.func_70107_b(this.entity.func_226277_ct_(), this.entity.func_226278_cu_(), z);
    }

    @Override
    public int getBlockX() {
        return MathHelper.func_76128_c((double)this.entity.func_226277_ct_());
    }

    @Override
    public int getBlockY() {
        return MathHelper.func_76128_c((double)this.entity.func_226278_cu_());
    }

    @Override
    public int getBlockZ() {
        return MathHelper.func_76128_c((double)this.entity.func_226281_cx_());
    }

    @Override
    public String getEntityName() {
        String s = this.entity.func_200600_R().func_210760_d();
        return LanguageMap.func_74808_a().func_230503_a_(s);
    }

    @Override
    public String getName() {
        return this.entity.func_200200_C_().getString();
    }

    @Override
    public void setName(String name) {
        this.entity.func_200203_b((ITextComponent)new StringTextComponent(name));
    }

    @Override
    public boolean hasCustomName() {
        return this.entity.func_145818_k_();
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.entity.func_70107_b(x, y, z);
    }

    @Override
    public IWorld getWorld() {
        if (((Entity)this.entity).field_70170_p != this.levelWrapper.getMCWorld()) {
            this.levelWrapper = NpcAPI.Instance().getIWorld((ServerWorld)((Entity)this.entity).field_70170_p);
        }
        return this.levelWrapper;
    }

    @Override
    public boolean isAlive() {
        return this.entity.func_70089_S();
    }

    @Override
    public IData getTempdata() {
        return this.tempdata;
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public long getAge() {
        return ((Entity)this.entity).field_70173_aa;
    }

    @Override
    public void damage(float amount) {
        this.entity.func_70097_a(DamageSource.field_76377_j, amount);
    }

    @Override
    public void despawn() {
        ((Entity)this.entity).field_70128_L = true;
    }

    @Override
    public void spawn() {
        if (this.levelWrapper.getMCWorld().func_217461_a(this.entity.func_110124_au()) != null) {
            throw new CustomNPCsException("Entity is already spawned", new Object[0]);
        }
        ((Entity)this.entity).field_70128_L = false;
        this.levelWrapper.getMCWorld().func_217376_c(this.entity);
    }

    @Override
    public void kill() {
        this.entity.func_70106_y();
    }

    @Override
    public boolean inWater() {
        return ((Entity)this.entity).field_70170_p.func_234853_a_(this.entity.func_174813_aQ()).anyMatch(state -> state.func_185904_a() == Material.field_151586_h);
    }

    @Override
    public boolean inLava() {
        return ((Entity)this.entity).field_70170_p.func_234853_a_(this.entity.func_174813_aQ()).anyMatch(state -> state.func_185904_a() == Material.field_151587_i);
    }

    @Override
    public boolean inFire() {
        return ((Entity)this.entity).field_70170_p.func_234853_a_(this.entity.func_174813_aQ()).anyMatch(state -> state.func_185904_a() == Material.field_151581_o);
    }

    @Override
    public boolean isBurning() {
        return this.entity.func_70027_ad();
    }

    @Override
    public void setBurning(int ticks) {
        this.entity.func_241209_g_(ticks);
    }

    @Override
    public void extinguish() {
        this.entity.func_70066_B();
    }

    @Override
    public String getTypeName() {
        return this.entity.func_70022_Q();
    }

    @Override
    public IEntityItem dropItem(IItemStack item) {
        return (IEntityItem)NpcAPI.Instance().getIEntity((Entity)this.entity.func_70099_a(item.getMCItemStack(), 0.0f));
    }

    @Override
    public IEntity[] getRiders() {
        List list = this.entity.func_184188_bt();
        IEntity[] riders = new IEntity[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            riders[i] = NpcAPI.Instance().getIEntity((Entity)list.get(i));
        }
        return riders;
    }

    @Override
    public IRayTrace rayTraceBlock(double distance, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox) {
        Vector3d vec3d = this.entity.func_174824_e(1.0f);
        Vector3d vec3d1 = this.entity.func_70676_i(1.0f);
        Vector3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * distance, vec3d1.field_72448_b * distance, vec3d1.field_72449_c * distance);
        BlockRayTraceResult result = ((Entity)this.entity).field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d2, RayTraceContext.BlockMode.OUTLINE, stopOnLiquid ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE, this.entity));
        if (result.func_216346_c() == RayTraceResult.Type.MISS) {
            return null;
        }
        BlockRayTraceResult br = result;
        return new RayTraceWrapper(NpcAPI.Instance().getIBlock(((Entity)this.entity).field_70170_p, br.func_216350_a()), br.func_216354_b().func_176745_a());
    }

    @Override
    public IEntity[] rayTraceEntities(double distance, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox) {
        Vector3d vec3d = this.entity.func_174824_e(1.0f);
        Vector3d vec3d1 = this.entity.func_70676_i(1.0f);
        Vector3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * distance, vec3d1.field_72448_b * distance, vec3d1.field_72449_c * distance);
        BlockRayTraceResult result = ((Entity)this.entity).field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d2, RayTraceContext.BlockMode.COLLIDER, stopOnLiquid ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE, this.entity));
        if (result.func_216346_c() != RayTraceResult.Type.MISS) {
            vec3d2 = result.func_216347_e();
        }
        return this.findEntityOnPath(distance, vec3d, vec3d2);
    }

    private IEntity[] findEntityOnPath(double distance, Vector3d vec3d, Vector3d vec3d1) {
        List list = ((Entity)this.entity).field_70170_p.func_72839_b(this.entity, this.entity.func_174813_aQ().func_186662_g(distance));
        ArrayList<IEntity> result = new ArrayList<IEntity>();
        for (Entity entity1 : list) {
            AxisAlignedBB axisalignedbb;
            Optional optional;
            if (!entity1.func_241845_aY() || entity1 == this.entity || !(optional = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y())).func_216365_b(vec3d, vec3d1)).isPresent()) continue;
            result.add(NpcAPI.Instance().getIEntity(entity1));
        }
        result.sort((o1, o2) -> {
            double d2;
            double d1 = this.entity.func_70068_e(o1.getMCEntity());
            if (d1 == (d2 = this.entity.func_70068_e(o2.getMCEntity()))) {
                return 0;
            }
            return d1 > d2 ? 1 : -1;
        });
        return result.toArray(new IEntity[result.size()]);
    }

    @Override
    public IEntity[] getAllRiders() {
        ArrayList list = new ArrayList(this.entity.func_184182_bu());
        IEntity[] riders = new IEntity[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            riders[i] = NpcAPI.Instance().getIEntity((Entity)list.get(i));
        }
        return riders;
    }

    @Override
    public void addRider(IEntity entity) {
        if (entity != null) {
            entity.getMCEntity().func_184205_a(this.entity, true);
        }
    }

    @Override
    public void clearRiders() {
        this.entity.func_184226_ay();
    }

    @Override
    public IEntity getMount() {
        return NpcAPI.Instance().getIEntity(this.entity.func_184187_bx());
    }

    @Override
    public void setMount(IEntity entity) {
        if (entity == null) {
            this.entity.func_184210_p();
        } else {
            this.entity.func_184205_a(entity.getMCEntity(), true);
        }
    }

    @Override
    public void setRotation(float rotation) {
        ((Entity)this.entity).field_70177_z = rotation;
    }

    @Override
    public float getRotation() {
        return ((Entity)this.entity).field_70177_z;
    }

    @Override
    public void setPitch(float rotation) {
        ((Entity)this.entity).field_70125_A = rotation;
    }

    @Override
    public float getPitch() {
        return ((Entity)this.entity).field_70125_A;
    }

    @Override
    public void knockback(int power, float direction) {
        float v = direction * (float)Math.PI / 180.0f;
        this.entity.func_70024_g((double)(-MathHelper.func_76126_a((float)v) * (float)power), 0.1 + (double)((float)power * 0.04f), (double)(MathHelper.func_76134_b((float)v) * (float)power));
        this.entity.func_213317_d(this.entity.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
        ((Entity)this.entity).field_70133_I = true;
    }

    @Override
    public boolean isSneaking() {
        return this.entity.func_213453_ef();
    }

    @Override
    public boolean isSprinting() {
        return this.entity.func_70051_ag();
    }

    @Override
    public T getMCEntity() {
        return this.entity;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public boolean typeOf(int type) {
        return type == this.getType();
    }

    @Override
    public String getUUID() {
        return this.entity.func_110124_au().toString();
    }

    @Override
    public String generateNewUUID() {
        UUID id = UUID.randomUUID();
        this.entity.func_184221_a(id);
        return id.toString();
    }

    @Override
    public INbt getNbt() {
        return NpcAPI.Instance().getINbt(this.entity.getPersistentData());
    }

    @Override
    public void storeAsClone(int tab, String name) {
        CompoundNBT compound = new CompoundNBT();
        if (!this.entity.func_184198_c(compound)) {
            throw new CustomNPCsException("Cannot store dead entities", new Object[0]);
        }
        ServerCloneController.Instance.addClone(compound, name, tab);
    }

    @Override
    public INbt getEntityNbt() {
        CompoundNBT compound = new CompoundNBT();
        this.entity.func_189511_e(compound);
        ResourceLocation resourcelocation = EntityType.func_200718_a((EntityType)this.entity.func_200600_R());
        if (this.getType() == 1) {
            resourcelocation = new ResourceLocation("player");
        }
        if (resourcelocation != null) {
            compound.func_74778_a("id", resourcelocation.toString());
        }
        return NpcAPI.Instance().getINbt(compound);
    }

    @Override
    public void setEntityNbt(INbt nbt) {
        this.entity.func_70020_e(nbt.getMCNBT());
    }

    @Override
    public void playAnimation(int type) {
        this.levelWrapper.getMCWorld().func_72863_F().func_217216_a(this.entity, (IPacket)new SAnimateHandPacket(this.entity, type));
    }

    @Override
    public float getHeight() {
        return this.entity.func_213302_cg();
    }

    @Override
    public float getEyeHeight() {
        return this.entity.func_70047_e();
    }

    @Override
    public float getWidth() {
        return this.entity.func_213311_cf();
    }

    @Override
    public IPos getPos() {
        return new BlockPosWrapper(this.entity.func_233580_cy_());
    }

    @Override
    public void setPos(IPos pos) {
        this.entity.func_70107_b((double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f));
    }

    @Override
    public String[] getTags() {
        return this.entity.func_184216_O().toArray(new String[this.entity.func_184216_O().size()]);
    }

    @Override
    public void addTag(String tag) {
        this.entity.func_184211_a(tag);
    }

    @Override
    public boolean hasTag(String tag) {
        return this.entity.func_184216_O().contains(tag);
    }

    @Override
    public void removeTag(String tag) {
        this.entity.func_184197_b(tag);
    }

    @Override
    public double getMotionX() {
        return this.entity.func_213322_ci().field_72450_a;
    }

    @Override
    public double getMotionY() {
        return this.entity.func_213322_ci().field_72448_b;
    }

    @Override
    public double getMotionZ() {
        return this.entity.func_213322_ci().field_72449_c;
    }

    @Override
    public void setMotionX(double motion) {
        Vector3d mo = this.entity.func_213322_ci();
        if (mo.field_72450_a == motion) {
            return;
        }
        this.entity.func_213293_j(motion, mo.field_72448_b, mo.field_72449_c);
        ((Entity)this.entity).field_70133_I = true;
    }

    @Override
    public void setMotionY(double motion) {
        Vector3d mo = this.entity.func_213322_ci();
        if (mo.field_72448_b == motion) {
            return;
        }
        this.entity.func_213293_j(mo.field_72450_a, motion, mo.field_72449_c);
        ((Entity)this.entity).field_70133_I = true;
    }

    @Override
    public void setMotionZ(double motion) {
        Vector3d mo = this.entity.func_213322_ci();
        if (mo.field_72449_c == motion) {
            return;
        }
        this.entity.func_213293_j(mo.field_72450_a, mo.field_72448_b, motion);
        ((Entity)this.entity).field_70133_I = true;
    }
}

