/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import noppes.npcs.LogWriter;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.wrapper.AnimalWrapper;
import noppes.npcs.api.wrapper.ArrowWrapper;
import noppes.npcs.api.wrapper.EntityItemWrapper;
import noppes.npcs.api.wrapper.EntityLivingBaseWrapper;
import noppes.npcs.api.wrapper.EntityLivingWrapper;
import noppes.npcs.api.wrapper.EntityWrapper;
import noppes.npcs.api.wrapper.MonsterWrapper;
import noppes.npcs.api.wrapper.PixelmonWrapper;
import noppes.npcs.api.wrapper.PlayerWrapper;
import noppes.npcs.api.wrapper.ProjectileWrapper;
import noppes.npcs.api.wrapper.ThrowableWrapper;
import noppes.npcs.api.wrapper.VillagerWrapper;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.entity.EntityProjectile;

public class WrapperEntityData
implements ICapabilityProvider {
    @CapabilityInject(value=WrapperEntityData.class)
    public static Capability<WrapperEntityData> ENTITYDATA_CAPABILITY = null;
    private LazyOptional<WrapperEntityData> instance = LazyOptional.of(() -> this);
    public IEntity base;
    private static WrapperEntityData backup = new WrapperEntityData(null);
    private static final ResourceLocation key = new ResourceLocation("customnpcs", "entitydata");

    public WrapperEntityData(IEntity base) {
        this.base = base;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == ENTITYDATA_CAPABILITY) {
            return this.instance.cast();
        }
        return LazyOptional.empty();
    }

    public static IEntity get(Entity entity) {
        if (entity == null) {
            return null;
        }
        WrapperEntityData data = (WrapperEntityData)entity.getCapability(ENTITYDATA_CAPABILITY, null).orElse((Object)backup);
        if (data == null || data == backup) {
            LogWriter.warn("Unable to get EntityData for " + entity);
            return WrapperEntityData.getData((Entity)entity).base;
        }
        return data.base;
    }

    public static void register(AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(key, (ICapabilityProvider)WrapperEntityData.getData((Entity)event.getObject()));
    }

    private static WrapperEntityData getData(Entity entity) {
        if (entity == null || entity.field_70170_p == null || entity.field_70170_p.field_72995_K) {
            return null;
        }
        if (entity instanceof ServerPlayerEntity) {
            return new WrapperEntityData(new PlayerWrapper<ServerPlayerEntity>((ServerPlayerEntity)entity));
        }
        if (PixelmonHelper.isPixelmon(entity)) {
            return new WrapperEntityData(new PixelmonWrapper<TameableEntity>((TameableEntity)entity));
        }
        if (entity instanceof AnimalEntity) {
            return new WrapperEntityData(new AnimalWrapper<AnimalEntity>((AnimalEntity)entity));
        }
        if (entity instanceof MonsterEntity) {
            return new WrapperEntityData(new MonsterWrapper<MonsterEntity>((MonsterEntity)entity));
        }
        if (entity instanceof LivingEntity) {
            return new WrapperEntityData(new EntityLivingBaseWrapper<LivingEntity>((LivingEntity)entity));
        }
        if (entity instanceof MobEntity) {
            return new WrapperEntityData(new EntityLivingWrapper<MobEntity>((MobEntity)entity));
        }
        if (entity instanceof VillagerEntity) {
            return new WrapperEntityData(new VillagerWrapper<VillagerEntity>((VillagerEntity)entity));
        }
        if (entity instanceof ItemEntity) {
            return new WrapperEntityData(new EntityItemWrapper<ItemEntity>((ItemEntity)entity));
        }
        if (entity instanceof EntityProjectile) {
            return new WrapperEntityData(new ProjectileWrapper<EntityProjectile>((EntityProjectile)entity));
        }
        if (entity instanceof ThrowableEntity) {
            return new WrapperEntityData(new ThrowableWrapper<ThrowableEntity>((ThrowableEntity)entity));
        }
        if (entity instanceof AbstractArrowEntity) {
            return new WrapperEntityData(new ArrowWrapper<AbstractArrowEntity>((AbstractArrowEntity)entity));
        }
        return new WrapperEntityData(new EntityWrapper<Entity>(entity));
    }
}

