/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;
import noppes.npcs.blocks.BlockInterface;
import noppes.npcs.blocks.tiles.TileBorder;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.packets.server.SPacketGuiOpen;

public class BlockBorder
extends BlockInterface {
    public static final IntegerProperty ROTATION = IntegerProperty.func_177719_a((String)"rotation", (int)0, (int)3);

    public BlockBorder() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_180401_cv).func_200947_a(SoundType.field_185851_d));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ROTATION});
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (!level.field_72995_K && currentItem.func_77973_b() == CustomItems.wand) {
            SPacketGuiOpen.sendOpenGui(player, EnumGuiType.Border, null, pos);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_195999_j() != null) {
            int l = MathHelper.func_76128_c((double)((double)(context.func_195999_j().field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            return (BlockState)this.func_176223_P().func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(l %= 4));
        }
        return super.func_196258_a(context);
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack item) {
        TileBorder tile = (TileBorder)level.func_175625_s(pos);
        TileBorder adjacent = this.getTile(level, pos.func_177976_e());
        if (adjacent == null) {
            adjacent = this.getTile(level, pos.func_177968_d());
        }
        if (adjacent == null) {
            adjacent = this.getTile(level, pos.func_177978_c());
        }
        if (adjacent == null) {
            adjacent = this.getTile(level, pos.func_177974_f());
        }
        if (adjacent != null) {
            CompoundNBT compound = new CompoundNBT();
            adjacent.writeExtraNBT(compound);
            tile.readExtraNBT(compound);
        }
        tile.rotation = (Integer)state.func_177229_b((Property)ROTATION);
        if (!level.field_72995_K && entity instanceof PlayerEntity) {
            SPacketGuiOpen.sendOpenGui((PlayerEntity)entity, EnumGuiType.Border, null, pos);
        }
    }

    private TileBorder getTile(World level, BlockPos pos) {
        TileEntity tile = level.func_175625_s(pos);
        if (tile != null && tile instanceof TileBorder) {
            return (TileBorder)tile;
        }
        return null;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileBorder();
    }
}

