/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomItems;
import noppes.npcs.EventHooks;
import noppes.npcs.blocks.BlockNpcDoorInterface;
import noppes.npcs.blocks.tiles.TileScriptedDoor;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.packets.server.SPacketGuiOpen;

public class BlockScriptedDoor
extends BlockNpcDoorInterface {
    public BlockScriptedDoor() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150454_av).func_200948_a(5.0f, 10.0f));
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)CustomBlocks.scripted_door_item);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileScriptedDoor();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        BlockState iblockstate1;
        if (level.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        BlockPos blockpos1 = state.func_177229_b((Property)field_176523_O) == DoubleBlockHalf.LOWER ? pos : pos.func_177977_b();
        BlockState blockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : level.func_180495_p(blockpos1);
        if (iblockstate1.func_177230_c() != this) {
            return ActionResultType.FAIL;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem != null && (currentItem.func_77973_b() == CustomItems.wand || currentItem.func_77973_b() == CustomItems.scripter || currentItem.func_77973_b() == CustomBlocks.scripted_door_item)) {
            PlayerData data = PlayerData.get(player);
            data.scriptBlockPos = pos;
            SPacketGuiOpen.sendOpenGui(player, EnumGuiType.ScriptDoor, null, blockpos1);
            return ActionResultType.SUCCESS;
        }
        TileScriptedDoor tile = (TileScriptedDoor)level.func_175625_s(blockpos1);
        Vector3d vec = ray.func_216347_e();
        float x = (float)(vec.field_72450_a - (double)pos.func_177958_n());
        float y = (float)(vec.field_72448_b - (double)pos.func_177956_o());
        float z = (float)(vec.field_72449_c - (double)pos.func_177952_p());
        if (EventHooks.onScriptBlockInteract(tile, player, ray.func_216354_b().func_176745_a(), x, y, z)) {
            return ActionResultType.FAIL;
        }
        this.func_242663_a(level, iblockstate1, blockpos1, ((Boolean)iblockstate1.func_177229_b((Property)DoorBlock.field_176519_b)).equals(false));
        return ActionResultType.SUCCESS;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos pos2, boolean isMoving) {
        if (state.func_177229_b((Property)field_176523_O) == DoubleBlockHalf.UPPER) {
            BlockPos blockpos1 = pos.func_177977_b();
            BlockState iblockstate1 = worldIn.func_180495_p(blockpos1);
            if (iblockstate1.func_177230_c() != this) {
                worldIn.func_217377_a(pos, false);
            } else if (neighborBlock != this) {
                this.func_220069_a(iblockstate1, worldIn, blockpos1, neighborBlock, blockpos1, isMoving);
            }
        } else {
            BlockPos blockpos2 = pos.func_177984_a();
            BlockState iblockstate2 = worldIn.func_180495_p(blockpos2);
            if (iblockstate2.func_177230_c() != this) {
                worldIn.func_217377_a(pos, false);
            } else {
                boolean flag;
                TileScriptedDoor tile = (TileScriptedDoor)worldIn.func_175625_s(pos);
                if (!worldIn.field_72995_K) {
                    EventHooks.onScriptBlockNeighborChanged(tile, pos2);
                }
                boolean bl = flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(blockpos2);
                if ((flag || neighborBlock.func_176223_P().func_185897_m()) && neighborBlock != this && flag != (Boolean)iblockstate2.func_177229_b((Property)field_176522_N)) {
                    worldIn.func_180501_a(blockpos2, (BlockState)iblockstate2.func_206870_a((Property)field_176522_N, (Comparable)Boolean.valueOf(flag)), 2);
                    if (flag != (Boolean)state.func_177229_b((Property)field_176519_b)) {
                        this.func_242663_a(worldIn, state, pos, flag);
                    }
                }
                int power = 0;
                for (Direction enumfacing : Direction.values()) {
                    int p = worldIn.func_175651_c(pos.func_177972_a(enumfacing), enumfacing);
                    if (p <= power) continue;
                    power = p;
                }
                tile.newPower = power;
            }
        }
    }

    public void func_242663_a(World worldIn, BlockState state, BlockPos pos, boolean open) {
        TileScriptedDoor tile = (TileScriptedDoor)worldIn.func_175625_s(pos);
        if (EventHooks.onScriptBlockDoorToggle(tile)) {
            return;
        }
        super.func_242663_a(worldIn, state, pos, open);
    }

    public void func_196270_a(BlockState state, World level, BlockPos pos, PlayerEntity playerIn) {
        BlockState iblockstate1;
        if (level.field_72995_K) {
            return;
        }
        BlockPos blockpos1 = state.func_177229_b((Property)field_176523_O) == DoubleBlockHalf.LOWER ? pos : pos.func_177977_b();
        BlockState blockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : level.func_180495_p(blockpos1);
        if (iblockstate1.func_177230_c() != this) {
            return;
        }
        TileScriptedDoor tile = (TileScriptedDoor)level.func_175625_s(blockpos1);
        EventHooks.onScriptBlockClicked(tile, playerIn);
    }

    @Override
    public void func_196243_a(BlockState state, World level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockState iblockstate1;
        BlockPos blockpos1 = state.func_177229_b((Property)field_176523_O) == DoubleBlockHalf.LOWER ? pos : pos.func_177977_b();
        BlockState blockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : level.func_180495_p(blockpos1);
        if (!level.field_72995_K && iblockstate1.func_177230_c() == this) {
            TileScriptedDoor tile = (TileScriptedDoor)level.func_175625_s(pos);
            EventHooks.onScriptBlockBreak(tile);
        }
        super.func_196243_a(state, level, pos, newState, isMoving);
    }

    public boolean removedByPlayer(BlockState state, World level, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        TileScriptedDoor tile;
        if (!level.field_72995_K && EventHooks.onScriptBlockHarvest(tile = (TileScriptedDoor)level.func_175625_s(pos), player)) {
            return false;
        }
        return super.removedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void func_196262_a(BlockState state, World level, BlockPos pos, Entity entityIn) {
        if (level.field_72995_K) {
            return;
        }
        TileScriptedDoor tile = (TileScriptedDoor)level.func_175625_s(pos);
        EventHooks.onScriptBlockCollide(tile, entityIn);
    }

    public void func_176208_a(World level, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockState iblockstate1;
        BlockPos blockpos1 = state.func_177229_b((Property)field_176523_O) == DoubleBlockHalf.LOWER ? pos : pos.func_177977_b();
        BlockState blockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : level.func_180495_p(blockpos1);
        if (player.field_71075_bZ.field_75098_d && iblockstate1.func_177229_b((Property)field_176523_O) == DoubleBlockHalf.LOWER && iblockstate1.func_177230_c() == this) {
            level.func_217377_a(blockpos1, false);
        }
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader level, BlockPos pos) {
        float f = ((TileScriptedDoor)level.func_175625_s((BlockPos)pos)).blockHardness;
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)level, (BlockPos)pos) ? 30 : 100;
        return player.getDigSpeed(state, pos) / f / (float)i;
    }

    public float getExplosionResistance(BlockState state, IBlockReader level, BlockPos pos, Explosion explosion) {
        return ((TileScriptedDoor)level.func_175625_s((BlockPos)pos)).blockResistance;
    }
}

