/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.tiles.TileColorable;

public abstract class TileNpcContainer
extends TileColorable
implements IInventory {
    public final NonNullList<ItemStack> inventoryContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    public int playerUsing = 0;

    public TileNpcContainer(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        ListNBT nbttaglist = compound.func_150295_c("Items", 10);
        this.inventoryContents.clear();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundNBT nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.inventoryContents.size()) continue;
            this.inventoryContents.set(j, (Object)ItemStack.func_199557_a((CompoundNBT)nbttagcompound1));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ListNBT nbttaglist = new ListNBT();
        for (int i = 0; i < this.inventoryContents.size(); ++i) {
            if (((ItemStack)this.inventoryContents.get(i)).func_190926_b()) continue;
            CompoundNBT tagCompound = new CompoundNBT();
            tagCompound.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.inventoryContents.get(i)).func_77955_b(tagCompound);
            nbttaglist.add((Object)tagCompound);
        }
        compound.func_218657_a("Items", (INBT)nbttaglist);
        return super.func_189515_b(compound);
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.playerUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public int func_70302_i_() {
        return 54;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventoryContents.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventoryContents, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return (ItemStack)this.inventoryContents.set(index, (Object)ItemStack.field_190927_a);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public abstract ITextComponent getName();

    public boolean func_70300_a(PlayerEntity player) {
        return (player.field_70128_L || this.field_145850_b.func_175625_s(this.field_174879_c) == this) && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(PlayerEntity player) {
        ++this.playerUsing;
    }

    public void func_174886_c(PlayerEntity player) {
        --this.playerUsing;
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return true;
    }

    public boolean func_191420_l() {
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            ItemStack item = this.func_70301_a(slot);
            if (NoppesUtilServer.IsItemStackNull(item) || item.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

