/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import noppes.npcs.LogWriter;
import noppes.npcs.blocks.tiles.TileBuilder;
import noppes.npcs.client.renderer.MarkRenderer;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.schematics.SchematicWrapper;
import org.lwjgl.opengl.GL11;

public class ClientEventHandler {
    private int displayList = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onRenderTick(RenderWorldLastEvent event) {
        MatrixStack matrixStack = event.getMatrixStack();
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (TileBuilder.DrawPos == null || TileBuilder.DrawPos.func_177951_i((Vector3i)player.func_233580_cy_()) > 1000000.0) {
            return;
        }
        TileEntity te = player.field_70170_p.func_175625_s(TileBuilder.DrawPos);
        if (te == null || !(te instanceof TileBuilder)) {
            return;
        }
        TileBuilder tile = (TileBuilder)te;
        SchematicWrapper schem = tile.getSchematic();
        if (schem == null) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)((double)TileBuilder.DrawPos.func_177958_n() - player.func_226277_ct_()), (double)((double)TileBuilder.DrawPos.func_177956_o() - player.func_226278_cu_() + 0.01), (double)((double)TileBuilder.DrawPos.func_177952_p() - player.func_226281_cx_()));
        RenderSystem.translatef((float)1.0f, (float)tile.yOffest, (float)1.0f);
        if (tile.rotation % 2 == 0) {
            this.drawSelectionBox(matrixStack, (IRenderTypeBuffer)buffer, new BlockPos((int)schem.schema.getWidth(), (int)schem.schema.getHeight(), (int)schem.schema.getLength()));
        } else {
            this.drawSelectionBox(matrixStack, (IRenderTypeBuffer)buffer, new BlockPos((int)schem.schema.getLength(), (int)schem.schema.getHeight(), (int)schem.schema.getWidth()));
        }
        if (TileBuilder.Compiled) {
            GL11.glCallList((int)this.displayList);
        } else {
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
            if (this.displayList >= 0) {
                GL11.glDeleteLists((int)this.displayList, (int)1);
            }
            this.displayList = GL11.glGenLists((int)1);
            GL11.glNewList((int)this.displayList, (int)4864);
            try {
                for (int i = 0; i < schem.size && i < 25000; ++i) {
                    int posX = i % schem.schema.getWidth();
                    int posZ = (i - posX) / schem.schema.getWidth() % schem.schema.getLength();
                    int posY = ((i - posX) / schem.schema.getWidth() - posZ) / schem.schema.getLength();
                    BlockState state = schem.schema.getBlockState(posX, posY, posZ);
                    if (state.func_185901_i() == BlockRenderType.INVISIBLE) continue;
                    BlockPos pos = schem.rotatePos(posX, posY, posZ, tile.rotation);
                    RenderSystem.pushMatrix();
                    RenderSystem.enableRescaleNormal();
                    RenderSystem.translatef((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
                    RenderSystem.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    state = schem.rotationState(state, tile.rotation);
                    try {
                        dispatcher.func_228791_a_(state, matrixStack, (IRenderTypeBuffer)buffer, 1, OverlayTexture.field_229196_a_);
                        if (GL11.glGetError() == 0) continue;
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    finally {
                        RenderSystem.disableRescaleNormal();
                        RenderSystem.popMatrix();
                    }
                }
            }
            catch (Exception e) {
                LogWriter.error("Error preview builder block", e);
            }
            finally {
                if (GL11.glGetError() == 0) {
                    TileBuilder.Compiled = true;
                }
            }
        }
        RenderSystem.translatef((float)-1.0f, (float)0.0f, (float)-1.0f);
        RenderSystem.popMatrix();
    }

    @SubscribeEvent
    public void post(RenderLivingEvent.Post event) {
        MarkData data = MarkData.get(event.getEntity());
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        for (MarkData.Mark m : data.marks) {
            if (m.getType() == 0 || !m.availability.isAvailable((PlayerEntity)player)) continue;
            MarkRenderer.render(event.getEntity(), event.getEntity().func_213303_ch().field_72450_a, event.getEntity().func_213303_ch().field_72448_b, event.getEntity().func_213303_ch().field_72449_c, m);
            break;
        }
    }

    public void drawSelectionBox(MatrixStack matrixStack, IRenderTypeBuffer buffer, BlockPos pos) {
        matrixStack.func_227860_a_();
        AxisAlignedBB bb = new AxisAlignedBB(BlockPos.field_177992_a, pos);
        matrixStack.func_227861_a_((double)0.001f, (double)0.001f, (double)0.001f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)buffer.getBuffer(RenderType.func_228659_m_()), (AxisAlignedBB)bb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        matrixStack.func_227865_b_();
    }
}

