/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.TextureCache;
import noppes.npcs.client.fx.EntityEnderFX;
import noppes.npcs.mixin.ParticleManagerMixin;

public class CustomNpcResourceListener
implements IResourceManagerReloadListener {
    public static int DefaultTextColor = 0x404040;

    public void func_195410_a(IResourceManager var1) {
        if (var1 instanceof SimpleReloadableResourceManager) {
            this.createTextureCache();
            SimpleReloadableResourceManager simplemanager = (SimpleReloadableResourceManager)var1;
            FolderPack pack = new FolderPack(CustomNpcs.Dir);
            simplemanager.func_199021_a((IResourcePack)pack);
            try {
                DefaultTextColor = Integer.parseInt(I18n.func_135052_a((String)"customnpcs.defaultTextColor", (Object[])new Object[0]), 16);
            }
            catch (NumberFormatException e) {
                DefaultTextColor = 0x404040;
            }
        }
        EntityEnderFX.portalSprite = ((ParticleManagerMixin)Minecraft.func_71410_x().field_71452_i).getPacks().get(Registry.field_212632_u.func_177774_c((Object)ParticleTypes.field_197599_J));
    }

    private void createTextureCache() {
        this.enlargeTexture("acacia_planks");
        this.enlargeTexture("birch_planks");
        this.enlargeTexture("crimson_planks");
        this.enlargeTexture("dark_oak_planks");
        this.enlargeTexture("jungle_planks");
        this.enlargeTexture("oak_planks");
        this.enlargeTexture("spruce_planks");
        this.enlargeTexture("warped_planks");
        this.enlargeTexture("iron_block");
        this.enlargeTexture("diamond_block");
        this.enlargeTexture("stone");
        this.enlargeTexture("gold_block");
        this.enlargeTexture("white_wool");
    }

    private void enlargeTexture(String texture) {
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        if (manager == null) {
            return;
        }
        ResourceLocation location = new ResourceLocation("customnpcs:textures/cache/" + texture + ".png");
        Object ob = manager.func_229267_b_(location);
        if (ob == null || !(ob instanceof TextureCache)) {
            ob = new TextureCache(location);
            manager.func_229263_a_(location, ob);
        }
        ((TextureCache)((Object)ob)).setImage(new ResourceLocation("textures/block/" + texture + ".png"));
    }
}

