/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.IChatMessages;
import noppes.npcs.client.TextBlockClient;
import noppes.npcs.entity.EntityNPCInterface;

public class RenderChatMessages
implements IChatMessages {
    private Map<Long, TextBlockClient> messages = new TreeMap<Long, TextBlockClient>();
    private int boxLength = 46;
    private float scale = 0.5f;
    private String lastMessage = "";
    private long lastMessageTime = 0L;

    @Override
    public void addMessage(String message, EntityNPCInterface npc) {
        if (!CustomNpcs.EnableChatBubbles) {
            return;
        }
        long time = System.currentTimeMillis();
        if (message.equals(this.lastMessage) && this.lastMessageTime + 5000L > time) {
            return;
        }
        TreeMap<Long, TextBlockClient> messages = new TreeMap<Long, TextBlockClient>(this.messages);
        messages.put(time, new TextBlockClient(message, this.boxLength * 4, true, new Object[]{Minecraft.func_71410_x().field_71439_g, npc}));
        if (messages.size() > 3) {
            messages.remove(messages.keySet().iterator().next());
        }
        this.messages = messages;
        this.lastMessage = message;
        this.lastMessageTime = time;
    }

    @Override
    public void renderMessages(MatrixStack matrixStack, float textscale, boolean inRange) {
        Map<Long, TextBlockClient> messages = this.getMessages();
        if (messages.isEmpty()) {
            return;
        }
        if (inRange) {
            this.render(matrixStack, textscale, false);
        }
        this.render(matrixStack, textscale, true);
    }

    private void render(MatrixStack matrixStack, float textscale, boolean depth) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        float var13 = 1.6f;
        float var14 = 0.016666668f * var13;
        RenderSystem.pushMatrix();
        int size = 0;
        for (TextBlockClient block : this.messages.values()) {
            size += block.lines.size();
        }
        Minecraft mc = Minecraft.func_71410_x();
        font.getClass();
        int textYSize = (int)((float)(size * 9) * this.scale);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)((float)textYSize * textscale * var14), 0.0);
        matrixStack.func_227862_a_(textscale, textscale, textscale);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-mc.func_175598_ae().func_229098_b_().func_195891_b()));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(mc.func_175598_ae().func_229098_b_().func_195889_a()));
        matrixStack.func_227862_a_(-var14, -var14, var14);
        int black = depth ? -16777216 : 0x55000000;
        int white = depth ? -1140850689 : 0x44FFFFFF;
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.disableTexture();
        RenderSystem.enableCull();
        this.fill(-this.boxLength - 2, -2, this.boxLength + 2, textYSize + 1, white, 0.11);
        this.fill(-this.boxLength - 1, -3, this.boxLength + 1, -2, black, 0.1);
        this.fill(-this.boxLength - 1, textYSize + 2, -1, textYSize + 1, black, 0.1);
        this.fill(3, textYSize + 2, this.boxLength + 1, textYSize + 1, black, 0.1);
        this.fill(-this.boxLength - 3, -1, -this.boxLength - 2, textYSize, black, 0.1);
        this.fill(this.boxLength + 3, -1, this.boxLength + 2, textYSize, black, 0.1);
        this.fill(-this.boxLength - 2, -2, -this.boxLength - 1, -1, black, 0.1);
        this.fill(this.boxLength + 2, -2, this.boxLength + 1, -1, black, 0.1);
        this.fill(-this.boxLength - 2, textYSize + 1, -this.boxLength - 1, textYSize, black, 0.1);
        this.fill(this.boxLength + 2, textYSize + 1, this.boxLength + 1, textYSize, black, 0.1);
        this.fill(0, textYSize + 1, 3, textYSize + 4, white, 0.11);
        this.fill(-1, textYSize + 4, 1, textYSize + 5, white, 0.11);
        this.fill(-1, textYSize + 1, 0, textYSize + 4, black, 0.1);
        this.fill(3, textYSize + 1, 4, textYSize + 3, black, 0.1);
        this.fill(2, textYSize + 3, 3, textYSize + 4, black, 0.1);
        this.fill(1, textYSize + 4, 2, textYSize + 5, black, 0.1);
        this.fill(-2, textYSize + 4, -1, textYSize + 5, black, 0.1);
        this.fill(-2, textYSize + 5, 1, textYSize + 6, black, 0.1);
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
        int index = 0;
        for (TextBlockClient block : this.messages.values()) {
            for (ITextComponent chat : block.lines) {
                String message = chat.getString();
                float f = -font.func_78256_a(message) / 2;
                font.getClass();
                font.func_238421_b_(matrixStack, message, f, (float)(index * 9), black);
                ++index;
            }
        }
        RenderSystem.disableCull();
        RenderSystem.enableLighting();
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227865_b_();
    }

    private void fill(int par0, int par1, int limbSwingAmount, int par3, int par4, double par5) {
        int j1;
        if (par0 < limbSwingAmount) {
            j1 = par0;
            par0 = limbSwingAmount;
            limbSwingAmount = j1;
        }
        if (par1 < par3) {
            j1 = par1;
            par1 = par3;
            par3 = j1;
        }
        float f = (float)(par4 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(par4 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(par4 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(par4 & 0xFF) / 255.0f;
        BufferBuilder tessellator = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.color4f((float)f1, (float)f2, (float)f3, (float)f);
        tessellator.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        tessellator.func_225582_a_((double)par0, (double)par3, par5).func_181675_d();
        tessellator.func_225582_a_((double)limbSwingAmount, (double)par3, par5).func_181675_d();
        tessellator.func_225582_a_((double)limbSwingAmount, (double)par1, par5).func_181675_d();
        tessellator.func_225582_a_((double)par0, (double)par1, par5).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    private Map<Long, TextBlockClient> getMessages() {
        TreeMap<Long, TextBlockClient> messages = new TreeMap<Long, TextBlockClient>();
        long time = System.currentTimeMillis();
        for (Map.Entry<Long, TextBlockClient> entry : this.messages.entrySet()) {
            if (time > entry.getKey() + 10000L) continue;
            messages.put(entry.getKey(), entry.getValue());
        }
        this.messages = messages;
        return this.messages;
    }
}

