/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.gui.CustomGuiTexturedRectWrapper;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;

public class CustomGuiTexturedRect
extends AbstractGui
implements IGuiComponent {
    GuiCustom parent;
    ResourceLocation texture;
    int id;
    int x;
    int y;
    int width;
    int height;
    int textureX;
    int textureY;
    float scale = 1.0f;
    List<TranslationTextComponent> hoverText;

    public CustomGuiTexturedRect(int id, String texture, int x, int y, int width, int height) {
        this(id, texture, x, y, width, height, 0, 0);
    }

    public CustomGuiTexturedRect(int id, String texture, int x, int y, int width, int height, int textureX, int textureY) {
        this.id = id;
        this.texture = new ResourceLocation(texture);
        this.x = GuiCustom.guiLeft + x;
        this.y = GuiCustom.guiTop + y;
        this.width = width;
        this.height = height;
        this.textureX = textureX;
        this.textureY = textureY;
    }

    public void setParent(GuiCustom parent) {
        this.parent = parent;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void onRender(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        boolean hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
        matrixStack.func_227865_b_();
        mc.func_110434_K().func_110577_a(this.texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)this.x, (double)((float)this.y + (float)this.height * this.scale), (double)this.id).func_225583_a_((float)(this.textureX + 0) * 0.00390625f, (float)(this.textureY + this.height) * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_((double)((float)this.x + (float)this.width * this.scale), (double)((float)this.y + (float)this.height * this.scale), (double)this.id).func_225583_a_((float)(this.textureX + this.width) * 0.00390625f, (float)(this.textureY + this.height) * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_((double)((float)this.x + (float)this.width * this.scale), (double)this.y, (double)this.id).func_225583_a_((float)(this.textureX + this.width) * 0.00390625f, (float)(this.textureY + 0) * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_((double)this.x, (double)this.y, (double)this.id).func_225583_a_((float)(this.textureX + 0) * 0.00390625f, (float)(this.textureY + 0) * 0.00390625f).func_181675_d();
        tessellator.func_78381_a();
        if (hovered && this.hoverText != null && this.hoverText.size() > 0) {
            this.parent.hoverText = this.hoverText;
        }
        matrixStack.func_227865_b_();
    }

    @Override
    public ICustomGuiComponent toComponent() {
        CustomGuiTexturedRectWrapper component = new CustomGuiTexturedRectWrapper(this.id, this.texture.toString(), this.x, this.y, this.width, this.height, this.textureX, this.textureY);
        component.setHoverText(this.hoverText);
        component.setScale(this.scale);
        return component;
    }

    public static CustomGuiTexturedRect fromComponent(CustomGuiTexturedRectWrapper component) {
        CustomGuiTexturedRect rect = component.getTextureX() >= 0 && component.getTextureY() >= 0 ? new CustomGuiTexturedRect(component.getID(), component.getTexture(), component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight(), component.getTextureX(), component.getTextureY()) : new CustomGuiTexturedRect(component.getID(), component.getTexture(), component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight());
        rect.scale = component.getScale();
        if (component.hasHoverText()) {
            rect.hoverText = component.getHoverTextList();
        }
        return rect;
    }
}

