/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.TextBlockClient;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.IGuiClose;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketDialogSelected;
import noppes.npcs.packets.server.SPacketQuestCompletionCheckAll;

public class GuiDialogInteract
extends GuiNPCInterface
implements IGuiClose {
    private Dialog dialog;
    private int selected = 0;
    private List<TextBlockClient> lines = new ArrayList<TextBlockClient>();
    private List<Integer> options = new ArrayList<Integer>();
    private int rowStart = 0;
    private int rowTotal = 0;
    private int dialogHeight = 180;
    private ResourceLocation wheel;
    private ResourceLocation[] wheelparts;
    private ResourceLocation indicator;
    private boolean isGrabbed = false;
    private int selectedX = 0;
    private int selectedY = 0;

    public GuiDialogInteract(EntityNPCInterface npc, Dialog dialog) {
        super(npc);
        this.dialog = dialog;
        this.appendDialog(dialog);
        this.imageHeight = 238;
        this.closeOnEsc = false;
        this.wheel = this.getResource("wheel.png");
        this.indicator = this.getResource("indicator.png");
        this.wheelparts = new ResourceLocation[]{this.getResource("wheel1.png"), this.getResource("wheel2.png"), this.getResource("wheel3.png"), this.getResource("wheel4.png"), this.getResource("wheel5.png"), this.getResource("wheel6.png")};
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.isGrabbed = false;
        this.grabMouse(this.dialog.showWheel);
        this.guiTop = this.field_230709_l_ - this.imageHeight;
        this.calculateRowHeight();
    }

    public void grabMouse(boolean grab) {
        if (grab && !this.isGrabbed) {
            Minecraft.func_71410_x().field_71417_B.func_198034_i();
            this.isGrabbed = true;
        } else if (!grab && this.isGrabbed) {
            Minecraft.func_71410_x().field_71417_B.func_198032_j();
            this.isGrabbed = false;
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_238468_a_(matrixStack, 0, 0, this.field_230708_k_, this.field_230709_l_, -587202560, -587202560);
        if (!this.dialog.hideNPC) {
            int l = -70;
            int i1 = this.imageHeight;
            this.drawNpc((LivingEntity)this.npc, l, i1, 1.4f, 0);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.enableAlphaTest();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.5f, (float)100.065f);
        int count = 0;
        for (TextBlockClient block : new ArrayList<TextBlockClient>(this.lines)) {
            int size = ClientProxy.Font.width(block.getName() + ": ");
            this.drawString(matrixStack, block.getName() + ": ", -4 - size, block.color, count);
            for (ITextComponent line : block.lines) {
                this.drawString(matrixStack, line.getString(), 0, block.color, count);
                ++count;
            }
            ++count;
        }
        if (!this.options.isEmpty()) {
            if (!this.dialog.showWheel) {
                this.drawLinedOptions(matrixStack, mouseY);
            } else {
                this.drawWheel(matrixStack);
            }
        }
        RenderSystem.popMatrix();
    }

    private void drawWheel(MatrixStack matrixStack) {
        int yoffset = this.guiTop + this.dialogHeight + 14;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.wheel);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 31, yoffset, 0, 0, 63, 40);
        this.selectedX = (int)((double)this.selectedX + this.field_230706_i_.field_71417_B.func_198024_e() * 0.15);
        this.selectedY = (int)((double)this.selectedY + this.field_230706_i_.field_71417_B.func_198026_f() * 0.15);
        int limit = 80;
        if (this.selectedX > limit) {
            this.selectedX = limit;
        }
        if (this.selectedX < -limit) {
            this.selectedX = -limit;
        }
        if (this.selectedY > limit) {
            this.selectedY = limit;
        }
        if (this.selectedY < -limit) {
            this.selectedY = -limit;
        }
        this.selected = 1;
        if (this.selectedY < -20) {
            ++this.selected;
        }
        if (this.selectedY > 54) {
            --this.selected;
        }
        if (this.selectedX < 0) {
            this.selected += 3;
        }
        this.field_230706_i_.func_110434_K().func_110577_a(this.wheelparts[this.selected]);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 31, yoffset, 0, 0, 85, 55);
        for (int slot : this.dialog.options.keySet()) {
            DialogOption option = this.dialog.options.get(slot);
            if (option == null || option.optionType == 2 || option.hasDialog() && !option.getDialog().availability.isAvailable((PlayerEntity)this.player)) continue;
            int color = option.optionColor;
            if (slot == this.selected) {
                color = 8622040;
            }
            int height = ClientProxy.Font.height(option.title);
            if (slot == 0) {
                GuiDialogInteract.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)option.title, (int)(this.field_230708_k_ / 2 + 13), (int)(yoffset - height), (int)color);
            }
            if (slot == 1) {
                GuiDialogInteract.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)option.title, (int)(this.field_230708_k_ / 2 + 33), (int)(yoffset - height / 2 + 14), (int)color);
            }
            if (slot == 2) {
                GuiDialogInteract.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)option.title, (int)(this.field_230708_k_ / 2 + 27), (int)(yoffset + 27), (int)color);
            }
            if (slot == 3) {
                GuiDialogInteract.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)option.title, (int)(this.field_230708_k_ / 2 - 13 - ClientProxy.Font.width(option.title)), (int)(yoffset - height), (int)color);
            }
            if (slot == 4) {
                GuiDialogInteract.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)option.title, (int)(this.field_230708_k_ / 2 - 33 - ClientProxy.Font.width(option.title)), (int)(yoffset - height / 2 + 14), (int)color);
            }
            if (slot != 5) continue;
            GuiDialogInteract.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)option.title, (int)(this.field_230708_k_ / 2 - 27 - ClientProxy.Font.width(option.title)), (int)(yoffset + 27), (int)color);
        }
        this.field_230706_i_.func_110434_K().func_110577_a(this.indicator);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 + this.selectedX / 4 - 2, yoffset + 16 - this.selectedY / 6, 0, 0, 8, 8);
    }

    private void drawLinedOptions(MatrixStack matrixStack, int j) {
        int selected;
        this.func_238465_a_(matrixStack, this.guiLeft - 60, this.guiLeft + this.imageWidth + 120, this.guiTop + this.dialogHeight - ClientProxy.Font.height(null) / 3, -1);
        int offset = this.dialogHeight;
        if (j >= this.guiTop + offset && (selected = (j - (this.guiTop + offset)) / ClientProxy.Font.height(null)) < this.options.size()) {
            this.selected = selected;
        }
        if (this.selected >= this.options.size()) {
            this.selected = 0;
        }
        if (this.selected < 0) {
            this.selected = 0;
        }
        for (int k = 0; k < this.options.size(); ++k) {
            int id = this.options.get(k);
            DialogOption option = this.dialog.options.get(id);
            int y = this.guiTop + offset + k * ClientProxy.Font.height(null);
            if (this.selected == k) {
                GuiDialogInteract.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)">", (int)(this.guiLeft - 60), (int)y, (int)0xE0E0E0);
            }
            GuiDialogInteract.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)NoppesStringUtils.formatText(option.title, new Object[]{this.player, this.npc}), (int)(this.guiLeft - 30), (int)y, (int)option.optionColor);
        }
    }

    private void drawString(MatrixStack matrixStack, String text, int left, int color, int count) {
        int height = count - this.rowStart;
        ClientProxy.Font.draw(matrixStack, text, this.guiLeft + left, this.guiTop + height * ClientProxy.Font.height(null), color);
    }

    private int getSelected() {
        if (this.selected <= 0) {
            return 0;
        }
        if (this.selected < this.options.size()) {
            return this.selected;
        }
        return this.options.size() - 1;
    }

    @Override
    public boolean func_231046_a_(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (key == this.field_230706_i_.field_71474_y.field_74351_w.getKey().func_197937_c() || key == InputMappings.func_197955_a((String)"key.keyboard.up").func_197937_c()) {
            --this.selected;
        }
        if (key == this.field_230706_i_.field_71474_y.field_74368_y.getKey().func_197937_c() || key == InputMappings.func_197955_a((String)"key.keyboard.down").func_197937_c()) {
            ++this.selected;
        }
        if (key == 257 || key == 335) {
            this.handleDialogSelection();
        }
        if (this.closeOnEsc && (key == 256 || this.isInventoryKey(key))) {
            Packets.sendServer(new SPacketDialogSelected(this.dialog.id, -1));
            this.closed();
            this.func_231175_as__();
        }
        return true;
    }

    @Override
    public boolean func_231044_a_(double i, double j, int k) {
        if ((this.selected == -1 && this.options.isEmpty() || this.selected >= 0) && k == 0) {
            this.handleDialogSelection();
        }
        return true;
    }

    private void handleDialogSelection() {
        int optionId = -1;
        if (this.dialog.showWheel) {
            optionId = this.selected;
        } else if (!this.options.isEmpty()) {
            optionId = this.options.get(this.selected);
        }
        Packets.sendServer(new SPacketDialogSelected(this.dialog.id, optionId));
        if (this.dialog == null || !this.dialog.hasOtherOptions() || this.options.isEmpty()) {
            if (this.closeOnEsc) {
                this.closed();
                this.func_231175_as__();
            }
            return;
        }
        DialogOption option = this.dialog.options.get(optionId);
        if (option == null || option.optionType != 1) {
            if (this.closeOnEsc) {
                this.closed();
                this.func_231175_as__();
            }
            return;
        }
        this.lines.add(new TextBlockClient(this.player.func_145748_c_().getString(), option.title, 280, option.optionColor, new Object[]{this.player, this.npc}));
        this.calculateRowHeight();
        NoppesUtil.clickSound();
    }

    private void closed() {
        this.grabMouse(false);
        Packets.sendServer(new SPacketQuestCompletionCheckAll());
    }

    public void appendDialog(Dialog dialog) {
        this.closeOnEsc = !dialog.disableEsc;
        this.dialog = dialog;
        this.options = new ArrayList<Integer>();
        if (dialog.sound != null && !dialog.sound.isEmpty()) {
            MusicController.Instance.stopMusic();
            BlockPos pos = this.npc.func_233580_cy_();
            MusicController.Instance.playSound(SoundCategory.VOICE, dialog.sound, pos, 1.0f, 1.0f);
        }
        this.lines.add(new TextBlockClient(this.npc.func_195051_bN(), dialog.text, 280, 0xE0E0E0, new Object[]{this.player, this.npc}));
        for (int slot : dialog.options.keySet()) {
            DialogOption option = dialog.options.get(slot);
            if (option == null || !option.isAvailable((PlayerEntity)this.player)) continue;
            this.options.add(slot);
        }
        this.calculateRowHeight();
        this.grabMouse(dialog.showWheel);
    }

    private void calculateRowHeight() {
        if (this.dialog.showWheel) {
            this.dialogHeight = this.imageHeight - 58;
        } else {
            this.dialogHeight = this.imageHeight - 3 * ClientProxy.Font.height(null) - 4;
            if (this.dialog.options.size() > 3) {
                this.dialogHeight -= (this.dialog.options.size() - 3) * ClientProxy.Font.height(null);
            }
        }
        this.rowTotal = 0;
        for (TextBlockClient block : this.lines) {
            this.rowTotal += block.lines.size() + 1;
        }
        int max = this.dialogHeight / ClientProxy.Font.height(null);
        this.rowStart = this.rowTotal - max;
        if (this.rowStart < 0) {
            this.rowStart = 0;
        }
    }

    @Override
    public void setClose(CompoundNBT data) {
        this.grabMouse(false);
    }

    @Override
    public void save() {
    }
}

