/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.client.tabs.InventoryTabFactions;
import micdoodle8.mods.galacticraft.api.client.tabs.TabRegistry;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.gui.util.GuiButtonNextPage;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiInterface;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerFactionData;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketFactionsGet;

public class GuiFaction
extends GuiNPCInterface
implements IGuiData {
    private int imageWidth = 200;
    private int imageHeight = 195;
    private int guiLeft;
    private int guiTop;
    private ArrayList<Faction> playerFactions = new ArrayList();
    private int page = 0;
    private int pages = 1;
    private GuiButtonNextPage buttonNextPage;
    private GuiButtonNextPage buttonPreviousPage;
    private ResourceLocation indicator;

    public GuiFaction() {
        this.drawDefaultBackground = false;
        this.field_230704_d_ = "";
        Packets.sendServer(new SPacketFactionsGet());
        this.indicator = this.getResource("standardbg.png");
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - this.imageWidth) / 2;
        this.guiTop = (this.field_230709_l_ - this.imageHeight) / 2 + 12;
        TabRegistry.updateTabValues(this.guiLeft, this.guiTop + 8, InventoryTabFactions.class);
        TabRegistry.addTabsToList(button -> this.func_230480_a_((Widget)button));
        this.buttonNextPage = new GuiButtonNextPage((IGuiInterface)this, 1, this.guiLeft + this.imageWidth - 43, this.guiTop + 180, true);
        this.addButton(this.buttonNextPage);
        this.buttonPreviousPage = new GuiButtonNextPage((IGuiInterface)this, 2, this.guiLeft + 20, this.guiTop + 180, false);
        this.addButton(this.buttonPreviousPage);
        this.updateButtons();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.indicator);
        this.func_238474_b_(matrixStack, this.guiLeft, this.guiTop + 8, 0, 0, this.imageWidth, this.imageHeight);
        this.func_238474_b_(matrixStack, this.guiLeft + 4, this.guiTop + 8, 56, 0, 200, this.imageHeight);
        if (this.playerFactions.isEmpty()) {
            String noFaction = I18n.func_135052_a((String)"faction.nostanding", (Object[])new Object[0]);
            this.field_230712_o_.func_238421_b_(matrixStack, noFaction, (float)(this.guiLeft + (this.imageWidth - this.field_230712_o_.func_78256_a(noFaction)) / 2), (float)(this.guiTop + 80), CustomNpcResourceListener.DefaultTextColor);
        } else {
            this.renderScreen(matrixStack);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void renderScreen(MatrixStack matrixStack) {
        int size = 5;
        if (this.playerFactions.size() % 5 != 0 && this.page == this.pages) {
            size = this.playerFactions.size() % 5;
        }
        for (int id = 0; id < size; ++id) {
            this.func_238465_a_(matrixStack, this.guiLeft + 2, this.guiLeft + this.imageWidth, this.guiTop + 14 + id * 30, -16777216 + CustomNpcResourceListener.DefaultTextColor);
            Faction faction = this.playerFactions.get((this.page - 1) * 5 + id);
            String name = faction.name;
            String points = " : " + faction.defaultPoints;
            String standing = I18n.func_135052_a((String)"faction.friendly", (Object[])new Object[0]);
            int color = 65280;
            if (faction.defaultPoints < faction.neutralPoints) {
                standing = I18n.func_135052_a((String)"faction.unfriendly", (Object[])new Object[0]);
                color = 0xFF0000;
                points = points + "/" + faction.neutralPoints;
            } else if (faction.defaultPoints < faction.friendlyPoints) {
                standing = I18n.func_135052_a((String)"faction.neutral", (Object[])new Object[0]);
                color = 0xF2FF00;
                points = points + "/" + faction.friendlyPoints;
            } else {
                points = points + "/-";
            }
            this.field_230712_o_.func_238421_b_(matrixStack, name, (float)(this.guiLeft + (this.imageWidth - this.field_230712_o_.func_78256_a(name)) / 2), (float)(this.guiTop + 19 + id * 30), faction.color);
            this.field_230712_o_.func_238421_b_(matrixStack, standing, (float)(this.field_230708_k_ / 2 - this.field_230712_o_.func_78256_a(standing) - 1), (float)(this.guiTop + 33 + id * 30), color);
            this.field_230712_o_.func_238421_b_(matrixStack, points, (float)(this.field_230708_k_ / 2), (float)(this.guiTop + 33 + id * 30), CustomNpcResourceListener.DefaultTextColor);
        }
        this.func_238465_a_(matrixStack, this.guiLeft + 2, this.guiLeft + this.imageWidth, this.guiTop + 14 + size * 30, -16777216 + CustomNpcResourceListener.DefaultTextColor);
        if (this.pages > 1) {
            String s = this.page + "/" + this.pages;
            this.field_230712_o_.func_238421_b_(matrixStack, s, (float)(this.guiLeft + (this.imageWidth - this.field_230712_o_.func_78256_a(s)) / 2), (float)(this.guiTop + 203), CustomNpcResourceListener.DefaultTextColor);
        }
    }

    @Override
    public void buttonEvent(GuiNpcButton guibutton) {
        if (!(guibutton instanceof GuiButtonNextPage)) {
            return;
        }
        int id = guibutton.id;
        if (id == 1) {
            ++this.page;
        }
        if (id == 2) {
            --this.page;
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.field_230694_p_ = this.page < this.pages;
        this.buttonPreviousPage.field_230694_p_ = this.page > 1;
    }

    @Override
    public void save() {
    }

    @Override
    public void setGuiData(CompoundNBT compound) {
        this.playerFactions = new ArrayList();
        ListNBT list = compound.func_150295_c("FactionList", 10);
        for (int i = 0; i < list.size(); ++i) {
            Faction faction = new Faction();
            faction.readNBT(list.func_150305_b(i));
            this.playerFactions.add(faction);
        }
        PlayerFactionData data = new PlayerFactionData();
        data.loadNBTData(compound);
        for (int id : data.factionData.keySet()) {
            int points = data.factionData.get(id);
            for (Faction faction : this.playerFactions) {
                if (faction.id != id) continue;
                faction.defaultPoints = points;
            }
        }
        this.pages = (this.playerFactions.size() - 1) / 5;
        ++this.pages;
        this.page = 1;
        this.updateButtons();
    }
}

