/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.player.GuiMailmanWrite;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.PlayerMailData;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketPlayerMailDelete;
import noppes.npcs.packets.server.SPacketPlayerMailGet;
import noppes.npcs.packets.server.SPacketPlayerMailOpen;
import noppes.npcs.packets.server.SPacketPlayerMailRead;

public class GuiMailbox
extends GuiNPCInterface
implements IGuiData,
ICustomScrollListener {
    private GuiCustomScroll scroll;
    private PlayerMailData data;
    private PlayerMail selected;

    public GuiMailbox() {
        this.imageWidth = 256;
        this.setBackground("menubg.png");
        Packets.sendServer(new SPacketPlayerMailGet());
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.func_231149_a_(165, 186);
        }
        this.scroll.guiLeft = this.guiLeft + 4;
        this.scroll.guiTop = this.guiTop + 4;
        this.addScroll(this.scroll);
        String title = I18n.func_135052_a((String)"mailbox.name", (Object[])new Object[0]);
        int x = (this.imageWidth - this.field_230712_o_.func_78256_a(title)) / 2;
        this.addLabel(new GuiNpcLabel(0, title, this.guiLeft + x, this.guiTop - 8));
        if (this.selected != null) {
            this.addLabel(new GuiNpcLabel(3, I18n.func_135052_a((String)"mailbox.sender", (Object[])new Object[0]) + ":", this.guiLeft + 170, this.guiTop + 6));
            this.addLabel(new GuiNpcLabel(1, this.selected.sender, this.guiLeft + 174, this.guiTop + 18));
            this.addLabel(new GuiNpcLabel(2, I18n.func_135052_a((String)"mailbox.timesend", (Object[])new Object[]{this.getTimePast()}), this.guiLeft + 174, this.guiTop + 30));
        }
        this.addButton(new GuiNpcButton(this, 0, this.guiLeft + 4, this.guiTop + 192, 82, 20, "mailbox.read"));
        this.addButton(new GuiNpcButton(this, 1, this.guiLeft + 88, this.guiTop + 192, 82, 20, "selectWorld.deleteButton"));
        this.getButton(1).setEnabled(this.selected != null);
    }

    private String getTimePast() {
        if (this.selected.timePast > 86400000L) {
            int days = (int)(this.selected.timePast / 86400000L);
            if (days == 1) {
                return days + " " + I18n.func_135052_a((String)"mailbox.day", (Object[])new Object[0]);
            }
            return days + " " + I18n.func_135052_a((String)"mailbox.days", (Object[])new Object[0]);
        }
        if (this.selected.timePast > 3600000L) {
            int hours = (int)(this.selected.timePast / 3600000L);
            if (hours == 1) {
                return hours + " " + I18n.func_135052_a((String)"mailbox.hour", (Object[])new Object[0]);
            }
            return hours + " " + I18n.func_135052_a((String)"mailbox.hours", (Object[])new Object[0]);
        }
        int minutes = (int)(this.selected.timePast / 60000L);
        if (minutes == 1) {
            return minutes + " " + I18n.func_135052_a((String)"mailbox.minutes", (Object[])new Object[0]);
        }
        return minutes + " " + I18n.func_135052_a((String)"mailbox.minutes", (Object[])new Object[0]);
    }

    @Override
    public void buttonEvent(GuiNpcButton guibutton) {
        int id = guibutton.id;
        if (this.scroll.selected < 0) {
            return;
        }
        if (id == 0) {
            GuiMailmanWrite.parent = this;
            GuiMailmanWrite.mail = this.selected;
            Packets.sendServer(new SPacketPlayerMailOpen(this.selected.time, this.selected.sender));
            this.selected = null;
            this.scroll.selected = -1;
        }
        if (id == 1) {
            ConfirmScreen guiyesno = new ConfirmScreen(bo -> {
                if (bo && this.selected != null) {
                    Packets.sendServer(new SPacketPlayerMailDelete(this.selected.time, this.selected.sender));
                    this.selected = null;
                }
                NoppesUtil.openGUI((PlayerEntity)this.player, this);
            }, (ITextComponent)new TranslationTextComponent(""), (ITextComponent)new TranslationTextComponent("gui.deleteMessage"));
            this.setScreen((Screen)guiyesno);
        }
    }

    @Override
    public boolean func_231044_a_(double i, double j, int k) {
        super.func_231044_a_(i, j, k);
        this.scroll.func_231044_a_(i, j, k);
        return true;
    }

    @Override
    public void save() {
    }

    @Override
    public void setGuiData(CompoundNBT compound) {
        PlayerMailData data = new PlayerMailData();
        data.loadNBTData(compound);
        ArrayList<String> list = new ArrayList<String>();
        Collections.sort(data.playermail, (o1, o2) -> {
            if (o1.time == o2.time) {
                return 0;
            }
            return o1.time > o2.time ? -1 : 1;
        });
        for (PlayerMail mail : data.playermail) {
            list.add(mail.subject);
        }
        this.data = data;
        this.scroll.clear();
        this.selected = null;
        this.scroll.setUnsortedList(list);
    }

    @Override
    public void scrollClicked(double i, double j, int k, GuiCustomScroll guiCustomScroll) {
        this.selected = this.data.playermail.get(guiCustomScroll.selected);
        this.func_231160_c_();
        if (this.selected != null && !this.selected.beenRead) {
            this.selected.beenRead = true;
            Packets.sendServer(new SPacketPlayerMailRead(this.selected.time, this.selected.sender));
        }
    }

    @Override
    public void scrollDoubleClicked(String selection, GuiCustomScroll scroll) {
    }
}

