/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.containers.ContainerNPCBankInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketBankUnlock;
import noppes.npcs.packets.server.SPacketBankUpgrade;
import noppes.npcs.packets.server.SPacketBanksSlotOpen;

public class GuiNPCBankChest
extends GuiContainerNPCInterface<ContainerNPCBankInterface>
implements IGuiData {
    private final ResourceLocation resource = new ResourceLocation("customnpcs", "textures/gui/bankchest.png");
    private ContainerNPCBankInterface container;
    private int availableSlots = 0;
    private int maxSlots = 1;
    private int unlockedSlots = 1;
    private ItemStack currency;

    public GuiNPCBankChest(ContainerNPCBankInterface container, PlayerInventory inv, ITextComponent titleIn) {
        super(NoppesUtil.getLastNpc(), container, inv, titleIn);
        this.container = container;
        this.field_230704_d_ = "";
        this.field_230711_n_ = false;
        this.field_147000_g = 235;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.availableSlots = 0;
        if (this.maxSlots > 1) {
            for (int i = 0; i < this.maxSlots; ++i) {
                GuiNpcButton button = new GuiNpcButton(this, i, this.guiLeft - 50, this.guiTop + 10 + i * 24, 50, 20, I18n.func_135052_a((String)"gui.tab", (Object[])new Object[0]) + " " + (i + 1));
                if (i > this.unlockedSlots) {
                    button.setEnabled(false);
                }
                this.addButton(button);
                ++this.availableSlots;
            }
            if (this.availableSlots == 1) {
                this.field_230710_m_.clear();
            }
        }
        if (!this.container.isAvailable()) {
            this.addButton(new GuiNpcButton(this, 8, this.guiLeft + 48, this.guiTop + 48, 80, 20, I18n.func_135052_a((String)"bank.unlock", (Object[])new Object[0])));
        } else if (this.container.canBeUpgraded()) {
            this.addButton(new GuiNpcButton(this, 9, this.guiLeft + 48, this.guiTop + 48, 80, 20, I18n.func_135052_a((String)"bank.upgrade", (Object[])new Object[0])));
        }
        if (this.maxSlots > 1) {
            this.getButton((int)this.container.slot).field_230694_p_ = false;
            this.getButton(this.container.slot).setEnabled(false);
        }
    }

    @Override
    public void buttonEvent(GuiNpcButton guibutton) {
        int id = guibutton.id;
        if (id < 6) {
            Packets.sendServer(new SPacketBanksSlotOpen(id, this.container.bankid));
        }
        if (id == 8) {
            Packets.sendServer(new SPacketBankUnlock());
        }
        if (id == 9) {
            Packets.sendServer(new SPacketBankUpgrade());
        }
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        int j;
        int i;
        super.func_230450_a_(matrixStack, partialTicks, x, y);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.resource);
        int l = (this.field_230708_k_ - this.field_146999_f) / 2;
        int i1 = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, l, i1, 0, 0, this.field_146999_f, 6);
        if (!this.container.isAvailable()) {
            this.func_238474_b_(matrixStack, l, i1 + 6, 0, 6, this.field_146999_f, 64);
            this.func_238474_b_(matrixStack, l, i1 + 70, 0, 124, this.field_146999_f, 98);
            i = this.guiLeft + 30;
            j = this.guiTop + 8;
            this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"bank.unlockCosts", (Object[])new Object[0]) + ":", (float)i, (float)(j + 4), CustomNpcResourceListener.DefaultTextColor);
            this.drawItem(matrixStack, i + 90, j, this.currency, x, y);
        } else if (this.container.isUpgraded()) {
            this.func_238474_b_(matrixStack, l, i1 + 60, 0, 60, this.field_146999_f, 162);
            this.func_238474_b_(matrixStack, l, i1 + 6, 0, 60, this.field_146999_f, 64);
        } else if (this.container.canBeUpgraded()) {
            this.func_238474_b_(matrixStack, l, i1 + 6, 0, 6, this.field_146999_f, 216);
            i = this.guiLeft + 30;
            j = this.guiTop + 8;
            this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"bank.upgradeCosts", (Object[])new Object[0]) + ":", (float)i, (float)(j + 4), CustomNpcResourceListener.DefaultTextColor);
            this.drawItem(matrixStack, i + 90, j, this.currency, x, y);
        } else {
            this.func_238474_b_(matrixStack, l, i1 + 6, 0, 60, this.field_146999_f, 162);
        }
        if (this.maxSlots > 1) {
            for (int ii = 0; ii < this.maxSlots && this.availableSlots != ii; ++ii) {
                this.field_230712_o_.func_238421_b_(matrixStack, "Tab " + (ii + 1), (float)(this.guiLeft - 40), (float)(this.guiTop + 16 + ii * 24), 0xFFFFFF);
            }
        }
    }

    private void drawItem(MatrixStack matrixStack, int x, int y, ItemStack item, int mouseX, int mouseY) {
        if (NoppesUtilServer.IsItemStackNull(item)) {
            return;
        }
        RenderSystem.enableRescaleNormal();
        this.field_230707_j_.func_180450_b(item, x, y);
        this.field_230707_j_.func_175030_a(this.field_230712_o_, item, x, y);
        RenderSystem.disableRescaleNormal();
        if (this.func_195359_a(x - this.guiLeft, y - this.guiTop, 16, 16, mouseX, mouseY)) {
            this.func_230457_a_(matrixStack, item, mouseX, mouseY);
        }
    }

    @Override
    public void save() {
    }

    @Override
    public void setGuiData(CompoundNBT compound) {
        this.maxSlots = compound.func_74762_e("MaxSlots");
        this.unlockedSlots = compound.func_74762_e("UnlockedSlots");
        this.currency = compound.func_74764_b("Currency") ? ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Currency")) : ItemStack.field_190927_a;
        if (this.container.currency != null) {
            this.container.currency.item = this.currency;
        }
        this.func_231160_c_();
    }
}

