/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.roles;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import noppes.npcs.client.gui.player.companion.GuiNpcCompanionTalents;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiInterface;
import noppes.npcs.client.gui.util.ISliderListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.constants.EnumCompanionStage;
import noppes.npcs.constants.EnumCompanionTalent;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketNpcRoleCompanionUpdate;
import noppes.npcs.packets.server.SPacketNpcRoleSave;
import noppes.npcs.roles.RoleCompanion;

public class GuiNpcCompanion
extends GuiNPCInterface2
implements ITextfieldListener,
ISliderListener {
    private RoleCompanion role;
    private List<GuiNpcCompanionTalents.GuiTalent> talents = new ArrayList<GuiNpcCompanionTalents.GuiTalent>();

    public GuiNpcCompanion(EntityNPCInterface npc) {
        super(npc);
        this.role = (RoleCompanion)npc.role;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.talents = new ArrayList<GuiNpcCompanionTalents.GuiTalent>();
        int y = this.guiTop + 4;
        this.addButton(new GuiNpcButton((IGuiInterface)this, 0, this.guiLeft + 70, y, 90, 20, new String[]{EnumCompanionStage.BABY.name, EnumCompanionStage.CHILD.name, EnumCompanionStage.TEEN.name, EnumCompanionStage.ADULT.name, EnumCompanionStage.FULLGROWN.name}, this.role.stage.ordinal()));
        this.addLabel(new GuiNpcLabel(0, "companion.stage", this.guiLeft + 4, y + 5));
        this.addButton(new GuiNpcButton(this, 1, this.guiLeft + 162, y, 90, 20, "gui.update"));
        this.addButton(new GuiNpcButton((IGuiInterface)this, 2, this.guiLeft + 70, y += 22, 90, 20, new String[]{"gui.no", "gui.yes"}, this.role.canAge ? 1 : 0));
        this.addLabel(new GuiNpcLabel(2, "companion.age", this.guiLeft + 4, y + 5));
        if (this.role.canAge) {
            this.addTextField(new GuiNpcTextField(2, this, this.guiLeft + 162, y, 140, 20, this.role.ticksActive + ""));
            this.getTextField((int)2).numbersOnly = true;
            this.getTextField(2).setMinMaxDefault(0, Integer.MAX_VALUE, 0);
        }
        this.talents.add(new GuiNpcCompanionTalents.GuiTalent(this.role, EnumCompanionTalent.INVENTORY, this.guiLeft + 4, y += 26));
        this.addSlider(new GuiNpcSlider(this, 10, this.guiLeft + 30, y + 2, 100, 20, (float)this.role.getExp(EnumCompanionTalent.INVENTORY) / 5000.0f));
        this.talents.add(new GuiNpcCompanionTalents.GuiTalent(this.role, EnumCompanionTalent.ARMOR, this.guiLeft + 4, y += 26));
        this.addSlider(new GuiNpcSlider(this, 11, this.guiLeft + 30, y + 2, 100, 20, (float)this.role.getExp(EnumCompanionTalent.ARMOR) / 5000.0f));
        this.talents.add(new GuiNpcCompanionTalents.GuiTalent(this.role, EnumCompanionTalent.SWORD, this.guiLeft + 4, y += 26));
        this.addSlider(new GuiNpcSlider(this, 12, this.guiLeft + 30, y + 2, 100, 20, (float)this.role.getExp(EnumCompanionTalent.SWORD) / 5000.0f));
        for (GuiNpcCompanionTalents.GuiTalent gui : this.talents) {
            gui.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        }
    }

    @Override
    public void buttonEvent(GuiNpcButton guibutton) {
        GuiNpcButton button;
        if (guibutton.id == 0) {
            button = guibutton;
            this.role.matureTo(EnumCompanionStage.values()[button.getValue()]);
            if (this.role.canAge) {
                this.role.ticksActive = this.role.stage.matureAge;
            }
            this.func_231160_c_();
        }
        if (guibutton.id == 1) {
            Packets.sendServer(new SPacketNpcRoleCompanionUpdate(this.role.stage));
        }
        if (guibutton.id == 2) {
            button = guibutton;
            this.role.canAge = button.getValue() == 1;
            this.func_231160_c_();
        }
    }

    @Override
    public void unFocused(GuiNpcTextField textfield) {
        if (textfield.id == 2) {
            this.role.ticksActive = textfield.getInteger();
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        for (GuiNpcCompanionTalents.GuiTalent talent : new ArrayList<GuiNpcCompanionTalents.GuiTalent>(this.talents)) {
            talent.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void elementClicked() {
    }

    @Override
    public void save() {
        Packets.sendServer(new SPacketNpcRoleSave(this.role.save(new CompoundNBT())));
    }

    @Override
    public void mouseDragged(GuiNpcSlider slider) {
        if (slider.sliderValue <= 0.0f) {
            slider.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.disabled"));
            this.role.talents.remove((Object)EnumCompanionTalent.values()[slider.id - 10]);
        } else {
            slider.func_238482_a_((ITextComponent)new TranslationTextComponent((int)(slider.sliderValue * 50.0f) * 100 + " exp"));
            this.role.setExp(EnumCompanionTalent.values()[slider.id - 10], (int)(slider.sliderValue * 50.0f) * 100);
        }
    }

    @Override
    public void mousePressed(GuiNpcSlider slider) {
    }

    @Override
    public void mouseReleased(GuiNpcSlider slider) {
    }
}

