/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;

public class Model2DRenderer
extends ModelRenderer {
    private static final RenderTypeBuffers typeBuffer = new RenderTypeBuffers();
    private VertexBuffer cache = null;
    private float x1;
    private float x2;
    private float y1;
    private float y2;
    private int width;
    private int height;
    private float rotationOffsetX;
    private float rotationOffsetY;
    private float rotationOffsetZ;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float thickness = 1.0f;
    private int displayList;
    private boolean isCompiled = false;
    public static final VertexFormat POSITION_TEX_NORMAL = new VertexFormat(ImmutableList.builder().add((Object)DefaultVertexFormats.field_181713_m).add((Object)DefaultVertexFormats.field_181715_o).add((Object)DefaultVertexFormats.field_181717_q).add((Object)DefaultVertexFormats.field_181718_r).build());

    public Model2DRenderer(Model modelBase, float x, float y, int width, int height, int texWidth, int texHeight) {
        super(modelBase);
        this.width = width;
        this.height = height;
        this.func_78787_b(texWidth, texHeight);
        this.x1 = x / (float)texWidth;
        this.y1 = y / (float)texHeight;
        this.x2 = (x + (float)width) / (float)texWidth;
        this.y2 = (y + (float)height) / (float)texHeight;
    }

    public Model2DRenderer(Model modelBase, float x, float y, int width, int height) {
        this(modelBase, x, y, width, height, modelBase.field_78090_t, modelBase.field_78089_u);
    }

    public void func_228309_a_(MatrixStack mstack, IVertexBuilder builder, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!this.field_78806_j) {
            return;
        }
        float f = 0.0625f;
        mstack.func_227860_a_();
        MatrixStack.Entry entry = mstack.func_227866_c_();
        this.func_228307_a_(mstack);
        mstack.func_227861_a_((double)(this.rotationOffsetX * f), (double)(this.rotationOffsetY * f), (double)(this.rotationOffsetZ * f));
        mstack.func_227862_a_(this.scaleX * (float)this.width / (float)this.height, this.scaleY, this.thickness);
        mstack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        if (this.field_78809_i) {
            mstack.func_227861_a_(0.0, 0.0, (double)(-1.0f * f));
            mstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        }
        this.renderModel(mstack.func_227866_c_().func_227870_a_(), builder, light, overlay, red, green, blue, alpha);
        mstack.func_227865_b_();
    }

    public void render(MatrixStack mstack, int light, int overlay, float red, float green, float blue, float alpha, ResourceLocation resource) {
        if (!this.field_78806_j) {
            return;
        }
        RenderType rType = RenderType.func_228646_f_((ResourceLocation)resource);
        if (this.cache == null) {
            this.cache = new VertexBuffer(DefaultVertexFormats.field_227849_i_);
            MatrixStack mmstack = new MatrixStack();
            mmstack.func_227860_a_();
            IRenderTypeBuffer.Impl impl = typeBuffer.func_228487_b_();
            BufferBuilder bufferbuilder = (BufferBuilder)impl.getBuffer(rType);
            this.renderModel(mmstack.func_227866_c_().func_227870_a_(), (IVertexBuilder)bufferbuilder, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            bufferbuilder.func_178977_d();
            this.cache.func_227875_a_(bufferbuilder);
            mmstack.func_227865_b_();
            impl.func_228461_a_();
        }
        mstack.func_227860_a_();
        this.func_228307_a_(mstack);
        float f = 0.0625f;
        mstack.func_227861_a_((double)(this.rotationOffsetX * f), (double)(this.rotationOffsetY * f), (double)(this.rotationOffsetZ * f));
        mstack.func_227862_a_(this.scaleX * (float)this.width / (float)this.height, this.scaleY, this.thickness);
        mstack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        if (this.field_78809_i) {
            mstack.func_227861_a_(0.0, 0.0, (double)(-1.0f * f));
            mstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        }
        MatrixStack.Entry entry = mstack.func_227866_c_();
        Matrix4f matrix = entry.func_227870_a_();
        rType.func_228547_a_();
        this.cache.func_177359_a();
        DefaultVertexFormats.field_227849_i_.func_227892_a_(0L);
        RenderSystem.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.cache.func_227874_a_(matrix, 7);
        VertexBuffer.func_177361_b();
        DefaultVertexFormats.field_227849_i_.func_227895_d_();
        rType.func_228549_b_();
        mstack.func_227865_b_();
    }

    public void renderModel(Matrix4f matrix, IVertexBuilder builder, int light, int overlay, float red, float green, float blue, float alpha) {
        float f9;
        float f8;
        float f7;
        int k;
        float f = 0.0625f;
        this.addVertex(builder, matrix, 0.0f, 0.0f, 0.0f, red, green, blue, alpha, this.x1, this.y2, overlay, light, 0.0f, 0.0f, 1.0f);
        this.addVertex(builder, matrix, 1.0f, 0.0f, 0.0f, red, green, blue, alpha, this.x2, this.y2, overlay, light, 0.0f, 0.0f, 1.0f);
        this.addVertex(builder, matrix, 1.0f, 1.0f, 0.0f, red, green, blue, alpha, this.x2, this.y1, overlay, light, 0.0f, 0.0f, 1.0f);
        this.addVertex(builder, matrix, 0.0f, 1.0f, 0.0f, red, green, blue, alpha, this.x1, this.y1, overlay, light, 0.0f, 0.0f, 1.0f);
        this.addVertex(builder, matrix, 0.0f, 1.0f, -f, red, green, blue, alpha, this.x1, this.y1, overlay, light, 0.0f, 0.0f, -1.0f);
        this.addVertex(builder, matrix, 1.0f, 1.0f, -f, red, green, blue, alpha, this.x2, this.y1, overlay, light, 0.0f, 0.0f, -1.0f);
        this.addVertex(builder, matrix, 1.0f, 0.0f, -f, red, green, blue, alpha, this.x2, this.y2, overlay, light, 0.0f, 0.0f, -1.0f);
        this.addVertex(builder, matrix, 0.0f, 0.0f, -f, red, green, blue, alpha, this.x1, this.y2, overlay, light, 0.0f, 0.0f, -1.0f);
        float f5 = 0.5f * (this.x1 - this.x2) / (float)this.width;
        float f6 = 0.5f * (this.y2 - this.y1) / (float)this.height;
        for (k = 0; k < this.width; ++k) {
            f7 = (float)k / (float)this.width;
            f8 = this.x1 + (this.x2 - this.x1) * f7 - f5;
            this.addVertex(builder, matrix, f7, 0.0f, -f, red, green, blue, alpha, f8, this.y2, overlay, light, -1.0f, 0.0f, 0.0f);
            this.addVertex(builder, matrix, f7, 0.0f, 0.0f, red, green, blue, alpha, f8, this.y2, overlay, light, -1.0f, 0.0f, 0.0f);
            this.addVertex(builder, matrix, f7, 1.0f, 0.0f, red, green, blue, alpha, f8, this.y1, overlay, light, -1.0f, 0.0f, 0.0f);
            this.addVertex(builder, matrix, f7, 1.0f, -f, red, green, blue, alpha, f8, this.y1, overlay, light, -1.0f, 0.0f, 0.0f);
        }
        for (k = 0; k < this.width; ++k) {
            f7 = (float)k / (float)this.width;
            f8 = this.x1 + (this.x2 - this.x1) * f7 - f5;
            f9 = f7 + 1.0f / (float)this.width;
            this.addVertex(builder, matrix, f9, 1.0f, -f, red, green, blue, alpha, f8, this.y1, overlay, light, 1.0f, 0.0f, 0.0f);
            this.addVertex(builder, matrix, f9, 1.0f, 0.0f, red, green, blue, alpha, f8, this.y1, overlay, light, 1.0f, 0.0f, 0.0f);
            this.addVertex(builder, matrix, f9, 0.0f, 0.0f, red, green, blue, alpha, f8, this.y2, overlay, light, 1.0f, 0.0f, 0.0f);
            this.addVertex(builder, matrix, f9, 0.0f, -f, red, green, blue, alpha, f8, this.y2, overlay, light, 1.0f, 0.0f, 0.0f);
        }
        for (k = 0; k < this.height; ++k) {
            f7 = (float)k / (float)this.height;
            f8 = this.y2 + (this.y1 - this.y2) * f7 - f6;
            f9 = f7 + 1.0f / (float)this.height;
            this.addVertex(builder, matrix, 0.0f, f9, 0.0f, red, green, blue, alpha, this.x1, f8, overlay, light, 0.0f, 1.0f, 0.0f);
            this.addVertex(builder, matrix, 1.0f, f9, 0.0f, red, green, blue, alpha, this.x2, f8, overlay, light, 0.0f, 1.0f, 0.0f);
            this.addVertex(builder, matrix, 1.0f, f9, -f, red, green, blue, alpha, this.x2, f8, overlay, light, 0.0f, 1.0f, 0.0f);
            this.addVertex(builder, matrix, 0.0f, f9, -f, red, green, blue, alpha, this.x1, f8, overlay, light, 0.0f, 1.0f, 0.0f);
        }
        for (k = 0; k < this.height; ++k) {
            f7 = (float)k / (float)this.height;
            f8 = this.y2 + (this.y1 - this.y2) * f7 - f6;
            this.addVertex(builder, matrix, 1.0f, f7, 0.0f, red, green, blue, alpha, this.x2, f8, overlay, light, 0.0f, -1.0f, 0.0f);
            this.addVertex(builder, matrix, 0.0f, f7, 0.0f, red, green, blue, alpha, this.x1, f8, overlay, light, 0.0f, -1.0f, 0.0f);
            this.addVertex(builder, matrix, 0.0f, f7, -f, red, green, blue, alpha, this.x1, f8, overlay, light, 0.0f, -1.0f, 0.0f);
            this.addVertex(builder, matrix, 1.0f, f7, -f, red, green, blue, alpha, this.x2, f8, overlay, light, 0.0f, -1.0f, 0.0f);
        }
    }

    private void addVertex(IVertexBuilder builder, Matrix4f matrix, float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        Vector4f v = new Vector4f(x, y, z, 1.0f);
        v.func_229372_a_(matrix);
        builder.func_225582_a_((double)v.func_195910_a(), (double)v.func_195913_b(), (double)v.func_195914_c());
        builder.func_227885_a_(red, green, blue, alpha);
        builder.func_225583_a_(texU, texV);
        builder.func_227891_b_(overlayUV);
        builder.func_227886_a_(lightmapUV);
        builder.func_225584_a_(normalX, normalY, normalZ);
        builder.func_181675_d();
    }

    public void setRotationOffset(float x, float y, float z) {
        this.rotationOffsetX = x;
        this.rotationOffsetY = y;
        this.rotationOffsetZ = z;
    }

    public void setScale(float scale) {
        this.scaleX = scale;
        this.scaleY = scale;
    }

    public void setScale(float x, float y) {
        this.scaleX = x;
        this.scaleY = y;
    }

    public void setThickness(float thickness) {
        this.thickness = thickness;
    }

    public static void renderItemIn2D(BufferBuilder worldrenderer, float p_78439_1_, float p_78439_2_, float p_78439_3_, float p_78439_4_, int p_78439_5_, int p_78439_6_, float p_78439_7_) {
        float f9;
        float f8;
        float f7;
        int k;
        Tessellator tessellator = Tessellator.func_178181_a();
        worldrenderer.func_181668_a(7, POSITION_TEX_NORMAL);
        worldrenderer.func_225582_a_(0.0, 0.0, 0.0).func_225583_a_(p_78439_1_, p_78439_4_).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        worldrenderer.func_225582_a_(1.0, 0.0, 0.0).func_225583_a_(p_78439_3_, p_78439_4_).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        worldrenderer.func_225582_a_(1.0, 1.0, 0.0).func_225583_a_(p_78439_3_, p_78439_2_).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        worldrenderer.func_225582_a_(0.0, 1.0, 0.0).func_225583_a_(p_78439_1_, p_78439_2_).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, POSITION_TEX_NORMAL);
        worldrenderer.func_225582_a_(0.0, 1.0, (double)(0.0f - p_78439_7_)).func_225583_a_(p_78439_1_, p_78439_2_).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        worldrenderer.func_225582_a_(1.0, 1.0, (double)(0.0f - p_78439_7_)).func_225583_a_(p_78439_3_, p_78439_2_).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        worldrenderer.func_225582_a_(1.0, 0.0, (double)(0.0f - p_78439_7_)).func_225583_a_(p_78439_3_, p_78439_4_).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        worldrenderer.func_225582_a_(0.0, 0.0, (double)(0.0f - p_78439_7_)).func_225583_a_(p_78439_1_, p_78439_4_).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        tessellator.func_78381_a();
        float f5 = 0.5f * (p_78439_1_ - p_78439_3_) / (float)p_78439_5_;
        float f6 = 0.5f * (p_78439_4_ - p_78439_2_) / (float)p_78439_6_;
        worldrenderer.func_181668_a(7, POSITION_TEX_NORMAL);
        for (k = 0; k < p_78439_5_; ++k) {
            f7 = (float)k / (float)p_78439_5_;
            f8 = p_78439_1_ + (p_78439_3_ - p_78439_1_) * f7 - f5;
            worldrenderer.func_225582_a_((double)f7, 0.0, (double)(0.0f - p_78439_7_)).func_225583_a_(f8, p_78439_4_).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
            worldrenderer.func_225582_a_((double)f7, 0.0, 0.0).func_225583_a_(f8, p_78439_4_).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
            worldrenderer.func_225582_a_((double)f7, 1.0, 0.0).func_225583_a_(f8, p_78439_2_).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
            worldrenderer.func_225582_a_((double)f7, 1.0, (double)(0.0f - p_78439_7_)).func_225583_a_(f8, p_78439_2_).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, POSITION_TEX_NORMAL);
        for (k = 0; k < p_78439_5_; ++k) {
            f7 = (float)k / (float)p_78439_5_;
            f8 = p_78439_1_ + (p_78439_3_ - p_78439_1_) * f7 - f5;
            f9 = f7 + 1.0f / (float)p_78439_5_;
            worldrenderer.func_225582_a_((double)f9, 1.0, (double)(0.0f - p_78439_7_)).func_225583_a_(f8, p_78439_2_).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
            worldrenderer.func_225582_a_((double)f9, 1.0, 0.0).func_225583_a_(f8, p_78439_2_).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
            worldrenderer.func_225582_a_((double)f9, 0.0, 0.0).func_225583_a_(f8, p_78439_4_).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
            worldrenderer.func_225582_a_((double)f9, 0.0, (double)(0.0f - p_78439_7_)).func_225583_a_(f8, p_78439_4_).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, POSITION_TEX_NORMAL);
        for (k = 0; k < p_78439_6_; ++k) {
            f7 = (float)k / (float)p_78439_6_;
            f8 = p_78439_4_ + (p_78439_2_ - p_78439_4_) * f7 - f6;
            f9 = f7 + 1.0f / (float)p_78439_6_;
            worldrenderer.func_225582_a_(0.0, (double)f9, 0.0).func_225583_a_(p_78439_1_, f8).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
            worldrenderer.func_225582_a_(1.0, (double)f9, 0.0).func_225583_a_(p_78439_3_, f8).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
            worldrenderer.func_225582_a_(1.0, (double)f9, (double)(0.0f - p_78439_7_)).func_225583_a_(p_78439_3_, f8).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
            worldrenderer.func_225582_a_(0.0, (double)f9, (double)(0.0f - p_78439_7_)).func_225583_a_(p_78439_1_, f8).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, POSITION_TEX_NORMAL);
        for (k = 0; k < p_78439_6_; ++k) {
            f7 = (float)k / (float)p_78439_6_;
            f8 = p_78439_4_ + (p_78439_2_ - p_78439_4_) * f7 - f6;
            worldrenderer.func_225582_a_(1.0, (double)f7, 0.0).func_225583_a_(p_78439_3_, f8).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
            worldrenderer.func_225582_a_(0.0, (double)f7, 0.0).func_225583_a_(p_78439_1_, f8).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
            worldrenderer.func_225582_a_(0.0, (double)f7, (double)(0.0f - p_78439_7_)).func_225583_a_(p_78439_1_, f8).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
            worldrenderer.func_225582_a_(1.0, (double)f7, (double)(0.0f - p_78439_7_)).func_225583_a_(p_78439_3_, f8).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
        }
        tessellator.func_78381_a();
    }
}

