/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.model.animation;

import java.util.HashMap;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import noppes.npcs.ModelData;
import noppes.npcs.client.model.animation.AniBlank;
import noppes.npcs.client.model.animation.AniBow;
import noppes.npcs.client.model.animation.AniCrawling;
import noppes.npcs.client.model.animation.AniDancing;
import noppes.npcs.client.model.animation.AniHug;
import noppes.npcs.client.model.animation.AniNo;
import noppes.npcs.client.model.animation.AniPoint;
import noppes.npcs.client.model.animation.AniWaving;
import noppes.npcs.client.model.animation.AniYes;
import noppes.npcs.client.model.animation.AnimationBase;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.entity.EntityNPCInterface;

public class AnimationHandler {
    private static final HashMap<Integer, AnimationBase> ANIMATIONS = new HashMap();

    public static void animateBipedPre(ModelData data, BipedModel bipedModel, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        EntityNPCInterface npc = (EntityNPCInterface)livingEntity;
        bipedModel.field_78115_e.field_78798_e = 0.0f;
        bipedModel.field_78115_e.field_78797_d = 0.0f;
        bipedModel.field_78115_e.field_78800_c = 0.0f;
        bipedModel.field_78115_e.field_78808_h = 0.0f;
        bipedModel.field_78115_e.field_78796_g = 0.0f;
        bipedModel.field_78115_e.field_78795_f = 0.0f;
        bipedModel.field_78116_c.field_78795_f = 0.0f;
        bipedModel.field_178720_f.field_78795_f = 0.0f;
        bipedModel.field_78116_c.field_78808_h = 0.0f;
        bipedModel.field_178720_f.field_78808_h = 0.0f;
        bipedModel.field_78116_c.field_78800_c = 0.0f;
        bipedModel.field_178720_f.field_78800_c = 0.0f;
        bipedModel.field_78116_c.field_78797_d = 0.0f;
        bipedModel.field_178720_f.field_78797_d = 0.0f;
        bipedModel.field_78116_c.field_78798_e = 0.0f;
        bipedModel.field_178720_f.field_78798_e = 0.0f;
        bipedModel.field_178722_k.field_78795_f = 0.0f;
        bipedModel.field_178722_k.field_78796_g = 0.0f;
        bipedModel.field_178722_k.field_78808_h = 0.0f;
        bipedModel.field_178721_j.field_78795_f = 0.0f;
        bipedModel.field_178721_j.field_78796_g = 0.0f;
        bipedModel.field_178721_j.field_78808_h = 0.0f;
        bipedModel.field_178724_i.field_78800_c = 0.0f;
        bipedModel.field_178724_i.field_78797_d = 2.0f;
        bipedModel.field_178724_i.field_78798_e = 0.0f;
        bipedModel.field_178723_h.field_78800_c = 0.0f;
        bipedModel.field_178723_h.field_78797_d = 2.0f;
        bipedModel.field_178723_h.field_78798_e = 0.0f;
        AnimationBase animation = AnimationHandler.getAnimationFor(npc.currentAnimation);
        if (animation != null) {
            animation.animatePre(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, (Entity)livingEntity, bipedModel, npc.animationStart);
        }
    }

    public static void animateBipedPost(ModelData data, BipedModel bipedModel, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        AnimationBase animation;
        EntityNPCInterface npc = (EntityNPCInterface)livingEntity;
        if (livingEntity.func_70608_bn() && bipedModel.field_78116_c.field_78795_f < 0.0f) {
            bipedModel.field_78116_c.field_78795_f = 90.0f;
            bipedModel.field_178720_f.field_78795_f = 90.0f;
        }
        if ((animation = AnimationHandler.getAnimationFor(npc.currentAnimation)) != null) {
            animation.animatePost(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, (Entity)livingEntity, bipedModel, npc.animationStart);
        }
        if (bipedModel.field_228270_o_) {
            bipedModel.field_78115_e.field_78795_f = 0.5f / data.getPartConfig((EnumParts)EnumParts.BODY).scaleY;
        }
        if (bipedModel instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)bipedModel;
            playerModel.field_178733_c.func_217177_a(playerModel.field_178722_k);
            playerModel.field_178731_d.func_217177_a(playerModel.field_178721_j);
            playerModel.field_178734_a.func_217177_a(playerModel.field_178724_i);
            playerModel.field_178732_b.func_217177_a(playerModel.field_178723_h);
            playerModel.field_178730_v.func_217177_a(playerModel.field_78115_e);
        }
        bipedModel.field_178720_f.func_217177_a(bipedModel.field_78116_c);
    }

    public static void addAnimation(int enumAnimation, AnimationBase animationBase) {
        ANIMATIONS.put(enumAnimation, animationBase);
    }

    public static HashMap<Integer, AnimationBase> getAllAnimations() {
        return ANIMATIONS;
    }

    public static AnimationBase getAnimationFor(int animation) {
        return ANIMATIONS.get(animation);
    }

    static {
        AnimationHandler.addAnimation(0, new AniBlank());
        AnimationHandler.addAnimation(2, new AniBlank());
        AnimationHandler.addAnimation(7, new AniCrawling());
        AnimationHandler.addAnimation(3, new AniHug());
        AnimationHandler.addAnimation(5, new AniDancing());
        AnimationHandler.addAnimation(10, new AniWaving());
        AnimationHandler.addAnimation(11, new AniBow());
        AnimationHandler.addAnimation(13, new AniYes());
        AnimationHandler.addAnimation(12, new AniNo());
        AnimationHandler.addAnimation(8, new AniPoint());
        AnimationHandler.addAnimation(14, new AniBlank());
        AnimationHandler.addAnimation(9, new AnimationBase(){

            @Override
            public void animatePre(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Entity entity, BipedModel model, int animationStart) {
            }

            @Override
            public void animatePost(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Entity entity, BipedModel model, int animationStart) {
                model.field_78116_c.field_78795_f = 0.7f;
                model.field_178720_f.field_78795_f = 0.7f;
            }
        });
        AnimationHandler.addAnimation(1, new AnimationBase(){

            @Override
            public void animatePre(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Entity entity, BipedModel model, int animationStart) {
                model.field_217113_d = true;
            }

            @Override
            public void animatePost(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Entity entity, BipedModel model, int animationStart) {
                model.field_217113_d = false;
            }
        });
        AnimationHandler.addAnimation(4, new AnimationBase(){

            @Override
            public void animatePre(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Entity entity, BipedModel model, int animationStart) {
                model.field_228270_o_ = true;
            }

            @Override
            public void animatePost(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Entity entity, BipedModel model, int animationStart) {
                model.field_228270_o_ = false;
            }
        });
    }
}

