/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ImageDownloadAlt
extends SimpleTexture {
    private static final Logger logger = LogManager.getLogger();
    private final File cacheFile;
    private final String imageUrl;
    private CompletableFuture<?> future;
    private boolean textureUploaded;
    private boolean fix64;

    public ImageDownloadAlt(File file, String url, ResourceLocation resource, boolean fix64) {
        super(resource);
        this.cacheFile = file;
        this.imageUrl = url;
        this.fix64 = fix64;
    }

    public void setImage(NativeImage image) {
        Minecraft.func_71410_x().execute(() -> {
            this.textureUploaded = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.upload(image));
            } else {
                this.upload(image);
            }
        });
    }

    private void upload(NativeImage imageIn) {
        TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)imageIn.func_195702_a(), (int)imageIn.func_195714_b());
        imageIn.func_195697_a(0, 0, 0, true);
    }

    public void func_195413_a(IResourceManager resourceManager) throws IOException {
        Minecraft.func_71410_x().execute(() -> {
            if (!this.textureUploaded) {
                ImageDownloadAlt imageDownloadAlt = this;
                synchronized (imageDownloadAlt) {
                    try {
                        super.func_195413_a(resourceManager);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this.textureUploaded = true;
                }
            }
        });
        if (this.future == null) {
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                logger.debug("Loading http texture from local cache ({})", new Object[]{this.cacheFile});
                NativeImage image = null;
                try {
                    image = NativeImage.func_195713_a((InputStream)new FileInputStream(this.cacheFile));
                    this.setImage(this.parseUserSkin(image));
                }
                catch (IOException ioexception) {
                    logger.error("Couldn't load skin " + this.cacheFile, (Throwable)ioexception);
                    this.loadTextureFromServer();
                }
            } else {
                this.loadTextureFromServer();
            }
        }
    }

    protected void loadTextureFromServer() {
        this.future = CompletableFuture.runAsync(() -> {
            HttpURLConnection connection = null;
            logger.debug("Downloading http texture from {} to {}", new Object[]{this.imageUrl, this.cacheFile});
            try {
                InputStream inputstream;
                connection = (HttpURLConnection)new URL(this.imageUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                connection.setDoInput(true);
                connection.setDoOutput(false);
                connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 5.1; rv:19.0) Gecko/20100101 Firefox/19.0");
                connection.connect();
                if (connection.getResponseCode() / 100 != 2) {
                    return;
                }
                if (this.cacheFile != null) {
                    FileUtils.copyInputStreamToFile((InputStream)connection.getInputStream(), (File)this.cacheFile);
                    inputstream = new FileInputStream(this.cacheFile);
                } else {
                    inputstream = connection.getInputStream();
                }
                try {
                    NativeImage nativeimage = this.parseUserSkin(NativeImage.func_195713_a((InputStream)inputstream));
                    Minecraft.func_71410_x().execute(() -> this.setImage(nativeimage));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            catch (Exception exception) {
                logger.error("Couldn't download http texture", (Throwable)exception);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }, Util.func_215072_e());
    }

    public NativeImage parseUserSkin(NativeImage image) {
        boolean lvt_2_1_;
        if (image.func_195714_b() != image.func_195702_a() && image.func_195702_a() / 2 != image.func_195714_b()) {
            throw new IllegalArgumentException("Invalid texture size: " + image.func_195702_a() + "x" + image.func_195714_b());
        }
        int scale = image.func_195702_a() / 64;
        boolean bl = lvt_2_1_ = image.func_195714_b() != image.func_195702_a();
        if (lvt_2_1_) {
            NativeImage nativeImage = new NativeImage(64 * scale, 64 * scale, true);
            nativeImage.func_195703_a(image);
            image.close();
            image = nativeImage;
            nativeImage.func_195715_a(0, 32 * scale, 64 * scale, 32 * scale, 0);
            nativeImage.func_195699_a(4 * scale, 16 * scale, 16 * scale, 32 * scale, 4 * scale, 4 * scale, true, false);
            nativeImage.func_195699_a(8 * scale, 16 * scale, 16 * scale, 32 * scale, 4 * scale, 4 * scale, true, false);
            nativeImage.func_195699_a(0, 20 * scale, 24 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
            nativeImage.func_195699_a(4 * scale, 20 * scale, 16 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
            nativeImage.func_195699_a(8 * scale, 20 * scale, 8 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
            nativeImage.func_195699_a(12 * scale, 20 * scale, 16 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
            nativeImage.func_195699_a(44 * scale, 16 * scale, -8 * scale, 32 * scale, 4 * scale, 4 * scale, true, false);
            nativeImage.func_195699_a(48 * scale, 16 * scale, -8 * scale, 32 * scale, 4 * scale, 4 * scale, true, false);
            nativeImage.func_195699_a(40 * scale, 20 * scale, 0, 32 * scale, 4 * scale, 12 * scale, true, false);
            nativeImage.func_195699_a(44 * scale, 20 * scale, -8 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
            nativeImage.func_195699_a(48 * scale, 20 * scale, -16 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
            nativeImage.func_195699_a(52 * scale, 20 * scale, -8 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
        }
        ImageDownloadAlt.setAreaOpaque(image, 0, 0, 32 * scale, 16 * scale);
        if (lvt_2_1_) {
            ImageDownloadAlt.setAreaTransparent(image, 32 * scale, 0, 64 * scale, 32 * scale);
        }
        ImageDownloadAlt.setAreaOpaque(image, 0, 16 * scale, 64 * scale, 32 * scale);
        ImageDownloadAlt.setAreaOpaque(image, 16 * scale, 48 * scale, 48 * scale, 64 * scale);
        return image;
    }

    private static void setAreaTransparent(NativeImage image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                int k = image.func_195709_a(i, j);
                if ((k >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (int l = x; l < width; ++l) {
            for (int i1 = y; i1 < height; ++i1) {
                image.func_195700_a(l, i1, image.func_195709_a(l, i1) & 0xFFFFFF);
            }
        }
    }

    private static void setAreaOpaque(NativeImage image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                image.func_195700_a(i, j, image.func_195709_a(i, j) | 0xFF000000);
            }
        }
    }
}

