/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.NPCRendererHelper;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.client.layer.LayerArms;
import noppes.npcs.client.layer.LayerBody;
import noppes.npcs.client.layer.LayerEyes;
import noppes.npcs.client.layer.LayerHead;
import noppes.npcs.client.layer.LayerHeadwear;
import noppes.npcs.client.layer.LayerLegs;
import noppes.npcs.client.layer.LayerNpcCloak;
import noppes.npcs.client.layer.LayerPreRender;
import noppes.npcs.client.renderer.RenderNPCInterface;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.ArmorLayerMixin;

public class RenderCustomNpc<T extends EntityCustomNpc, M extends BipedModel<T>>
extends RenderNPCInterface<T, M> {
    private float partialTicks;
    private LivingEntity entity;
    private LivingRenderer renderEntity;
    public M npcmodel;
    public Model otherModel;
    public ArmorLayerMixin armorLayer;
    public final List<LayerRenderer<T, M>> npclayers = Lists.newArrayList();
    private LayerRenderer renderLayer = new LayerRenderer(null){

        public void func_225628_a_(MatrixStack mStack, IRenderTypeBuffer typeBuffer, int lightmapUV, Entity p_225628_4_, float limbSwing, float limbSwingAmount, float partialTicks, float age, float netHeadYaw, float headPitch) {
            for (Object layer : ((RenderCustomNpc)RenderCustomNpc.this).renderEntity.field_177097_h) {
                ((LayerRenderer)layer).func_225628_a_(mStack, typeBuffer, lightmapUV, (Entity)RenderCustomNpc.this.entity, limbSwing, limbSwingAmount, partialTicks, age, netHeadYaw, headPitch);
            }
        }
    };
    private BipedModel renderModel = new BipedModel(0.0f){

        public void func_225598_a_(MatrixStack mStack, IVertexBuilder iVertex, int lightmapUV, int packedOverlayIn, float red, float green, float blue, float alpha) {
            RenderCustomNpc.this.otherModel.func_225598_a_(mStack, iVertex, lightmapUV, packedOverlayIn, red, green, blue, alpha);
        }

        public void func_225597_a_(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            if (RenderCustomNpc.this.otherModel instanceof EntityModel) {
                EntityModel em = (EntityModel)RenderCustomNpc.this.otherModel;
                em.func_225597_a_((Entity)RenderCustomNpc.this.entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            }
        }

        public void func_212843_a_(Entity npc, float animationPos, float animationSpeed, float partialTicks) {
            Model pixModel;
            if (PixelmonHelper.isPixelmon((Entity)RenderCustomNpc.this.entity) && (pixModel = (Model)PixelmonHelper.getModel(RenderCustomNpc.this.entity)) != null) {
                RenderCustomNpc.this.otherModel = pixModel;
                PixelmonHelper.setupModel(RenderCustomNpc.this.entity, pixModel);
            }
            if (RenderCustomNpc.this.otherModel instanceof BipedModel) {
                BipedModel bm = (BipedModel)RenderCustomNpc.this.otherModel;
                bm.field_205061_a = ((BipedModel)RenderCustomNpc.this.npcmodel).field_205061_a;
                bm.field_228270_o_ = ((BipedModel)RenderCustomNpc.this.npcmodel).field_228270_o_;
            }
            if (RenderCustomNpc.this.otherModel instanceof EntityModel) {
                EntityModel em = (EntityModel)RenderCustomNpc.this.otherModel;
                em.field_217113_d = RenderCustomNpc.this.entity.func_184218_aH() && RenderCustomNpc.this.entity.func_184187_bx() != null && RenderCustomNpc.this.entity.func_184187_bx().shouldRiderSit();
                em.field_217114_e = RenderCustomNpc.this.entity.func_70631_g_();
                em.field_217112_c = RenderCustomNpc.this.func_77040_d((LivingEntity)((EntityCustomNpc)npc), partialTicks);
                em.func_212843_a_((Entity)RenderCustomNpc.this.entity, animationPos, animationSpeed, partialTicks);
            }
        }
    };

    public RenderCustomNpc(EntityRendererManager manager, M model) {
        super(manager, model, 0.5f);
        this.npcmodel = model;
        this.func_177094_a(new LayerEyes(this));
        this.func_177094_a(new LayerHeadwear(this));
        this.func_177094_a(new LayerHead(this));
        this.func_177094_a(new LayerArms(this));
        this.func_177094_a(new LayerLegs(this));
        this.func_177094_a(new LayerBody(this));
        this.func_177094_a(new LayerNpcCloak(this));
        this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
        BipedArmorLayer armorLayer = new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f));
        this.func_177094_a((LayerRenderer)armorLayer);
        this.armorLayer = (ArmorLayerMixin)armorLayer;
        this.npclayers.addAll(this.field_177097_h);
    }

    @Override
    public void render(T npc, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        this.partialTicks = partialTicks;
        LivingEntity prevEntity = this.entity;
        this.entity = ((EntityCustomNpc)((Object)npc)).modelData.getEntity((EntityNPCInterface)((Object)npc));
        if (prevEntity != null && this.entity == null) {
            this.field_77045_g = this.npcmodel;
            this.renderEntity = null;
            this.field_177097_h.clear();
            this.field_177097_h.addAll(this.npclayers);
        }
        if (this.entity != null) {
            EntityRenderer render = this.field_76990_c.func_78713_a((Entity)this.entity);
            if (render instanceof LivingRenderer) {
                this.renderEntity = (LivingRenderer)render;
                this.otherModel = this.renderEntity.func_217764_d();
                this.field_77045_g = this.renderModel;
                this.field_177097_h.clear();
                this.field_177097_h.add(this.renderLayer);
            } else {
                this.renderEntity = null;
                this.entity = null;
                this.field_77045_g = this.npcmodel;
            }
        } else {
            List list = this.field_177097_h;
            for (LayerRenderer layer : list) {
                if (!(layer instanceof LayerPreRender)) continue;
                ((LayerPreRender)layer).preRender((EntityCustomNpc)((Object)npc));
            }
        }
        ((BipedModel)this.npcmodel).field_187076_m = this.getPose(npc, ((EntityNPCInterface)((Object)npc)).func_184614_ca());
        ((BipedModel)this.npcmodel).field_187075_l = this.getPose(npc, ((EntityNPCInterface)((Object)npc)).func_184592_cb());
        super.render(npc, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public BipedModel.ArmPose getPose(T npc, ItemStack item) {
        if (NoppesUtilServer.IsItemStackNull(item)) {
            return BipedModel.ArmPose.EMPTY;
        }
        if (npc.func_184605_cv() > 0) {
            UseAction enumaction = item.func_77975_n();
            if (enumaction == UseAction.BLOCK) {
                return BipedModel.ArmPose.BLOCK;
            }
            if (enumaction == UseAction.BOW) {
                return BipedModel.ArmPose.BOW_AND_ARROW;
            }
        }
        return BipedModel.ArmPose.ITEM;
    }

    @Override
    protected void scale(T npc, MatrixStack matrixScale, float f) {
        if (this.renderEntity != null) {
            this.renderColor((EntityNPCInterface)((Object)npc));
            int size = ((EntityCustomNpc)((Object)npc)).display.getSize();
            if (this.entity instanceof EntityNPCInterface) {
                ((EntityNPCInterface)this.entity).display.setSize(5);
            }
            NPCRendererHelper.scale(this.entity, f, matrixScale, this.renderEntity);
            ((EntityCustomNpc)((Object)npc)).display.setSize(size);
            matrixScale.func_227862_a_(0.2f * (float)((EntityCustomNpc)((Object)npc)).display.getSize(), 0.2f * (float)((EntityCustomNpc)((Object)npc)).display.getSize(), 0.2f * (float)((EntityCustomNpc)((Object)npc)).display.getSize());
        } else {
            super.scale(npc, matrixScale, f);
        }
    }

    @Override
    protected float getBob(T par1LivingEntity, float limbSwingAmount) {
        if (this.renderEntity != null) {
            return NPCRendererHelper.getBob(this.entity, limbSwingAmount, this.renderEntity);
        }
        return super.getBob(par1LivingEntity, limbSwingAmount);
    }
}

