/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.security.MessageDigest;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import noppes.npcs.LogWriter;
import noppes.npcs.client.renderer.ImageDownloadAlt;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.MatrixStackMixin;

public class RenderNPCInterface<T extends EntityNPCInterface, M extends EntityModel<T>>
extends LivingRenderer<T, M> {
    public static int LastTextureTick;

    public RenderNPCInterface(EntityRendererManager manager, M model, float f) {
        super(manager, model, f);
    }

    public void renderNameTag(T npc, ITextComponent text, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light) {
        if (npc == null || !this.func_177070_b((LivingEntity)npc)) {
            return;
        }
        double d0 = this.field_76990_c.func_229099_b_(npc);
        if (d0 > 512.0) {
            return;
        }
        matrixStack.func_227860_a_();
        if (((EntityNPCInterface)((Object)npc)).messages != null) {
            float height = ((EntityNPCInterface)((Object)npc)).baseSize.field_220316_b / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
            float offset = npc.func_213302_cg() * (1.2f + (!((EntityNPCInterface)((Object)npc)).display.showName() ? 0.0f : (((EntityNPCInterface)((Object)npc)).display.getTitle().isEmpty() ? 0.15f : 0.25f)));
            matrixStack.func_227861_a_(0.0, (double)offset, 0.0);
            matrixStack.func_227861_a_(0.0, (double)(-offset), 0.0);
        }
        if (((EntityNPCInterface)((Object)npc)).display.showName()) {
            this.renderLivingLabel(npc, matrixStack, buffer, light);
        }
        matrixStack.func_227865_b_();
    }

    protected void renderLivingLabel(T npc, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light) {
        float scale = ((EntityNPCInterface)((Object)npc)).baseSize.field_220316_b / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
        float height = npc.func_213302_cg() - 0.06f * scale;
        matrixStack.func_227860_a_();
        FontRenderer fontrenderer = this.func_76983_a();
        float f2 = 0.01666667f * scale;
        matrixStack.func_227861_a_(0.0, (double)height, 0.0);
        matrixStack.func_227863_a_(this.field_76990_c.func_229098_b_());
        int color = ((EntityNPCInterface)((Object)npc)).getFaction().color;
        matrixStack.func_227861_a_(0.0, (double)(scale / 6.5f * 2.0f), 0.0);
        float f1 = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        matrixStack.func_227862_a_(-f2, -f2, f2);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        float y = 0.0f;
        boolean nearby = ((EntityNPCInterface)((Object)npc)).isInRange(this.field_76990_c.field_217783_c.func_216773_g(), 8.0);
        if (!((EntityNPCInterface)((Object)npc)).display.getTitle().isEmpty() && nearby) {
            IFormattableTextComponent title = new StringTextComponent("<").func_230529_a_((ITextComponent)new TranslationTextComponent(((EntityNPCInterface)((Object)npc)).display.getTitle())).func_240702_b_(">");
            float f3 = 0.01666667f * scale * 0.6f;
            fontrenderer.func_243247_a((ITextComponent)title, (float)(-fontrenderer.func_238414_a_((ITextProperties)title) / 2), 0.0f, color, false, matrix4f, buffer, false, j, light);
            y = -10.0f;
        }
        ITextComponent name = ((EntityNPCInterface)((Object)npc)).func_200200_C_();
        fontrenderer.func_243247_a(name, (float)(-fontrenderer.func_238414_a_((ITextProperties)name) / 2), y, color, false, matrix4f, buffer, nearby, j, light);
        if (nearby) {
            fontrenderer.func_243247_a(name, (float)(-fontrenderer.func_238414_a_((ITextProperties)name) / 2), y, color, false, matrix4f, buffer, false, 0, light);
        }
        matrixStack.func_227865_b_();
    }

    protected void renderColor(EntityNPCInterface npc) {
        if (npc.field_70737_aN <= 0 && npc.field_70725_aQ <= 0) {
            float red = (float)(npc.display.getTint() >> 16 & 0xFF) / 255.0f;
            float green = (float)(npc.display.getTint() >> 8 & 0xFF) / 255.0f;
            float blue = (float)(npc.display.getTint() & 0xFF) / 255.0f;
            RenderSystem.color4f((float)red, (float)green, (float)blue, (float)1.0f);
        }
    }

    protected void setupRotations(T npc, MatrixStack matrixScale, float f, float f1, float f2) {
        if (((EntityNPCInterface)((Object)npc)).func_70089_S() && ((EntityNPCInterface)((Object)npc)).func_70608_bn()) {
            matrixScale.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)((EntityNPCInterface)((Object)npc)).ais.orientation));
            matrixScale.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(this.func_77037_a((LivingEntity)npc)));
            matrixScale.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
        } else if (((EntityNPCInterface)((Object)npc)).func_70089_S() && ((EntityNPCInterface)((Object)npc)).currentAnimation == 7) {
            matrixScale.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f - f1));
            float scale = (float)((EntityCustomNpc)((Object)npc)).display.getSize() / 5.0f;
            matrixScale.func_227861_a_((double)(-scale + ((EntityCustomNpc)((Object)npc)).modelData.getLegsY() * scale), (double)0.14f, 0.0);
            matrixScale.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(270.0f));
            matrixScale.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
        } else {
            super.func_225621_a_(npc, matrixScale, f, f1, f2);
        }
    }

    protected void scale(T npc, MatrixStack matrixScale, float f) {
        this.renderColor((EntityNPCInterface)((Object)npc));
        int size = ((EntityNPCInterface)((Object)npc)).display.getSize();
        matrixScale.func_227862_a_(((EntityNPCInterface)((Object)npc)).scaleX / 5.0f * (float)size, ((EntityNPCInterface)((Object)npc)).scaleY / 5.0f * (float)size, ((EntityNPCInterface)((Object)npc)).scaleZ / 5.0f * (float)size);
    }

    public void render(T npc, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        if (((EntityNPCInterface)((Object)npc)).isKilled()) {
            this.field_76989_e = 0.0f;
        }
        if (((EntityNPCInterface)((Object)npc)).isKilled() && ((EntityNPCInterface)((Object)npc)).stats.hideKilledBody && ((EntityNPCInterface)((Object)npc)).field_70725_aQ > 20) {
            return;
        }
        float xOffset = 0.0f;
        float yOffset = ((EntityNPCInterface)((Object)npc)).currentAnimation == 0 ? ((EntityNPCInterface)((Object)npc)).ais.bodyOffsetY / 10.0f - 0.5f : 0.0f;
        float zOffset = 0.0f;
        if (((EntityNPCInterface)((Object)npc)).func_70089_S()) {
            if (((EntityNPCInterface)((Object)npc)).func_70608_bn()) {
                xOffset = (float)(-Math.cos(Math.toRadians(180 - ((EntityNPCInterface)((Object)npc)).ais.orientation)));
                zOffset = (float)(-Math.sin(Math.toRadians(((EntityNPCInterface)((Object)npc)).ais.orientation)));
                yOffset += 0.14f;
            } else if (((EntityNPCInterface)((Object)npc)).currentAnimation == 1 || npc.func_184218_aH()) {
                yOffset -= 0.5f - ((EntityCustomNpc)((Object)npc)).modelData.getLegsY() * 0.8f;
            }
        }
        xOffset = xOffset / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
        yOffset = yOffset / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
        zOffset = zOffset / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
        if (((EntityNPCInterface)((Object)npc)).display.getBossbar() != 1 && (((EntityNPCInterface)((Object)npc)).display.getBossbar() != 2 || !((EntityNPCInterface)((Object)npc)).isAttacking()) || ((EntityNPCInterface)((Object)npc)).isKilled() || ((EntityNPCInterface)((Object)npc)).field_70725_aQ > 20 || ((EntityNPCInterface)((Object)npc)).canNpcSee((Entity)Minecraft.func_71410_x().field_71439_g)) {
            // empty if block
        }
        if (((EntityNPCInterface)((Object)npc)).ais.getStandingType() == 3 && !((EntityNPCInterface)((Object)npc)).isWalking() && !((EntityNPCInterface)((Object)npc)).isInteracting()) {
            ((EntityNPCInterface)((Object)npc)).field_70760_ar = ((EntityNPCInterface)((Object)npc)).field_70761_aq = (float)((EntityNPCInterface)((Object)npc)).ais.orientation;
        }
        this.field_76989_e = npc.func_213311_cf();
        int stackSize = ((MatrixStackMixin)matrixStack).getStack().size();
        try {
            super.func_225623_a_(npc, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        }
        catch (Throwable e) {
            while (((MatrixStackMixin)matrixStack).getStack().size() > stackSize) {
                matrixStack.func_227865_b_();
            }
            LogWriter.except(e);
        }
    }

    protected float getBob(T npc, float limbSwingAmount) {
        if (((EntityNPCInterface)((Object)npc)).isKilled() || !((EntityNPCInterface)((Object)npc)).display.getHasLivingAnimation()) {
            return 0.0f;
        }
        return super.func_77044_a(npc, limbSwingAmount);
    }

    public ResourceLocation getTextureLocation(T npc) {
        if (((EntityNPCInterface)((Object)npc)).textureLocation == null) {
            if (((EntityNPCInterface)((Object)npc)).display.skinType == 0) {
                ((EntityNPCInterface)((Object)npc)).textureLocation = new ResourceLocation(((EntityNPCInterface)((Object)npc)).display.getSkinTexture());
            } else {
                if (LastTextureTick < 5) {
                    return DefaultPlayerSkin.func_177335_a();
                }
                if (((EntityNPCInterface)((Object)npc)).display.skinType == 1 && ((EntityNPCInterface)((Object)npc)).display.playerProfile != null) {
                    Minecraft minecraft = Minecraft.func_71410_x();
                    Map map = minecraft.func_152342_ad().func_152788_a(((EntityNPCInterface)((Object)npc)).display.playerProfile);
                    if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                        ((EntityNPCInterface)((Object)npc)).textureLocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                    }
                } else if (((EntityNPCInterface)((Object)npc)).display.skinType == 2) {
                    try {
                        MessageDigest digest = MessageDigest.getInstance("MD5");
                        byte[] hash = digest.digest(((EntityNPCInterface)((Object)npc)).display.getSkinUrl().getBytes("UTF-8"));
                        StringBuilder sb = new StringBuilder(2 * hash.length);
                        for (byte b : hash) {
                            sb.append(String.format("%02x", b & 0xFF));
                        }
                        ((EntityNPCInterface)((Object)npc)).textureLocation = new ResourceLocation("skins/" + sb.toString());
                        if (npc instanceof EntityCustomNpc) {
                            this.loadSkin(null, ((EntityNPCInterface)((Object)npc)).textureLocation, ((EntityNPCInterface)((Object)npc)).display.getSkinUrl(), ((EntityCustomNpc)((Object)npc)).modelData.getEntity((EntityNPCInterface)((Object)npc)) == null);
                        } else {
                            this.loadSkin(null, ((EntityNPCInterface)((Object)npc)).textureLocation, ((EntityNPCInterface)((Object)npc)).display.getSkinUrl(), false);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (((EntityNPCInterface)((Object)npc)).textureLocation == null) {
            return DefaultPlayerSkin.func_177335_a();
        }
        return ((EntityNPCInterface)((Object)npc)).textureLocation;
    }

    private void loadSkin(File file, ResourceLocation resource, String par1Str, boolean fix64) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        Object object = texturemanager.func_229267_b_(resource);
        if (object == null) {
            object = new ImageDownloadAlt(file, par1Str, DefaultPlayerSkin.func_177335_a(), fix64);
            texturemanager.func_229263_a_(resource, object);
        }
    }
}

