/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer.blocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomItems;
import noppes.npcs.blocks.tiles.TileDoor;
import noppes.npcs.client.renderer.blocks.BlockRendererInterface;

public class BlockDoorRenderer
extends BlockRendererInterface<TileDoor> {
    private static Random random = new Random();

    public BlockDoorRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TileDoor tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        BlockState original = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        BlockPos lowerPos = tile.func_174877_v();
        if (original.func_177229_b((Property)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER) {
            lowerPos = tile.func_174877_v().func_177977_b();
        }
        BlockPos upperPos = lowerPos.func_177984_a();
        TileDoor lowerTile = (TileDoor)tile.func_145831_w().func_175625_s(lowerPos);
        TileDoor upperTile = (TileDoor)tile.func_145831_w().func_175625_s(upperPos);
        if (lowerTile == null || upperTile == null) {
            return;
        }
        BlockState lowerState = lowerTile.func_195044_w();
        BlockState upperState = upperTile.func_195044_w();
        Block b = lowerTile.blockModel;
        if (this.overrideModel()) {
            b = CustomBlocks.scripted_door;
        }
        BlockState state = b.func_176223_P();
        state = (BlockState)state.func_206870_a((Property)DoorBlock.field_176523_O, original.func_177229_b((Property)DoorBlock.field_176523_O));
        state = (BlockState)state.func_206870_a((Property)DoorBlock.field_176520_a, lowerState.func_177229_b((Property)DoorBlock.field_176520_a));
        state = (BlockState)state.func_206870_a((Property)DoorBlock.field_176519_b, lowerState.func_177229_b((Property)DoorBlock.field_176519_b));
        state = (BlockState)state.func_206870_a((Property)DoorBlock.field_176521_M, upperState.func_177229_b((Property)DoorBlock.field_176521_M));
        state = (BlockState)state.func_206870_a((Property)DoorBlock.field_176522_N, upperState.func_177229_b((Property)DoorBlock.field_176522_N));
        matrixStack.func_227860_a_();
        this.renderBlock(matrixStack, buffer, tile, lowerState.func_177230_c(), state, light, overlay);
        matrixStack.func_227865_b_();
    }

    private void renderBlock(MatrixStack matrixStack, IRenderTypeBuffer buffer, TileDoor tile, Block b, BlockState state, int light, int overlay) {
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel ibakedmodel = dispatcher.func_184389_a(state);
        if (ibakedmodel == null) {
            dispatcher.func_228791_a_(state, matrixStack, buffer, light, overlay);
        } else {
            dispatcher.func_175019_b().renderModel(matrixStack.func_227866_c_(), buffer.getBuffer(RenderTypeLookup.func_239220_a_((BlockState)state, (boolean)false)), state, ibakedmodel, 1.0f, 1.0f, 1.0f, light, overlay, (IModelData)EmptyModelData.INSTANCE);
        }
    }

    private boolean overrideModel() {
        ItemStack held = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        if (held == null) {
            return false;
        }
        return held.func_77973_b() == CustomItems.wand || held.func_77973_b() == CustomItems.scripter || held.func_77973_b() == CustomBlocks.scripted_door_item;
    }
}

