/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NBTTags;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.QuestCategory;
import noppes.npcs.controllers.data.RecipeCarpentry;
import noppes.npcs.items.ItemScripted;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketSync;

public class SyncController {
    public static void syncPlayer(ServerPlayerEntity player) {
        ListNBT list = new ListNBT();
        for (Faction faction : FactionController.instance.factions.values()) {
            list.add((Object)faction.writeNBT(new CompoundNBT()));
        }
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("Data", (INBT)list);
        Packets.send(player, new PacketSync(1, compound, true));
        for (QuestCategory questCategory : QuestController.instance.categories.values()) {
            Packets.send(player, new PacketSync(3, questCategory.writeNBT(new CompoundNBT()), false));
        }
        Packets.send(player, new PacketSync(3, new CompoundNBT(), true));
        for (DialogCategory dialogCategory : DialogController.instance.categories.values()) {
            Packets.send(player, new PacketSync(5, dialogCategory.writeNBT(new CompoundNBT()), false));
        }
        Packets.send(player, new PacketSync(5, new CompoundNBT(), true));
        list = new ListNBT();
        for (RecipeCarpentry recipeCarpentry : RecipeController.instance.globalRecipes.values()) {
            list.add((Object)recipeCarpentry.writeNBT());
            if (list.size() <= 10) continue;
            compound = new CompoundNBT();
            compound.func_218657_a("Data", (INBT)list);
            Packets.send(player, new PacketSync(6, compound, false));
            list = new ListNBT();
        }
        compound = new CompoundNBT();
        compound.func_218657_a("Data", (INBT)list);
        Packets.send(player, new PacketSync(6, compound, true));
        list = new ListNBT();
        for (RecipeCarpentry recipeCarpentry : RecipeController.instance.anvilRecipes.values()) {
            list.add((Object)recipeCarpentry.writeNBT());
            if (list.size() <= 10) continue;
            compound = new CompoundNBT();
            compound.func_218657_a("Data", (INBT)list);
            Packets.send(player, new PacketSync(7, compound, false));
            list = new ListNBT();
        }
        compound = new CompoundNBT();
        compound.func_218657_a("Data", (INBT)list);
        Packets.send(player, new PacketSync(7, compound, true));
        PlayerData playerData = PlayerData.get((PlayerEntity)player);
        Packets.send(player, new PacketSync(8, playerData.getNBT(), true));
        SyncController.syncScriptItems(player);
    }

    public static void syncAllDialogs() {
        for (DialogCategory category : DialogController.instance.categories.values()) {
            Packets.sendAll(new PacketSync(5, category.writeNBT(new CompoundNBT()), false));
        }
        Packets.sendAll(new PacketSync(5, new CompoundNBT(), true));
    }

    public static void syncAllQuests() {
        for (QuestCategory category : QuestController.instance.categories.values()) {
            Packets.sendAll(new PacketSync(3, category.writeNBT(new CompoundNBT()), false));
        }
        Packets.sendAll(new PacketSync(3, new CompoundNBT(), true));
    }

    public static void syncScriptItems(ServerPlayerEntity player) {
        CompoundNBT comp = new CompoundNBT();
        comp.func_218657_a("List", NBTTags.nbtIntegerStringMap(ItemScripted.Resources));
        Packets.send(player, new PacketSync(9, comp, true));
    }

    public static void syncScriptItemsEverybody() {
        CompoundNBT comp = new CompoundNBT();
        comp.func_218657_a("List", NBTTags.nbtIntegerStringMap(ItemScripted.Resources));
        for (ServerPlayerEntity player : CustomNpcs.Server.func_184103_al().func_181057_v()) {
            Packets.send(player, new PacketSync(9, comp, true));
        }
    }
}

