/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import noppes.npcs.NBTTags;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;
import noppes.npcs.roles.RoleInterface;

public class DataTransform {
    public CompoundNBT display;
    public CompoundNBT ai;
    public CompoundNBT advanced;
    public CompoundNBT inv;
    public CompoundNBT stats;
    public CompoundNBT role;
    public CompoundNBT job;
    public boolean hasDisplay;
    public boolean hasAi;
    public boolean hasAdvanced;
    public boolean hasInv;
    public boolean hasStats;
    public boolean hasRole;
    public boolean hasJob;
    public boolean isActive;
    private EntityNPCInterface npc;
    public boolean editingModus = false;

    public DataTransform(EntityNPCInterface npc) {
        this.npc = npc;
    }

    public CompoundNBT save(CompoundNBT compound) {
        compound.func_74757_a("TransformIsActive", this.isActive);
        this.writeOptions(compound);
        if (this.hasDisplay) {
            compound.func_218657_a("TransformDisplay", (INBT)this.display);
        }
        if (this.hasAi) {
            compound.func_218657_a("TransformAI", (INBT)this.ai);
        }
        if (this.hasAdvanced) {
            compound.func_218657_a("TransformAdvanced", (INBT)this.advanced);
        }
        if (this.hasInv) {
            compound.func_218657_a("TransformInv", (INBT)this.inv);
        }
        if (this.hasStats) {
            compound.func_218657_a("TransformStats", (INBT)this.stats);
        }
        if (this.hasRole) {
            compound.func_218657_a("TransformRole", (INBT)this.role);
        }
        if (this.hasJob) {
            compound.func_218657_a("TransformJob", (INBT)this.job);
        }
        return compound;
    }

    public CompoundNBT writeOptions(CompoundNBT compound) {
        compound.func_74757_a("TransformHasDisplay", this.hasDisplay);
        compound.func_74757_a("TransformHasAI", this.hasAi);
        compound.func_74757_a("TransformHasAdvanced", this.hasAdvanced);
        compound.func_74757_a("TransformHasInv", this.hasInv);
        compound.func_74757_a("TransformHasStats", this.hasStats);
        compound.func_74757_a("TransformHasRole", this.hasRole);
        compound.func_74757_a("TransformHasJob", this.hasJob);
        compound.func_74757_a("TransformEditingModus", this.editingModus);
        return compound;
    }

    public void readToNBT(CompoundNBT compound) {
        this.isActive = compound.func_74767_n("TransformIsActive");
        this.readOptions(compound);
        this.display = this.hasDisplay ? compound.func_74775_l("TransformDisplay") : this.getDisplay();
        this.ai = this.hasAi ? compound.func_74775_l("TransformAI") : this.npc.ais.save(new CompoundNBT());
        this.advanced = this.hasAdvanced ? compound.func_74775_l("TransformAdvanced") : this.getAdvanced();
        this.inv = this.hasInv ? compound.func_74775_l("TransformInv") : this.npc.inventory.save(new CompoundNBT());
        this.stats = this.hasStats ? compound.func_74775_l("TransformStats") : this.npc.stats.save(new CompoundNBT());
        this.job = this.hasJob ? compound.func_74775_l("TransformJob") : this.getJob();
        this.role = this.hasRole ? compound.func_74775_l("TransformRole") : this.getRole();
    }

    public CompoundNBT getJob() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("NpcJob", this.npc.job.getType());
        this.npc.job.save(compound);
        return compound;
    }

    public CompoundNBT getRole() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("Role", this.npc.role.getType());
        this.npc.role.save(compound);
        return compound;
    }

    public CompoundNBT getDisplay() {
        CompoundNBT compound = this.npc.display.save(new CompoundNBT());
        if (this.npc instanceof EntityCustomNpc) {
            compound.func_218657_a("ModelData", (INBT)((EntityCustomNpc)this.npc).modelData.save());
        }
        return compound;
    }

    public CompoundNBT getAdvanced() {
        JobInterface jopType = this.npc.job;
        RoleInterface roleType = this.npc.role;
        this.npc.job = JobInterface.NONE;
        this.npc.role = RoleInterface.NONE;
        CompoundNBT compound = this.npc.advanced.save(new CompoundNBT());
        this.npc.job = jopType;
        this.npc.role = roleType;
        return compound;
    }

    public void readOptions(CompoundNBT compound) {
        boolean hadDisplay = this.hasDisplay;
        boolean hadAI = this.hasAi;
        boolean hadAdvanced = this.hasAdvanced;
        boolean hadInv = this.hasInv;
        boolean hadStats = this.hasStats;
        boolean hadRole = this.hasRole;
        boolean hadJob = this.hasJob;
        this.hasDisplay = compound.func_74767_n("TransformHasDisplay");
        this.hasAi = compound.func_74767_n("TransformHasAI");
        this.hasAdvanced = compound.func_74767_n("TransformHasAdvanced");
        this.hasInv = compound.func_74767_n("TransformHasInv");
        this.hasStats = compound.func_74767_n("TransformHasStats");
        this.hasRole = compound.func_74767_n("TransformHasRole");
        this.hasJob = compound.func_74767_n("TransformHasJob");
        this.editingModus = compound.func_74767_n("TransformEditingModus");
        if (this.hasDisplay && !hadDisplay) {
            this.display = this.getDisplay();
        }
        if (this.hasAi && !hadAI) {
            this.ai = this.npc.ais.save(new CompoundNBT());
        }
        if (this.hasStats && !hadStats) {
            this.stats = this.npc.stats.save(new CompoundNBT());
        }
        if (this.hasInv && !hadInv) {
            this.inv = this.npc.inventory.save(new CompoundNBT());
        }
        if (this.hasAdvanced && !hadAdvanced) {
            this.advanced = this.getAdvanced();
        }
        if (this.hasJob && !hadJob) {
            this.job = this.getJob();
        }
        if (this.hasRole && !hadRole) {
            this.role = this.getRole();
        }
    }

    public boolean isValid() {
        return this.hasAdvanced || this.hasAi || this.hasDisplay || this.hasInv || this.hasStats || this.hasJob || this.hasRole;
    }

    public CompoundNBT processAdvanced(CompoundNBT compoundAdv, CompoundNBT compoundRole, CompoundNBT compoundJob) {
        if (this.hasAdvanced) {
            compoundAdv = this.advanced;
        }
        if (this.hasRole) {
            compoundRole = this.role;
        }
        if (this.hasJob) {
            compoundJob = this.job;
        }
        Set names = compoundRole.func_150296_c();
        for (String name : names) {
            compoundAdv.func_218657_a(name, compoundRole.func_74781_a(name));
        }
        names = compoundJob.func_150296_c();
        for (String name : names) {
            compoundAdv.func_218657_a(name, compoundJob.func_74781_a(name));
        }
        return compoundAdv;
    }

    public void transform(boolean isActive) {
        CompoundNBT compound;
        if (this.isActive == isActive) {
            return;
        }
        if (this.hasDisplay) {
            compound = this.getDisplay();
            this.npc.display.readToNBT(NBTTags.NBTMerge(compound, this.display));
            if (this.npc instanceof EntityCustomNpc) {
                ((EntityCustomNpc)this.npc).modelData.load(NBTTags.NBTMerge(compound.func_74775_l("ModelData"), this.display.func_74775_l("ModelData")));
            }
            this.display = compound;
        }
        if (this.hasStats) {
            compound = this.npc.stats.save(new CompoundNBT());
            this.npc.stats.readToNBT(NBTTags.NBTMerge(compound, this.stats));
            this.stats = compound;
        }
        if (this.hasAdvanced || this.hasJob || this.hasRole) {
            CompoundNBT compoundAdv = this.getAdvanced();
            CompoundNBT compoundRole = this.getRole();
            CompoundNBT compoundJob = this.getJob();
            CompoundNBT compound2 = this.processAdvanced(compoundAdv, compoundRole, compoundJob);
            this.npc.advanced.readToNBT(compound2);
            if (this.npc.role.getType() != 0) {
                this.npc.role.load(NBTTags.NBTMerge(compoundRole, compound2));
            }
            if (this.npc.job.getType() != 0) {
                this.npc.job.load(NBTTags.NBTMerge(compoundJob, compound2));
            }
            if (this.hasAdvanced) {
                this.advanced = compoundAdv;
            }
            if (this.hasRole) {
                this.role = compoundRole;
            }
            if (this.hasJob) {
                this.job = compoundJob;
            }
        }
        if (this.hasAi) {
            compound = this.npc.ais.save(new CompoundNBT());
            this.npc.ais.readToNBT(NBTTags.NBTMerge(compound, this.ai));
            this.ai = compound;
            this.npc.setCurrentAnimation(0);
        }
        if (this.hasInv) {
            compound = this.npc.inventory.save(new CompoundNBT());
            this.npc.inventory.load(NBTTags.NBTMerge(compound, this.inv));
            this.inv = compound;
        }
        this.npc.updateAI = true;
        this.isActive = isActive;
        this.npc.updateClient = true;
    }
}

