/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.HashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import noppes.npcs.EventHooks;
import noppes.npcs.constants.EnumQuestCompletion;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketAchievement;
import noppes.npcs.packets.client.PacketChat;
import noppes.npcs.quests.QuestInterface;

public class PlayerQuestData {
    public HashMap<Integer, QuestData> activeQuests = new HashMap();
    public HashMap<Integer, Long> finishedQuests = new HashMap();

    public void loadNBTData(CompoundNBT mainCompound) {
        ListNBT list2;
        if (mainCompound == null) {
            return;
        }
        CompoundNBT compound = mainCompound.func_74775_l("QuestData");
        ListNBT list = compound.func_150295_c("CompletedQuests", 10);
        if (list != null) {
            HashMap<Integer, Long> finishedQuests = new HashMap<Integer, Long>();
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT nbttagcompound = list.func_150305_b(i);
                finishedQuests.put(nbttagcompound.func_74762_e("Quest"), nbttagcompound.func_74763_f("Date"));
            }
            this.finishedQuests = finishedQuests;
        }
        if ((list2 = compound.func_150295_c("ActiveQuests", 10)) != null) {
            HashMap<Integer, QuestData> activeQuests = new HashMap<Integer, QuestData>();
            for (int i = 0; i < list2.size(); ++i) {
                CompoundNBT nbttagcompound = list2.func_150305_b(i);
                int id = nbttagcompound.func_74762_e("Quest");
                Quest quest = QuestController.instance.quests.get(id);
                if (quest == null) continue;
                QuestData data = new QuestData(quest);
                data.readAdditionalSaveData(nbttagcompound);
                activeQuests.put(id, data);
            }
            this.activeQuests = activeQuests;
        }
    }

    public void saveNBTData(CompoundNBT maincompound) {
        CompoundNBT compound = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (int quest : this.finishedQuests.keySet()) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74768_a("Quest", quest);
            nbttagcompound.func_74772_a("Date", this.finishedQuests.get(quest).longValue());
            list.add((Object)nbttagcompound);
        }
        compound.func_218657_a("CompletedQuests", (INBT)list);
        ListNBT list2 = new ListNBT();
        for (int quest : this.activeQuests.keySet()) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74768_a("Quest", quest);
            this.activeQuests.get(quest).addAdditionalSaveData(nbttagcompound);
            list2.add((Object)nbttagcompound);
        }
        compound.func_218657_a("ActiveQuests", (INBT)list2);
        maincompound.func_218657_a("QuestData", (INBT)compound);
    }

    public QuestData getQuestCompletion(PlayerEntity player, EntityNPCInterface npc) {
        for (QuestData data : this.activeQuests.values()) {
            Quest quest = data.quest;
            if (quest == null || quest.completion != EnumQuestCompletion.Npc || !quest.completerNpc.equals(npc.func_200200_C_().getString()) || !quest.questInterface.isCompleted(player)) continue;
            return data;
        }
        return null;
    }

    public boolean checkQuestCompletion(PlayerEntity player, int type) {
        boolean bo = false;
        for (QuestData data : this.activeQuests.values()) {
            if (data.quest.type != type && type >= 0) continue;
            QuestInterface inter = data.quest.questInterface;
            if (inter.isCompleted(player)) {
                if (data.isCompleted) continue;
                if (!data.quest.complete(player, data)) {
                    Packets.send((ServerPlayerEntity)player, new PacketAchievement((ITextComponent)new TranslationTextComponent("quest.completed"), (ITextComponent)new TranslationTextComponent(data.quest.title), 2));
                    Packets.send((ServerPlayerEntity)player, new PacketChat((ITextComponent)new TranslationTextComponent("quest.completed").func_240702_b_(": ").func_230529_a_((ITextComponent)new TranslationTextComponent(data.quest.title))));
                }
                data.isCompleted = true;
                bo = true;
                EventHooks.onQuestFinished(PlayerData.get((PlayerEntity)player).scriptData, data.quest);
                continue;
            }
            data.isCompleted = false;
        }
        return bo;
    }
}

