/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import com.mojang.authlib.GameProfile;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.world.BossInfo;
import net.minecraftforge.registries.ForgeRegistries;
import nikedemos.markovnames.generators.MarkovGenerator;
import noppes.npcs.ModelData;
import noppes.npcs.ModelPartConfig;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.INPCDisplay;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.controllers.VisibilityController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.ValueUtil;

public class DataDisplay
implements INPCDisplay {
    EntityNPCInterface npc;
    private String name = "Noppes";
    private String title = "";
    private int markovGeneratorId = 8;
    private int markovGender = 0;
    public byte skinType = 0;
    private String url = "";
    public GameProfile playerProfile;
    private String texture = "customnpcs:textures/entity/humanmale/steve.png";
    private String cloakTexture = "";
    private String glowTexture = "";
    private int visible = 0;
    public Availability availability = new Availability();
    private int modelSize = 5;
    private int showName = 0;
    private int skinColor = 0xFFFFFF;
    private boolean disableLivingAnimation = false;
    private boolean noHitbox = false;
    private byte showBossBar = 0;
    private BossInfo.Color bossColor = BossInfo.Color.PINK;

    public DataDisplay(EntityNPCInterface npc) {
        this.npc = npc;
        if (!npc.isClientSide()) {
            this.markovGeneratorId = new Random().nextInt(MarkovGenerator.GENERATOR.length - 1);
            this.name = this.getRandomName();
        }
    }

    public String getRandomName() {
        return MarkovGenerator.GENERATOR[this.markovGeneratorId].fetch(this.markovGender);
    }

    public CompoundNBT save(CompoundNBT nbttagcompound) {
        nbttagcompound.func_74778_a("Name", this.name);
        nbttagcompound.func_74768_a("MarkovGeneratorId", this.markovGeneratorId);
        nbttagcompound.func_74768_a("MarkovGender", this.markovGender);
        nbttagcompound.func_74778_a("Title", this.title);
        nbttagcompound.func_74778_a("SkinUrl", this.url);
        nbttagcompound.func_74778_a("Texture", this.texture);
        nbttagcompound.func_74778_a("CloakTexture", this.cloakTexture);
        nbttagcompound.func_74778_a("GlowTexture", this.glowTexture);
        nbttagcompound.func_74774_a("UsingSkinUrl", this.skinType);
        if (this.playerProfile != null) {
            CompoundNBT nbttagcompound1 = new CompoundNBT();
            NBTUtil.func_180708_a((CompoundNBT)nbttagcompound1, (GameProfile)this.playerProfile);
            nbttagcompound.func_218657_a("SkinUsername", (INBT)nbttagcompound1);
        }
        nbttagcompound.func_74768_a("Size", this.modelSize);
        nbttagcompound.func_74768_a("ShowName", this.showName);
        nbttagcompound.func_74768_a("SkinColor", this.skinColor);
        nbttagcompound.func_74768_a("NpcVisible", this.visible);
        nbttagcompound.func_218657_a("VisibleAvailability", (INBT)this.availability.save(new CompoundNBT()));
        nbttagcompound.func_74757_a("NoLivingAnimation", this.disableLivingAnimation);
        nbttagcompound.func_74757_a("IsStatue", this.noHitbox);
        nbttagcompound.func_74774_a("BossBar", this.showBossBar);
        nbttagcompound.func_74768_a("BossColor", this.bossColor.ordinal());
        return nbttagcompound;
    }

    public void readToNBT(CompoundNBT nbttagcompound) {
        this.setName(nbttagcompound.func_74779_i("Name"));
        this.setMarkovGeneratorId(nbttagcompound.func_74762_e("MarkovGeneratorId"));
        this.setMarkovGender(nbttagcompound.func_74762_e("MarkovGender"));
        this.title = nbttagcompound.func_74779_i("Title");
        byte prevSkinType = this.skinType;
        String prevTexture = this.texture;
        String prevUrl = this.url;
        String prevPlayer = this.getSkinPlayer();
        this.url = nbttagcompound.func_74779_i("SkinUrl");
        this.skinType = nbttagcompound.func_74771_c("UsingSkinUrl");
        this.texture = nbttagcompound.func_74779_i("Texture");
        this.cloakTexture = nbttagcompound.func_74779_i("CloakTexture");
        this.glowTexture = nbttagcompound.func_74779_i("GlowTexture");
        this.playerProfile = null;
        if (this.skinType == 1) {
            if (nbttagcompound.func_150297_b("SkinUsername", 10)) {
                this.playerProfile = NBTUtil.func_152459_a((CompoundNBT)nbttagcompound.func_74775_l("SkinUsername"));
            } else if (nbttagcompound.func_150297_b("SkinUsername", 8) && !StringUtils.func_151246_b((String)nbttagcompound.func_74779_i("SkinUsername"))) {
                this.playerProfile = new GameProfile(null, nbttagcompound.func_74779_i("SkinUsername"));
            }
            this.loadProfile();
        }
        this.modelSize = ValueUtil.CorrectInt(nbttagcompound.func_74762_e("Size"), 1, 30);
        this.showName = nbttagcompound.func_74762_e("ShowName");
        if (nbttagcompound.func_74764_b("SkinColor")) {
            this.skinColor = nbttagcompound.func_74762_e("SkinColor");
        }
        this.visible = nbttagcompound.func_74762_e("NpcVisible");
        this.availability.load(nbttagcompound.func_74775_l("VisibleAvailability"));
        VisibilityController.instance.trackNpc(this.npc);
        this.disableLivingAnimation = nbttagcompound.func_74767_n("NoLivingAnimation");
        this.noHitbox = nbttagcompound.func_74767_n("IsStatue");
        this.setBossbar(nbttagcompound.func_74771_c("BossBar"));
        this.setBossColor(nbttagcompound.func_74762_e("BossColor"));
        if (!(prevSkinType == this.skinType && this.texture.equals(prevTexture) && this.url.equals(prevUrl) && this.getSkinPlayer().equals(prevPlayer))) {
            this.npc.textureLocation = null;
        }
        this.npc.textureGlowLocation = null;
        this.npc.textureCloakLocation = null;
        this.npc.func_213323_x_();
    }

    public void loadProfile() {
        if (this.playerProfile != null && !StringUtils.func_151246_b((String)this.playerProfile.getName())) {
            this.playerProfile = SkullTileEntity.func_174884_b((GameProfile)this.playerProfile);
        }
    }

    public boolean showName() {
        if (this.npc.isKilled()) {
            return false;
        }
        return this.showName == 0 || this.showName == 2 && this.npc.isAttacking();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.name.equals(name)) {
            return;
        }
        this.name = name;
        this.npc.bossInfo.func_186739_a(this.npc.func_145748_c_());
        this.npc.updateClient = true;
    }

    @Override
    public int getShowName() {
        return this.showName;
    }

    @Override
    public void setShowName(int type) {
        if (type == this.showName) {
            return;
        }
        this.showName = ValueUtil.CorrectInt(type, 0, 2);
        this.npc.updateClient = true;
    }

    public int getMarkovGender() {
        return this.markovGender;
    }

    public void setMarkovGender(int gender) {
        if (this.markovGender == gender) {
            return;
        }
        this.markovGender = ValueUtil.CorrectInt(gender, 0, 2);
    }

    public int getMarkovGeneratorId() {
        return this.markovGeneratorId;
    }

    public void setMarkovGeneratorId(int id) {
        if (this.markovGeneratorId == id) {
            return;
        }
        this.markovGeneratorId = ValueUtil.CorrectInt(id, 0, MarkovGenerator.GENERATOR.length - 1);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        if (this.title.equals(title)) {
            return;
        }
        this.title = title;
        this.npc.updateClient = true;
    }

    @Override
    public String getSkinUrl() {
        return this.url;
    }

    @Override
    public void setSkinUrl(String url) {
        if (this.url.equals(url)) {
            return;
        }
        this.url = url;
        this.skinType = url.isEmpty() ? (byte)0 : (byte)2;
        this.npc.updateClient = true;
    }

    @Override
    public String getSkinPlayer() {
        return this.playerProfile == null ? "" : this.playerProfile.getName();
    }

    @Override
    public void setSkinPlayer(String name) {
        if (name == null || name.isEmpty()) {
            this.playerProfile = null;
            this.skinType = 0;
        } else {
            this.playerProfile = new GameProfile(null, name);
            this.skinType = 1;
        }
        this.npc.updateClient = true;
    }

    @Override
    public String getSkinTexture() {
        return NoppesStringUtils.cleanResource(this.texture);
    }

    @Override
    public void setSkinTexture(String texture) {
        if (texture == null || this.texture.equals(texture)) {
            return;
        }
        this.texture = NoppesStringUtils.cleanResource(texture);
        this.npc.textureLocation = null;
        this.skinType = 0;
        this.npc.updateClient = true;
    }

    @Override
    public String getOverlayTexture() {
        return NoppesStringUtils.cleanResource(this.glowTexture);
    }

    @Override
    public void setOverlayTexture(String texture) {
        if (this.glowTexture.equals(texture)) {
            return;
        }
        this.glowTexture = NoppesStringUtils.cleanResource(texture);
        this.npc.textureGlowLocation = null;
        this.npc.updateClient = true;
    }

    @Override
    public String getCapeTexture() {
        return NoppesStringUtils.cleanResource(this.cloakTexture);
    }

    @Override
    public void setCapeTexture(String texture) {
        if (this.cloakTexture.equals(texture)) {
            return;
        }
        this.cloakTexture = NoppesStringUtils.cleanResource(texture);
        this.npc.textureCloakLocation = null;
        this.npc.updateClient = true;
    }

    @Override
    public boolean getHasLivingAnimation() {
        return !this.disableLivingAnimation;
    }

    @Override
    public void setHasLivingAnimation(boolean enabled) {
        this.disableLivingAnimation = !enabled;
        this.npc.updateClient = true;
    }

    @Override
    public int getBossbar() {
        return this.showBossBar;
    }

    @Override
    public void setBossbar(int type) {
        if (type == this.showBossBar) {
            return;
        }
        this.showBossBar = (byte)ValueUtil.CorrectInt(type, 0, 2);
        this.npc.bossInfo.func_186758_d(this.showBossBar == 1);
        this.npc.updateClient = true;
    }

    @Override
    public int getBossColor() {
        return this.bossColor.ordinal();
    }

    @Override
    public void setBossColor(int color) {
        if (color < 0 || color >= BossInfo.Color.values().length) {
            throw new CustomNPCsException("Invalid Boss Color: " + color, new Object[0]);
        }
        this.bossColor = BossInfo.Color.values()[color];
        this.npc.bossInfo.func_186745_a(this.bossColor);
    }

    @Override
    public int getVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(int type) {
        if (type == this.visible) {
            return;
        }
        this.visible = ValueUtil.CorrectInt(type, 0, 2);
        this.npc.updateClient = true;
    }

    @Override
    public int getSize() {
        return this.modelSize;
    }

    @Override
    public void setSize(int size) {
        if (this.modelSize == size) {
            return;
        }
        this.modelSize = ValueUtil.CorrectInt(size, 1, 30);
        this.npc.updateClient = true;
    }

    @Override
    public void setModelScale(int part, float x, float y, float z) {
        ModelData modeldata = ((EntityCustomNpc)this.npc).modelData;
        ModelPartConfig model = null;
        if (part == 0) {
            model = modeldata.getPartConfig(EnumParts.HEAD);
        } else if (part == 1) {
            model = modeldata.getPartConfig(EnumParts.BODY);
        } else if (part == 2) {
            model = modeldata.getPartConfig(EnumParts.ARM_LEFT);
        } else if (part == 3) {
            model = modeldata.getPartConfig(EnumParts.ARM_RIGHT);
        } else if (part == 4) {
            model = modeldata.getPartConfig(EnumParts.LEG_LEFT);
        } else if (part == 5) {
            model = modeldata.getPartConfig(EnumParts.LEG_RIGHT);
        }
        if (model == null) {
            throw new CustomNPCsException("Unknown part: " + part, new Object[0]);
        }
        model.setScale(x, y, z);
        this.npc.updateClient = true;
    }

    @Override
    public float[] getModelScale(int part) {
        ModelData modeldata = ((EntityCustomNpc)this.npc).modelData;
        ModelPartConfig model = null;
        if (part == 0) {
            model = modeldata.getPartConfig(EnumParts.HEAD);
        } else if (part == 1) {
            model = modeldata.getPartConfig(EnumParts.BODY);
        } else if (part == 2) {
            model = modeldata.getPartConfig(EnumParts.ARM_LEFT);
        } else if (part == 3) {
            model = modeldata.getPartConfig(EnumParts.ARM_RIGHT);
        } else if (part == 4) {
            model = modeldata.getPartConfig(EnumParts.LEG_LEFT);
        } else if (part == 5) {
            model = modeldata.getPartConfig(EnumParts.LEG_RIGHT);
        }
        if (model == null) {
            throw new CustomNPCsException("Unknown part: " + part, new Object[0]);
        }
        return new float[]{model.scaleX, model.scaleY, model.scaleZ};
    }

    @Override
    public int getTint() {
        return this.skinColor;
    }

    @Override
    public void setTint(int color) {
        if (color == this.skinColor) {
            return;
        }
        this.skinColor = color;
        this.npc.updateClient = true;
    }

    @Override
    public void setModel(String id) {
        ModelData modeldata = ((EntityCustomNpc)this.npc).modelData;
        if (id == null) {
            if (modeldata.getEntityName() == null) {
                return;
            }
            modeldata.setEntity((String)null);
            this.npc.updateClient = true;
        } else {
            ResourceLocation resource = new ResourceLocation(id);
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(resource);
            if (type == null) {
                throw new CustomNPCsException("Unknown entity id: " + id, new Object[0]);
            }
            modeldata.setEntity(id);
            this.npc.updateClient = true;
        }
    }

    @Override
    public String getModel() {
        ModelData modeldata = ((EntityCustomNpc)this.npc).modelData;
        if (modeldata.getEntityName() == null) {
            return null;
        }
        return modeldata.getEntityName().toString();
    }

    @Override
    public boolean getHasHitbox() {
        return !this.noHitbox;
    }

    @Override
    public void setHasHitbox(boolean bo) {
        if (this.noHitbox != bo) {
            return;
        }
        this.noHitbox = !bo;
        this.npc.updateClient = true;
    }

    @Override
    public boolean isVisibleTo(IPlayer player) {
        return this.isVisibleTo(player);
    }

    public boolean isVisibleTo(ServerPlayerEntity player) {
        if (this.visible == 1) {
            return !this.availability.isAvailable((PlayerEntity)player);
        }
        return this.availability.isAvailable((PlayerEntity)player);
    }
}

