/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.network.NetworkEvent;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.entity.EntityNPCInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PacketServerBasic {
    private static final Logger LOGGER = LogManager.getLogger();
    public ServerPlayerEntity player;
    public EntityNPCInterface npc;

    public boolean requiresNpc() {
        return false;
    }

    public CustomNpcsPermissions.Permission getPermission() {
        return null;
    }

    public boolean toolAllowed(ItemStack item) {
        return item.func_77973_b() == CustomItems.wand;
    }

    public static void handle(PacketServerBasic msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            msg.player = ((NetworkEvent.Context)ctx.get()).getSender();
            msg.npc = NoppesUtilServer.getEditingNpc((PlayerEntity)msg.player);
            if (msg.requiresNpc() && msg.npc == null) {
                return;
            }
            if (msg.getPermission() != null && !CustomNpcsPermissions.hasPermission((PlayerEntity)msg.player, msg.getPermission())) {
                return;
            }
            if (!msg.toolAllowed(msg.player.field_71071_by.func_70448_g())) {
                msg.warn("tried to use custom npcs without a tool in hand, possibly a hacker");
                return;
            }
            msg.handle();
        });
        ctx.get().setPacketHandled(true);
    }

    private void warn(String warning) {
        LOGGER.warn(this.player.func_200200_C_().getString() + ": " + warning + " - " + this);
    }

    protected abstract void handle();
}

