/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.client;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestCategory;
import noppes.npcs.packets.PacketBasic;

public class PacketSyncUpdate
extends PacketBasic {
    private final int id;
    private final int type;
    private final CompoundNBT data;

    public PacketSyncUpdate(int id, int type, CompoundNBT data) {
        this.id = id;
        this.type = type;
        this.data = data;
    }

    public static void encode(PacketSyncUpdate msg, PacketBuffer buf) {
        buf.writeInt(msg.id);
        buf.writeInt(msg.type);
        buf.func_150786_a(msg.data);
    }

    public static PacketSyncUpdate decode(PacketBuffer buf) {
        return new PacketSyncUpdate(buf.readInt(), buf.readInt(), buf.func_150793_b());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle() {
        if (this.type == 1) {
            Faction faction = new Faction();
            faction.readNBT(this.data);
            FactionController.instance.factions.put(faction.id, faction);
        } else if (this.type == 4) {
            DialogCategory category = DialogController.instance.categories.get(this.id);
            Dialog dialog = new Dialog(category);
            dialog.readNBT(this.data);
            DialogController.instance.dialogs.put(dialog.id, dialog);
            category.dialogs.put(dialog.id, dialog);
        } else if (this.type == 5) {
            DialogCategory category = new DialogCategory();
            category.readNBT(this.data);
            DialogController.instance.categories.put(category.id, category);
        } else if (this.type == 2) {
            QuestCategory category = QuestController.instance.categories.get(this.id);
            Quest quest = new Quest(category);
            quest.readNBT(this.data);
            QuestController.instance.quests.put(quest.id, quest);
            category.quests.put(quest.id, quest);
        } else if (this.type == 3) {
            QuestCategory category = new QuestCategory();
            category.readNBT(this.data);
            QuestController.instance.categories.put(category.id, category);
        }
    }

    public void clientSync(boolean syncEnd) {
    }
}

