/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestCategory;
import noppes.npcs.packets.PacketServerBasic;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketGuiUpdate;

public class SPacketQuestSave
extends PacketServerBasic {
    private int categoryId;
    private CompoundNBT data;

    public SPacketQuestSave(int categoryId, CompoundNBT data) {
        this.data = data;
        this.categoryId = categoryId;
    }

    @Override
    public CustomNpcsPermissions.Permission getPermission() {
        return CustomNpcsPermissions.GLOBAL_QUEST;
    }

    public static void encode(SPacketQuestSave msg, PacketBuffer buf) {
        buf.writeInt(msg.categoryId);
        buf.func_150786_a(msg.data);
    }

    public static SPacketQuestSave decode(PacketBuffer buf) {
        return new SPacketQuestSave(buf.readInt(), buf.func_150793_b());
    }

    @Override
    protected void handle() {
        QuestCategory category = QuestController.instance.categories.get(this.categoryId);
        if (category == null) {
            return;
        }
        Quest quest = new Quest(category);
        quest.readNBT(this.data);
        QuestController.instance.saveQuest(category, quest);
        Packets.send(this.player, new PacketGuiUpdate());
    }
}

