/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomItems;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.blocks.tiles.TileScriptedDoor;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.packets.PacketServerBasic;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketGuiData;

public class SPacketScriptGet
extends PacketServerBasic {
    private int type;

    public SPacketScriptGet(int type) {
        this.type = type;
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        return item.func_77973_b() == CustomItems.scripted_item || item.func_77973_b() == CustomItems.scripter || item.func_77973_b() == CustomBlocks.scripted_door_item || item.func_77973_b() == CustomBlocks.scripted_item;
    }

    @Override
    public boolean requiresNpc() {
        return this.type == 0;
    }

    public static void encode(SPacketScriptGet msg, PacketBuffer buf) {
        buf.writeInt(msg.type);
    }

    public static SPacketScriptGet decode(PacketBuffer buf) {
        return new SPacketScriptGet(buf.readInt());
    }

    @Override
    protected void handle() {
        TileEntity tile;
        PlayerData data;
        CompoundNBT compound = new CompoundNBT();
        if (this.type == 0) {
            this.npc.script.save(compound);
        }
        if (this.type == 1) {
            data = PlayerData.get((PlayerEntity)this.player);
            tile = this.player.field_70170_p.func_175625_s(data.scriptBlockPos);
            if (!(tile instanceof TileScripted)) {
                return;
            }
            ((TileScripted)tile).getNBT(compound);
        }
        if (this.type == 2) {
            ItemScriptedWrapper iw = (ItemScriptedWrapper)NpcAPI.Instance().getIItemStack(this.player.func_184614_ca());
            compound = iw.getMCNbt();
        }
        if (this.type == 3) {
            ScriptController.Instance.forgeScripts.save(compound);
        }
        if (this.type == 4) {
            ScriptController.Instance.playerScripts.save(compound);
        }
        if (this.type == 5) {
            data = PlayerData.get((PlayerEntity)this.player);
            tile = this.player.field_70170_p.func_175625_s(data.scriptBlockPos);
            if (!(tile instanceof TileScriptedDoor)) {
                return;
            }
            ((TileScriptedDoor)tile).getNBT(compound);
        }
        compound.func_218657_a("Languages", (INBT)ScriptController.Instance.nbtLanguages());
        Packets.send(this.player, new PacketGuiData(compound));
    }
}

