/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntityLiving;
import noppes.npcs.api.entity.data.role.IJobSpawner;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.server.SPacketToolMobSpawner;
import noppes.npcs.roles.JobInterface;
import org.apache.commons.lang3.RandomStringUtils;

public class JobSpawner
extends JobInterface
implements IJobSpawner {
    public Map<Integer, SpawnerData> data = new HashMap<Integer, SpawnerData>();
    private int number = 0;
    public List<LivingEntity> spawned = new ArrayList<LivingEntity>();
    private Map<String, Long> cooldown = new HashMap<String, Long>();
    private String id = RandomStringUtils.random((int)8, (boolean)true, (boolean)true);
    public boolean doesntDie = false;
    public int spawnType = 0;
    public int xOffset = 0;
    public int yOffset = 0;
    public int zOffset = 0;
    private LivingEntity target;
    public boolean despawnOnTargetLost = true;

    public JobSpawner(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public CompoundNBT save(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (Map.Entry<Integer, SpawnerData> entry : this.data.entrySet()) {
            CompoundNBT c = new CompoundNBT();
            c.func_74768_a("slot", entry.getKey().intValue());
            c.func_74768_a("tab", entry.getValue().tab);
            c.func_74778_a("name", entry.getValue().name);
            list.add((Object)c);
        }
        compound.func_218657_a("SpawnerData", (INBT)list);
        compound.func_74778_a("SpawnerId", this.id);
        compound.func_74757_a("SpawnerDoesntDie", this.doesntDie);
        compound.func_74768_a("SpawnerType", this.spawnType);
        compound.func_74768_a("SpawnerXOffset", this.xOffset);
        compound.func_74768_a("SpawnerYOffset", this.yOffset);
        compound.func_74768_a("SpawnerZOffset", this.zOffset);
        compound.func_74757_a("DespawnOnTargetLost", this.despawnOnTargetLost);
        return compound;
    }

    public CompoundNBT getTitles() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("Title1", this.getTitle(0));
        compound.func_74778_a("Title2", this.getTitle(1));
        compound.func_74778_a("Title3", this.getTitle(2));
        compound.func_74778_a("Title4", this.getTitle(3));
        compound.func_74778_a("Title5", this.getTitle(4));
        compound.func_74778_a("Title6", this.getTitle(5));
        return compound;
    }

    private String getTitle(int slot) {
        SpawnerData sd = this.data.get(slot);
        if (sd == null) {
            return "gui.selectnpc";
        }
        return sd.tab + ": " + sd.name;
    }

    @Override
    public void load(CompoundNBT compound) {
        HashMap<Integer, SpawnerData> data = new HashMap<Integer, SpawnerData>();
        ListNBT list = compound.func_150295_c("SpawnerData", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT c = list.func_150305_b(i);
            data.put(c.func_74762_e("slot"), new SpawnerData(c.func_74762_e("tab"), c.func_74779_i("name")));
        }
        this.data = data;
        this.id = compound.func_74779_i("SpawnerId");
        this.doesntDie = compound.func_74767_n("SpawnerDoesntDie");
        this.spawnType = compound.func_74762_e("SpawnerType");
        this.xOffset = compound.func_74762_e("SpawnerXOffset");
        this.yOffset = compound.func_74762_e("SpawnerYOffset");
        this.zOffset = compound.func_74762_e("SpawnerZOffset");
        this.despawnOnTargetLost = compound.func_74767_n("DespawnOnTargetLost");
    }

    public void cleanCompound(CompoundNBT compound) {
        compound.func_82580_o("SpawnerNBT1");
        compound.func_82580_o("SpawnerNBT2");
        compound.func_82580_o("SpawnerNBT3");
        compound.func_82580_o("SpawnerNBT4");
        compound.func_82580_o("SpawnerNBT5");
        compound.func_82580_o("SpawnerNBT6");
    }

    public void setJobCompound(int slot, int tab, String name) {
        this.data.put(slot, new SpawnerData(tab, name));
    }

    public void remove(int i) {
        this.data.remove(i);
    }

    @Override
    public void aiUpdateTask() {
        if (this.spawned.isEmpty()) {
            if (this.spawnType == 0 && this.spawnEntity(this.number) == null && !this.doesntDie) {
                this.npc.func_70106_y();
            }
            if (this.spawnType == 1) {
                if (this.number >= 6 && !this.doesntDie) {
                    this.npc.func_70106_y();
                } else {
                    this.spawnEntity(0);
                    this.spawnEntity(1);
                    this.spawnEntity(2);
                    this.spawnEntity(3);
                    this.spawnEntity(4);
                    this.spawnEntity(5);
                    this.number = 6;
                }
            }
            if (this.spawnType == 2) {
                ArrayList<CompoundNBT> list = new ArrayList<CompoundNBT>();
                for (SpawnerData d : this.data.values()) {
                    CompoundNBT c = d.getCompound();
                    if (c == null || !c.func_74764_b("id")) continue;
                    list.add(c);
                }
                if (!list.isEmpty()) {
                    CompoundNBT compound = (CompoundNBT)list.get(this.npc.func_70681_au().nextInt(list.size()));
                    this.spawnEntity(compound);
                } else if (!this.doesntDie) {
                    this.npc.func_70106_y();
                }
            }
        } else {
            this.checkSpawns();
        }
    }

    public void checkSpawns() {
        Iterator<LivingEntity> iterator = this.spawned.iterator();
        while (iterator.hasNext()) {
            LivingEntity spawn = iterator.next();
            if (this.shouldDelete(spawn)) {
                spawn.field_70128_L = true;
                iterator.remove();
                continue;
            }
            this.checkTarget(spawn);
        }
    }

    public void checkTarget(LivingEntity entity) {
        if (entity instanceof MobEntity) {
            MobEntity liv = (MobEntity)entity;
            if (liv.func_70638_az() == null || this.npc.func_70681_au().nextInt(100) == 1) {
                liv.func_70624_b(this.target);
            }
        } else if (entity.func_70643_av() == null || this.npc.func_70681_au().nextInt(100) == 1) {
            entity.func_70604_c(this.target);
        }
    }

    public boolean shouldDelete(LivingEntity entity) {
        return !this.npc.isInRange((Entity)entity, 60.0) || entity.field_70128_L || entity.func_110143_aJ() <= 0.0f || this.despawnOnTargetLost && this.target == null;
    }

    private LivingEntity getTarget() {
        LivingEntity target = this.getTarget((LivingEntity)this.npc);
        if (target != null) {
            return target;
        }
        for (LivingEntity entity : this.spawned) {
            target = this.getTarget(entity);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    private LivingEntity getTarget(LivingEntity entity) {
        if (entity instanceof MobEntity) {
            this.target = ((MobEntity)entity).func_70638_az();
            if (this.target != null && !this.target.field_70128_L && this.target.func_110143_aJ() > 0.0f) {
                return this.target;
            }
        }
        this.target = entity.func_70643_av();
        if (this.target != null && !this.target.field_70128_L && this.target.func_110143_aJ() > 0.0f) {
            return this.target;
        }
        return null;
    }

    private void setTarget(LivingEntity base, LivingEntity target) {
        if (base instanceof MobEntity) {
            ((MobEntity)base).func_70624_b(target);
        } else {
            base.func_70604_c(target);
        }
    }

    @Override
    public boolean aiShouldExecute() {
        if (this.data.isEmpty() || this.npc.isKilled()) {
            return false;
        }
        this.target = this.getTarget();
        if (this.npc.func_70681_au().nextInt(30) == 1 && this.spawned.isEmpty()) {
            this.spawned = this.getNearbySpawned();
        }
        if (!this.spawned.isEmpty()) {
            this.checkSpawns();
        }
        return this.target != null;
    }

    @Override
    public boolean aiContinueExecute() {
        return this.aiShouldExecute();
    }

    @Override
    public void stop() {
        this.reset();
    }

    @Override
    public void aiStartExecuting() {
        this.number = 0;
        for (LivingEntity entity : this.spawned) {
            int i = entity.getPersistentData().func_74762_e("NpcSpawnerNr");
            if (i > this.number) {
                this.number = i;
            }
            this.setTarget(entity, this.npc.func_70638_az());
        }
    }

    @Override
    public void reset() {
        this.number = 0;
        if (this.spawned.isEmpty()) {
            this.spawned = this.getNearbySpawned();
        }
        this.target = null;
        this.checkSpawns();
    }

    @Override
    public void killed() {
        this.reset();
    }

    private LivingEntity spawnEntity(CompoundNBT compound) {
        double z;
        double y;
        if (compound == null || !compound.func_74764_b("id")) {
            return null;
        }
        double x = this.npc.func_226277_ct_() + (double)this.xOffset - 0.5 + (double)this.npc.func_70681_au().nextFloat();
        Entity entity = SPacketToolMobSpawner.spawnClone(compound, x, y = this.npc.func_226278_cu_() + (double)this.yOffset, z = this.npc.func_226281_cx_() + (double)this.zOffset - 0.5 + (double)this.npc.func_70681_au().nextFloat(), this.npc.field_70170_p);
        if (entity == null || !(entity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity living = (LivingEntity)entity;
        living.getPersistentData().func_74778_a("NpcSpawnerId", this.id);
        living.getPersistentData().func_74768_a("NpcSpawnerNr", this.number);
        this.setTarget(living, this.npc.func_70638_az());
        living.func_70107_b(x, y, z);
        if (living instanceof EntityNPCInterface) {
            EntityNPCInterface snpc = (EntityNPCInterface)living;
            snpc.stats.spawnCycle = 4;
            snpc.stats.respawnTime = 0;
            snpc.ais.returnToStart = false;
        }
        this.spawned.add(living);
        return living;
    }

    private CompoundNBT getCompound(int i) {
        for (Map.Entry<Integer, SpawnerData> entry : this.data.entrySet()) {
            CompoundNBT compound;
            if (i > entry.getKey() || (compound = entry.getValue().getCompound()) == null || !compound.func_74764_b("id")) continue;
            this.number = entry.getKey() + 1;
            return compound;
        }
        return null;
    }

    private List<LivingEntity> getNearbySpawned() {
        ArrayList<LivingEntity> spawnList = new ArrayList<LivingEntity>();
        List list = this.npc.field_70170_p.func_217357_a(LivingEntity.class, this.npc.func_174813_aQ().func_72314_b(40.0, 40.0, 40.0));
        for (LivingEntity entity : list) {
            if (!entity.getPersistentData().func_74779_i("NpcSpawnerId").equals(this.id) || entity.field_70128_L) continue;
            spawnList.add(entity);
        }
        return spawnList;
    }

    public boolean isOnCooldown(String name) {
        if (!this.cooldown.containsKey(name)) {
            return false;
        }
        long time = this.cooldown.get(name);
        return System.currentTimeMillis() < time + 1200000L;
    }

    @Override
    public IEntityLiving spawnEntity(int i) {
        CompoundNBT compound = this.getCompound(i);
        if (compound == null) {
            return null;
        }
        LivingEntity base = this.spawnEntity(compound);
        if (base == null) {
            return null;
        }
        return (IEntityLiving)NpcAPI.Instance().getIEntity((Entity)base);
    }

    @Override
    public void removeAllSpawned() {
        for (LivingEntity entity : this.spawned) {
            entity.field_70128_L = true;
        }
        this.spawned = new ArrayList<LivingEntity>();
    }

    @Override
    public int getType() {
        return 6;
    }

    class SpawnerData {
        public int tab;
        public String name;
        private long lastLoaded;
        private CompoundNBT compound;

        public SpawnerData(int tab, String name) {
            this.name = name;
            this.tab = tab;
        }

        public CompoundNBT getCompound() {
            if (this.lastLoaded < ServerCloneController.Instance.lastLoaded) {
                this.compound = ServerCloneController.Instance.getCloneData(null, this.name, this.tab);
                this.lastLoaded = ServerCloneController.Instance.lastLoaded;
            }
            return this.compound;
        }
    }
}

