/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.BowItem;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.constants.EnumCompanionJobs;
import noppes.npcs.constants.EnumCompanionStage;
import noppes.npcs.constants.EnumCompanionTalent;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleInterface;
import noppes.npcs.roles.companion.CompanionFarmer;
import noppes.npcs.roles.companion.CompanionFoodStats;
import noppes.npcs.roles.companion.CompanionGuard;
import noppes.npcs.roles.companion.CompanionJobInterface;
import noppes.npcs.roles.companion.CompanionTrader;

public class RoleCompanion
extends RoleInterface {
    private static final CompanionJobInterface NONE = new CompanionJobInterface(){

        @Override
        public CompoundNBT getNBT() {
            return null;
        }

        @Override
        public void setNBT(CompoundNBT compound) {
        }

        @Override
        public EnumCompanionJobs getType() {
            return EnumCompanionJobs.NONE;
        }
    };
    public NpcMiscInventory inventory;
    public String uuid = "";
    public String ownerName = "";
    public Map<EnumCompanionTalent, Integer> talents = new TreeMap<EnumCompanionTalent, Integer>();
    public boolean canAge = true;
    public long ticksActive = 0L;
    public EnumCompanionStage stage = EnumCompanionStage.FULLGROWN;
    public PlayerEntity owner = null;
    public int companionID;
    public CompanionJobInterface companionJobInterface = NONE;
    public boolean hasInv = true;
    public boolean defendOwner = true;
    public CompanionFoodStats foodstats = new CompanionFoodStats();
    private int eatingTicks = 20;
    private IItemStack eating = null;
    private int eatingDelay = 0;
    public int currentExp = 0;

    public RoleCompanion(EntityNPCInterface npc) {
        super(npc);
        this.inventory = new NpcMiscInventory(12);
    }

    @Override
    public boolean aiShouldExecute() {
        PlayerEntity prev = this.owner;
        this.owner = this.getOwner();
        if (this.companionJobInterface.isSelfSufficient()) {
            return true;
        }
        if (this.owner == null && !this.uuid.isEmpty()) {
            this.npc.field_70128_L = true;
        } else if (prev != this.owner && this.owner != null) {
            this.ownerName = this.owner.func_145748_c_().getString();
            PlayerData data = PlayerData.get(this.owner);
            if (data.companionID != this.companionID) {
                this.npc.field_70128_L = true;
            }
        }
        return this.owner != null;
    }

    @Override
    public void aiUpdateTask() {
        if (this.owner != null && !this.companionJobInterface.isSelfSufficient()) {
            this.foodstats.onUpdate(this.npc);
        }
        if (this.foodstats.getFoodLevel() >= 18) {
            this.npc.stats.healthRegen = 0;
            this.npc.stats.combatRegen = 0;
        }
        if (this.foodstats.needFood() && this.isSitting()) {
            if (this.eatingDelay > 0) {
                --this.eatingDelay;
                return;
            }
            IItemStack prev = this.eating;
            this.eating = this.getFood();
            if (prev != null && this.eating == null) {
                this.npc.setRoleData("");
            }
            if (prev == null && this.eating != null) {
                this.npc.setRoleData("eating");
                this.eatingTicks = 20;
            }
            if (this.isEating()) {
                this.doEating();
            }
        } else if (this.eating != null && !this.isSitting()) {
            this.eating = null;
            this.eatingDelay = 20;
            this.npc.setRoleData("");
        }
        ++this.ticksActive;
        if (this.canAge && this.stage != EnumCompanionStage.FULLGROWN) {
            if (this.stage == EnumCompanionStage.BABY && this.ticksActive > (long)EnumCompanionStage.CHILD.matureAge) {
                this.matureTo(EnumCompanionStage.CHILD);
            } else if (this.stage == EnumCompanionStage.CHILD && this.ticksActive > (long)EnumCompanionStage.TEEN.matureAge) {
                this.matureTo(EnumCompanionStage.TEEN);
            } else if (this.stage == EnumCompanionStage.TEEN && this.ticksActive > (long)EnumCompanionStage.ADULT.matureAge) {
                this.matureTo(EnumCompanionStage.ADULT);
            } else if (this.stage == EnumCompanionStage.ADULT && this.ticksActive > (long)EnumCompanionStage.FULLGROWN.matureAge) {
                this.matureTo(EnumCompanionStage.FULLGROWN);
            }
        }
    }

    @Override
    public void clientUpdate() {
        if (this.npc.getRoleData().equals("eating")) {
            this.eating = this.getFood();
            if (this.isEating()) {
                this.doEating();
            }
        } else if (this.eating != null) {
            this.eating = null;
        }
    }

    private void doEating() {
        if (this.eating == null || this.eating.isEmpty()) {
            return;
        }
        ItemStack eating = this.eating.getMCItemStack();
        if (this.npc.field_70170_p.field_72995_K) {
            Random rand = this.npc.func_70681_au();
            for (int j = 0; j < 2; ++j) {
                Vector3d vec3 = new Vector3d(((double)rand.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                vec3.func_178789_a(-this.npc.field_70125_A * (float)Math.PI / 180.0f);
                vec3.func_178785_b(-this.npc.field_70761_aq * (float)Math.PI / 180.0f);
                Vector3d vec31 = new Vector3d(((double)rand.nextFloat() - 0.5) * 0.3, (double)(-rand.nextFloat()) * 0.6 - 0.3, (double)(this.npc.func_213311_cf() / 2.0f) + 0.1);
                vec31.func_178789_a(-this.npc.field_70125_A * (float)Math.PI / 180.0f);
                vec31.func_178785_b(-this.npc.field_70761_aq * (float)Math.PI / 180.0f);
                vec31 = vec31.func_72441_c(this.npc.func_226277_ct_(), this.npc.func_226278_cu_() + (double)this.npc.func_213302_cg() + 0.1, this.npc.func_226281_cx_());
                String s = "iconcrack_" + Item.func_150891_b((Item)eating.func_77973_b());
                this.npc.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, eating), vec31.field_72450_a, vec31.field_72448_b, vec31.field_72449_c, vec3.field_72450_a, vec3.field_72448_b + 0.05, vec3.field_72449_c);
            }
        } else {
            --this.eatingTicks;
            if (this.eatingTicks <= 0) {
                if (this.inventory.removeItem(eating, 1)) {
                    Food food = eating.func_77973_b().func_219967_s();
                    this.foodstats.onFoodEaten(food, eating);
                    this.npc.func_184185_a(SoundEvents.field_187739_dZ, 0.5f, this.npc.func_70681_au().nextFloat() * 0.1f + 0.9f);
                }
                this.eatingDelay = 20;
                this.npc.setRoleData("");
                eating = null;
            } else if (this.eatingTicks > 3 && this.eatingTicks % 2 == 0) {
                Random rand = this.npc.func_70681_au();
                this.npc.func_184185_a(SoundEvents.field_187537_bA, 0.5f + 0.5f * (float)rand.nextInt(2), (rand.nextFloat() - rand.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    public void matureTo(EnumCompanionStage stage) {
        this.stage = stage;
        EntityCustomNpc npc = (EntityCustomNpc)this.npc;
        npc.ais.animationType = stage.animation;
        if (stage == EnumCompanionStage.BABY) {
            npc.modelData.getPartConfig(EnumParts.ARM_LEFT).setScale(0.5f, 0.5f, 0.5f);
            npc.modelData.getPartConfig(EnumParts.LEG_LEFT).setScale(0.5f, 0.5f, 0.5f);
            npc.modelData.getPartConfig(EnumParts.BODY).setScale(0.5f, 0.5f, 0.5f);
            npc.modelData.getPartConfig(EnumParts.HEAD).setScale(0.7f, 0.7f, 0.7f);
            npc.ais.onAttack = 1;
            npc.ais.setWalkingSpeed(3);
            if (!this.talents.containsKey((Object)EnumCompanionTalent.INVENTORY)) {
                this.talents.put(EnumCompanionTalent.INVENTORY, 0);
            }
        }
        if (stage == EnumCompanionStage.CHILD) {
            npc.modelData.getPartConfig(EnumParts.ARM_LEFT).setScale(0.6f, 0.6f, 0.6f);
            npc.modelData.getPartConfig(EnumParts.LEG_LEFT).setScale(0.6f, 0.6f, 0.6f);
            npc.modelData.getPartConfig(EnumParts.BODY).setScale(0.6f, 0.6f, 0.6f);
            npc.modelData.getPartConfig(EnumParts.HEAD).setScale(0.8f, 0.8f, 0.8f);
            npc.ais.onAttack = 0;
            npc.ais.setWalkingSpeed(4);
            if (!this.talents.containsKey((Object)EnumCompanionTalent.SWORD)) {
                this.talents.put(EnumCompanionTalent.SWORD, 0);
            }
        }
        if (stage == EnumCompanionStage.TEEN) {
            npc.modelData.getPartConfig(EnumParts.ARM_LEFT).setScale(0.8f, 0.8f, 0.8f);
            npc.modelData.getPartConfig(EnumParts.LEG_LEFT).setScale(0.8f, 0.8f, 0.8f);
            npc.modelData.getPartConfig(EnumParts.BODY).setScale(0.8f, 0.8f, 0.8f);
            npc.modelData.getPartConfig(EnumParts.HEAD).setScale(0.9f, 0.9f, 0.9f);
            npc.ais.onAttack = 0;
            npc.ais.setWalkingSpeed(5);
            if (!this.talents.containsKey((Object)EnumCompanionTalent.ARMOR)) {
                this.talents.put(EnumCompanionTalent.ARMOR, 0);
            }
        }
        if (stage == EnumCompanionStage.ADULT || stage == EnumCompanionStage.FULLGROWN) {
            npc.modelData.getPartConfig(EnumParts.ARM_LEFT).setScale(1.0f, 1.0f, 1.0f);
            npc.modelData.getPartConfig(EnumParts.LEG_LEFT).setScale(1.0f, 1.0f, 1.0f);
            npc.modelData.getPartConfig(EnumParts.BODY).setScale(1.0f, 1.0f, 1.0f);
            npc.modelData.getPartConfig(EnumParts.HEAD).setScale(1.0f, 1.0f, 1.0f);
            npc.ais.onAttack = 0;
            npc.ais.setWalkingSpeed(5);
        }
    }

    @Override
    public CompoundNBT save(CompoundNBT compound) {
        compound.func_218657_a("CompanionInventory", (INBT)this.inventory.getToNBT());
        compound.func_74778_a("CompanionOwner", this.uuid);
        compound.func_74778_a("CompanionOwnerName", this.ownerName);
        compound.func_74768_a("CompanionID", this.companionID);
        compound.func_74768_a("CompanionStage", this.stage.ordinal());
        compound.func_74768_a("CompanionExp", this.currentExp);
        compound.func_74757_a("CompanionCanAge", this.canAge);
        compound.func_74772_a("CompanionAge", this.ticksActive);
        compound.func_74757_a("CompanionHasInv", this.hasInv);
        compound.func_74757_a("CompanionDefendOwner", this.defendOwner);
        this.foodstats.writeNBT(compound);
        compound.func_74768_a("CompanionJob", this.companionJobInterface.getType().ordinal());
        if (this.companionJobInterface.getType() != EnumCompanionJobs.NONE) {
            compound.func_218657_a("CompanionJobData", (INBT)this.companionJobInterface.getNBT());
        }
        ListNBT list = new ListNBT();
        for (EnumCompanionTalent talent : this.talents.keySet()) {
            CompoundNBT c = new CompoundNBT();
            c.func_74768_a("Talent", talent.ordinal());
            c.func_74768_a("Exp", this.talents.get((Object)talent).intValue());
            list.add((Object)c);
        }
        compound.func_218657_a("CompanionTalents", (INBT)list);
        return compound;
    }

    @Override
    public void load(CompoundNBT compound) {
        this.inventory.setFromNBT(compound.func_74775_l("CompanionInventory"));
        this.uuid = compound.func_74779_i("CompanionOwner");
        this.ownerName = compound.func_74779_i("CompanionOwnerName");
        this.companionID = compound.func_74762_e("CompanionID");
        this.stage = EnumCompanionStage.values()[compound.func_74762_e("CompanionStage")];
        this.currentExp = compound.func_74762_e("CompanionExp");
        this.canAge = compound.func_74767_n("CompanionCanAge");
        this.ticksActive = compound.func_74763_f("CompanionAge");
        this.hasInv = compound.func_74767_n("CompanionHasInv");
        this.defendOwner = compound.func_74767_n("CompanionDefendOwner");
        this.foodstats.readNBT(compound);
        ListNBT list = compound.func_150295_c("CompanionTalents", 10);
        TreeMap<EnumCompanionTalent, Integer> talents = new TreeMap<EnumCompanionTalent, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT c = list.func_150305_b(i);
            EnumCompanionTalent talent = EnumCompanionTalent.values()[c.func_74762_e("Talent")];
            talents.put(talent, c.func_74762_e("Exp"));
        }
        this.talents = talents;
        this.setJob(compound.func_74762_e("CompanionJob"));
        this.companionJobInterface.setNBT(compound.func_74775_l("CompanionJobData"));
        this.setStats();
    }

    private void setJob(int i) {
        EnumCompanionJobs companionJob = EnumCompanionJobs.values()[i];
        this.companionJobInterface = companionJob == EnumCompanionJobs.SHOP ? new CompanionTrader() : (companionJob == EnumCompanionJobs.FARMER ? new CompanionFarmer() : (companionJob == EnumCompanionJobs.GUARD ? new CompanionGuard() : NONE));
        this.companionJobInterface.npc = this.npc;
    }

    @Override
    public void interact(PlayerEntity player) {
        this.interact(player, false);
    }

    public void interact(PlayerEntity player, boolean openGui) {
        if (player != null && this.companionJobInterface.getType() == EnumCompanionJobs.SHOP) {
            ((CompanionTrader)this.companionJobInterface).interact(player);
        }
        if (player != this.owner || !this.npc.func_70089_S() || this.npc.isAttacking()) {
            return;
        }
        if (player.func_213453_ef() || openGui) {
            this.openGui(player);
        } else {
            this.setSitting(!this.isSitting());
        }
    }

    public int getTotalLevel() {
        int level = 0;
        for (EnumCompanionTalent talent : this.talents.keySet()) {
            level += this.getTalentLevel(talent);
        }
        return level;
    }

    public int getMaxExp() {
        return 500 + this.getTotalLevel() * 200;
    }

    public void addExp(int exp) {
        if (this.canAddExp(exp)) {
            this.currentExp += exp;
        }
    }

    public boolean canAddExp(int exp) {
        int newExp = this.currentExp + exp;
        return newExp >= 0 && newExp < this.getMaxExp();
    }

    public void gainExp(int chance) {
        if (this.npc.func_70681_au().nextInt(chance) == 0) {
            this.addExp(1);
        }
    }

    private void openGui(PlayerEntity player) {
        NoppesUtilServer.sendOpenGui(player, EnumGuiType.Companion, this.npc);
    }

    public PlayerEntity getOwner() {
        if (this.uuid == null || this.uuid.isEmpty()) {
            return null;
        }
        try {
            UUID id = UUID.fromString(this.uuid);
            if (id != null) {
                return NoppesUtilServer.getPlayer(this.npc.func_184102_h(), id);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public void setOwner(PlayerEntity player) {
        this.uuid = player.func_110124_au().toString();
    }

    public boolean hasTalent(EnumCompanionTalent talent) {
        return this.getTalentLevel(talent) > 0;
    }

    public int getTalentLevel(EnumCompanionTalent talent) {
        if (!this.talents.containsKey((Object)talent)) {
            return 0;
        }
        int exp = this.talents.get((Object)talent);
        if (exp >= 5000) {
            return 5;
        }
        if (exp >= 3000) {
            return 4;
        }
        if (exp >= 1700) {
            return 3;
        }
        if (exp >= 1000) {
            return 2;
        }
        if (exp >= 400) {
            return 1;
        }
        return 0;
    }

    public Integer getNextLevel(EnumCompanionTalent talent) {
        if (!this.talents.containsKey((Object)talent)) {
            return 0;
        }
        int exp = this.talents.get((Object)talent);
        if (exp < 400) {
            return 400;
        }
        if (exp < 1000) {
            return 700;
        }
        if (exp < 1700) {
            return 1700;
        }
        if (exp < 3000) {
            return 3000;
        }
        return 5000;
    }

    public void levelSword() {
        if (!this.talents.containsKey((Object)EnumCompanionTalent.SWORD)) {
            return;
        }
    }

    public void levelTalent(EnumCompanionTalent talent, int exp) {
        if (!this.talents.containsKey((Object)EnumCompanionTalent.SWORD)) {
            return;
        }
        this.talents.put(talent, exp + this.talents.get((Object)talent));
    }

    public int getExp(EnumCompanionTalent talent) {
        if (this.talents.containsKey((Object)talent)) {
            return this.talents.get((Object)talent);
        }
        return -1;
    }

    public void setExp(EnumCompanionTalent talent, int exp) {
        this.talents.put(talent, exp);
    }

    private boolean isWeapon(ItemStack item) {
        if (item == null || item.func_77973_b() == null) {
            return false;
        }
        return item.func_77973_b() instanceof SwordItem || item.func_77973_b() instanceof BowItem || item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150347_e);
    }

    public boolean canWearWeapon(IItemStack stack) {
        if (stack == null || stack.getMCItemStack().func_77973_b() == null) {
            return false;
        }
        Item item = stack.getMCItemStack().func_77973_b();
        if (item instanceof SwordItem) {
            return this.canWearSword(stack);
        }
        if (item instanceof BowItem) {
            return this.getTalentLevel(EnumCompanionTalent.RANGED) > 2;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150347_e)) {
            return this.getTalentLevel(EnumCompanionTalent.RANGED) > 1;
        }
        return false;
    }

    public boolean canWearArmor(ItemStack item) {
        int level = this.getTalentLevel(EnumCompanionTalent.ARMOR);
        if (item == null || !(item.func_77973_b() instanceof ArmorItem) || level <= 0) {
            return false;
        }
        if (level >= 5) {
            return true;
        }
        ArmorItem armor = (ArmorItem)item.func_77973_b();
        int reduction = 1;
        if (armor.func_200880_d() instanceof ArmorMaterial) {
            reduction = ((ArmorMaterial)armor.func_200880_d()).field_78048_f;
        }
        if (reduction <= 5 && level >= 1) {
            return true;
        }
        if (reduction <= 7 && level >= 2) {
            return true;
        }
        if (reduction <= 15 && level >= 3) {
            return true;
        }
        return reduction <= 33 && level >= 4;
    }

    public boolean canWearSword(IItemStack item) {
        int level = this.getTalentLevel(EnumCompanionTalent.SWORD);
        if (item == null || !(item.getMCItemStack().func_77973_b() instanceof SwordItem) || level <= 0) {
            return false;
        }
        if (level >= 5) {
            return true;
        }
        return this.getSwordDamage(item) - (double)level < 4.0;
    }

    private double getSwordDamage(IItemStack item) {
        if (item == null || !(item.getMCItemStack().func_77973_b() instanceof SwordItem)) {
            return 0.0;
        }
        HashMultimap map = (HashMultimap)item.getMCItemStack().func_111283_C(EquipmentSlotType.MAINHAND);
        for (Map.Entry entry : map.entries()) {
            if (!entry.getKey().equals(Attributes.field_233823_f_.func_233754_c_())) continue;
            AttributeModifier mod = (AttributeModifier)entry.getValue();
            return mod.func_111164_d();
        }
        return 0.0;
    }

    public void setStats() {
        IItemStack weapon = this.npc.inventory.getRightHand();
        this.npc.stats.melee.setStrength((int)(1.0 + this.getSwordDamage(weapon)));
        this.npc.stats.healthRegen = 0;
        this.npc.stats.combatRegen = 0;
        int ranged = this.getTalentLevel(EnumCompanionTalent.RANGED);
        if (ranged > 0 && weapon != null) {
            Item item = weapon.getMCItemStack().func_77973_b();
            if (ranged > 0 && item == Item.func_150898_a((Block)Blocks.field_150347_e)) {
                this.npc.inventory.setProjectile(weapon);
            }
            if (ranged > 0 && item instanceof BowItem) {
                this.npc.inventory.setProjectile(NpcAPI.Instance().getIItemStack(new ItemStack((IItemProvider)Items.field_151032_g)));
            }
        }
        this.inventory.setSize(2 + this.getTalentLevel(EnumCompanionTalent.INVENTORY) * 2);
    }

    public void setSelfsuficient(boolean bo) {
        if (this.owner == null || bo == this.companionJobInterface.isSelfSufficient()) {
            return;
        }
        PlayerData data = PlayerData.get(this.owner);
        if (!bo && data.hasCompanion()) {
            return;
        }
        data.setCompanion(bo ? null : this.npc);
        if (this.companionJobInterface.getType() == EnumCompanionJobs.GUARD) {
            ((CompanionGuard)this.companionJobInterface).isStanding = bo;
        } else if (this.companionJobInterface.getType() == EnumCompanionJobs.FARMER) {
            ((CompanionFarmer)this.companionJobInterface).isStanding = bo;
        }
    }

    public void setSitting(boolean sit) {
        if (sit) {
            this.npc.ais.animationType = 1;
            this.npc.ais.onAttack = 3;
            this.npc.ais.setStartPos(this.npc.func_233580_cy_());
            this.npc.func_70661_as().func_75499_g();
            this.npc.func_70634_a(this.npc.getStartXPos(), this.npc.func_226278_cu_(), this.npc.getStartZPos());
        } else {
            this.npc.ais.animationType = this.stage.animation;
            this.npc.ais.onAttack = 0;
        }
        this.npc.updateAI = true;
    }

    public boolean isSitting() {
        return this.npc.ais.animationType == 1;
    }

    public float getDamageAfterArmorAbsorb(DamageSource source, float damage) {
        if (!this.hasInv || this.getTalentLevel(EnumCompanionTalent.ARMOR) <= 0) {
            return damage;
        }
        if (!source.func_76363_c()) {
            this.damageArmor(damage);
            int i = 25 - this.getTotalArmorValue();
            float f1 = damage * (float)i;
            damage = f1 / 25.0f;
        }
        return damage;
    }

    private void damageArmor(float damage) {
        if ((damage /= 4.0f) < 1.0f) {
            damage = 1.0f;
        }
        boolean hasArmor = false;
        Iterator<Map.Entry<Integer, IItemStack>> ita = this.npc.inventory.armor.entrySet().iterator();
        while (ita.hasNext()) {
            Map.Entry<Integer, IItemStack> entry = ita.next();
            IItemStack item = entry.getValue();
            if (item == null || !(item.getMCItemStack().func_77973_b() instanceof ArmorItem)) continue;
            hasArmor = true;
            item.getMCItemStack().func_222118_a((int)damage, (LivingEntity)this.npc, entity -> entity.func_213361_c(EquipmentSlotType.func_220318_a((EquipmentSlotType.Group)EquipmentSlotType.Group.ARMOR, (int)((Integer)entry.getKey()))));
            if (item.getStackSize() > 0) continue;
            ita.remove();
        }
        this.gainExp(hasArmor ? 4 : 8);
    }

    public int getTotalArmorValue() {
        int armorValue = 0;
        for (IItemStack armor : this.npc.inventory.armor.values()) {
            if (armor == null || !(armor.getMCItemStack().func_77973_b() instanceof ArmorItem)) continue;
            armorValue += ((ArmorItem)armor.getMCItemStack().func_77973_b()).func_200881_e();
        }
        return armorValue;
    }

    @Override
    public boolean isFollowing() {
        if (this.companionJobInterface.isSelfSufficient()) {
            return false;
        }
        return this.owner != null && !this.isSitting();
    }

    @Override
    public boolean defendOwner() {
        return this.defendOwner && this.owner != null && this.stage != EnumCompanionStage.BABY && !this.companionJobInterface.isSelfSufficient();
    }

    public boolean hasOwner() {
        return !this.uuid.isEmpty();
    }

    public void addMovementStat(double x, double y, double z) {
        int i = Math.round(MathHelper.func_76133_a((double)(x * x + y * y + z * z)) * 100.0f);
        if (this.npc.isAttacking()) {
            this.foodstats.addExhaustion(0.04f * (float)i * 0.01f);
        } else {
            this.foodstats.addExhaustion(0.02f * (float)i * 0.01f);
        }
    }

    private IItemStack getFood() {
        ArrayList<ItemStack> food = new ArrayList<ItemStack>((Collection<ItemStack>)this.inventory.items);
        Iterator ite = food.iterator();
        int i = -1;
        while (ite.hasNext()) {
            ItemStack is = (ItemStack)ite.next();
            if (is.func_190926_b() || is.func_77973_b().func_219967_s() == null) {
                ite.remove();
                continue;
            }
            int amount = is.func_77952_i();
            if (i != -1 && amount >= i) continue;
            i = amount;
        }
        for (ItemStack is : food) {
            if (is.func_77952_i() != i) continue;
            return NpcAPI.Instance().getIItemStack(is);
        }
        return null;
    }

    public IItemStack getItemInHand() {
        if (this.eating != null && !this.eating.isEmpty()) {
            return this.eating;
        }
        return this.npc.inventory.getRightHand();
    }

    public boolean isEating() {
        return this.eating != null && !this.eating.isEmpty();
    }

    public boolean hasInv() {
        if (!this.hasInv) {
            return false;
        }
        return this.hasTalent(EnumCompanionTalent.INVENTORY) || this.hasTalent(EnumCompanionTalent.ARMOR) || this.hasTalent(EnumCompanionTalent.SWORD);
    }

    public void attackedEntity(Entity entity) {
        IItemStack weapon = this.npc.inventory.getRightHand();
        this.gainExp(weapon == null ? 8 : 4);
        if (weapon == null) {
            return;
        }
        weapon.getMCItemStack().func_222118_a(1, (LivingEntity)this.npc, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        if (weapon.getMCItemStack().func_190916_E() <= 0) {
            this.npc.inventory.setRightHand(null);
        }
    }

    public void addTalentExp(EnumCompanionTalent talent, int exp) {
        if (this.talents.containsKey((Object)talent)) {
            exp += this.talents.get((Object)talent).intValue();
        }
        this.talents.put(talent, exp);
    }

    @Override
    public int getType() {
        return 6;
    }
}

