/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconProperties;
import dev.ftb.mods.ftblibrary.icon.MutableColor4I;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BulletIcon
extends Icon {
    private static final MutableColor4I DEFAULT_COLOR = Color4I.rgb(0xEDEDED).mutable();
    private static final MutableColor4I DEFAULT_COLOR_B = Color4I.rgb(0xFFFFFF).mutable();
    private static final MutableColor4I DEFAULT_COLOR_D = Color4I.rgb(0xDDDDDD).mutable();
    private Color4I color = Icon.EMPTY;
    private Color4I colorB = Icon.EMPTY;
    private Color4I colorD = Icon.EMPTY;
    private boolean inverse = false;

    @Override
    public BulletIcon copy() {
        BulletIcon icon = new BulletIcon();
        icon.color = this.color;
        icon.colorB = this.colorB;
        icon.colorD = this.colorD;
        icon.inverse = this.inverse;
        return icon;
    }

    public BulletIcon setColor(Color4I col) {
        this.color = col;
        if (this.color.isEmpty()) {
            return this;
        }
        MutableColor4I c = this.color.mutable();
        c.addBrightness(18);
        this.colorB = c.copy();
        c = this.color.mutable();
        c.addBrightness(-18);
        this.colorD = c.copy();
        return this;
    }

    @Override
    public BulletIcon withColor(Color4I col) {
        return this.copy().setColor(col);
    }

    @Override
    public BulletIcon withTint(Color4I c) {
        return this.withColor(this.color.withTint(c));
    }

    public BulletIcon setInverse(boolean v) {
        this.inverse = v;
        return this;
    }

    @Override
    protected void setProperties(IconProperties properties) {
        super.setProperties(properties);
        this.inverse = properties.getBoolean("inverse", this.inverse);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack matrixStack, int x, int y, int w, int h) {
        Color4I cd;
        Color4I cb;
        Color4I c;
        if (this.color.isEmpty()) {
            c = DEFAULT_COLOR;
            cb = DEFAULT_COLOR_B;
            cd = DEFAULT_COLOR_D;
        } else {
            c = this.color;
            cb = this.colorB;
            cd = this.colorD;
        }
        RenderSystem.disableTexture();
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder buffer = tesselator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y + 1, 1, h - 2, this.inverse ? cd : cb);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + w - 1, y + 1, 1, h - 2, this.inverse ? cb : cd);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + 1, y, w - 2, 1, this.inverse ? cd : cb);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + 1, y + h - 1, w - 2, 1, this.inverse ? cb : cd);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + 1, y + 1, w - 2, h - 2, c);
        tesselator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.addProperty("id", "bullet");
        if (!this.color.isEmpty()) {
            o.add("color", this.color.getJson());
        }
        return o;
    }
}

