/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui.misc;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.ITextComponent;

public class LoadingScreen
extends BaseScreen {
    private boolean startedLoading = false;
    private boolean isLoading = true;
    private ITextComponent[] title;
    public float timer;

    public LoadingScreen() {
        this.setSize(128, 128);
        this.title = new ITextComponent[0];
    }

    public LoadingScreen(ITextComponent t) {
        this.setSize(128, 128);
        this.title = new ITextComponent[]{t};
    }

    @Override
    public void addWidgets() {
    }

    @Override
    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        if (!this.startedLoading) {
            this.startLoading();
            this.startedLoading = true;
        }
        if (this.isLoading()) {
            GuiHelper.drawHollowRect(matrixStack, x + this.width / 2 - 48, y + this.height / 2 - 8, 96, 16, Color4I.WHITE, true);
            int x1 = x + this.width / 2 - 48;
            int y1 = y + this.height / 2 - 8;
            int w1 = 96;
            int h1 = 16;
            Color4I col = Color4I.WHITE;
            GlStateManager.func_227621_I_();
            Tessellator tesselator = Tessellator.func_178181_a();
            BufferBuilder buffer = tesselator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            GuiHelper.addRectToBuffer(matrixStack, buffer, x1, y1 + 1, 1, h1 - 2, col);
            GuiHelper.addRectToBuffer(matrixStack, buffer, x1 + w1 - 1, y1 + 1, 1, h1 - 2, col);
            GuiHelper.addRectToBuffer(matrixStack, buffer, x1 + 1, y1, w1 - 2, 1, col);
            GuiHelper.addRectToBuffer(matrixStack, buffer, x1 + 1, y1 + h1 - 1, w1 - 2, 1, col);
            ++x1;
            ++y1;
            w1 -= 2;
            this.timer += Minecraft.func_71410_x().func_193989_ak();
            this.timer %= (float)(h1 -= 2) * 2.0f;
            for (int oy = 0; oy < h1; ++oy) {
                for (int ox = 0; ox < w1; ++ox) {
                    int index = ox + oy + (int)this.timer;
                    if (index % (h1 * 2) >= h1) continue;
                    col = Color4I.WHITE.withAlpha(200 - index % h1 * 9);
                    GuiHelper.addRectToBuffer(matrixStack, buffer, x1 + ox, y1 + oy, 1, 1, col);
                }
            }
            tesselator.func_78381_a();
            GlStateManager.func_227619_H_();
            ITextComponent[] s = this.getText();
            if (s.length > 0) {
                for (int i = 0; i < s.length; ++i) {
                    theme.drawString(matrixStack, s[i], x + this.width / 2, y - 26 + i * 12, 4);
                }
            }
        } else {
            this.closeGui();
            this.finishLoading();
        }
    }

    public synchronized ITextComponent[] getText() {
        return this.title;
    }

    public synchronized void setText(ITextComponent ... s) {
        this.title = s;
    }

    public synchronized void setFinished() {
        this.isLoading = false;
    }

    public void startLoading() {
    }

    public synchronized boolean isLoading() {
        return this.isLoading;
    }

    public void finishLoading() {
    }
}

