/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.inventory.container.Slot;
import net.minecraft.nbt.CompoundNBT;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogicBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IServerUpdater;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class FilterLogicContainerBase<T extends FilterLogicBase, S extends Slot> {
    private static final String DATA_IS_ALLOW_LIST = "isAllowList";
    private static final String DATA_MATCH_DURABILITY = "matchDurability";
    private static final String DATA_MATCH_NBT = "matchNbt";
    private static final String DATA_PRIMARY_MATCH = "primaryMatch";
    protected final List<S> filterSlots = new ArrayList<S>();
    protected final IServerUpdater serverUpdater;
    protected final Supplier<T> filterLogic;

    public FilterLogicContainerBase(IServerUpdater serverUpdater, Supplier<T> filterLogic) {
        this.serverUpdater = serverUpdater;
        this.filterLogic = filterLogic;
    }

    public List<S> getFilterSlots() {
        return this.filterSlots;
    }

    public boolean isAllowList() {
        return ((FilterLogicBase)this.filterLogic.get()).isAllowList();
    }

    public boolean shouldMatchDurability() {
        return ((FilterLogicBase)this.filterLogic.get()).shouldMatchDurability();
    }

    public boolean shouldMatchNbt() {
        return ((FilterLogicBase)this.filterLogic.get()).shouldMatchNbt();
    }

    public PrimaryMatch getPrimaryMatch() {
        return ((FilterLogicBase)this.filterLogic.get()).getPrimaryMatch();
    }

    public void setAllowList(boolean isAllowList) {
        ((FilterLogicBase)this.filterLogic.get()).setAllowList(isAllowList);
        this.serverUpdater.sendBooleanToServer(DATA_IS_ALLOW_LIST, isAllowList);
    }

    public void setMatchDurability(boolean matchDurability) {
        ((FilterLogicBase)this.filterLogic.get()).setMatchDurability(matchDurability);
        this.serverUpdater.sendBooleanToServer(DATA_MATCH_DURABILITY, matchDurability);
    }

    public void setMatchNbt(boolean matchNbt) {
        ((FilterLogicBase)this.filterLogic.get()).setMatchNbt(matchNbt);
        this.serverUpdater.sendBooleanToServer(DATA_MATCH_NBT, matchNbt);
    }

    public void setPrimaryMatch(PrimaryMatch primaryMatch) {
        ((FilterLogicBase)this.filterLogic.get()).setPrimaryMatch(primaryMatch);
        this.serverUpdater.sendDataToServer(() -> NBTHelper.putEnumConstant(new CompoundNBT(), DATA_PRIMARY_MATCH, primaryMatch));
    }

    public boolean handleMessage(CompoundNBT data) {
        Iterator iterator = data.func_150296_c().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "isAllowList": {
                    this.setAllowList(data.func_74767_n(DATA_IS_ALLOW_LIST));
                    return true;
                }
                case "matchDurability": {
                    this.setMatchDurability(data.func_74767_n(DATA_MATCH_DURABILITY));
                    return true;
                }
                case "matchNbt": {
                    this.setMatchNbt(data.func_74767_n(DATA_MATCH_NBT));
                    return true;
                }
                case "primaryMatch": {
                    this.setPrimaryMatch(PrimaryMatch.fromName(data.func_74779_i(DATA_PRIMARY_MATCH)));
                    return true;
                }
            }
        }
        return false;
    }
}

