/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.selene.blocks.IOwnerProtected;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.tiles.MimicBlockTile;
import net.mehvahdjukaar.supplementaries.block.util.ITextHolder;
import net.mehvahdjukaar.supplementaries.block.util.TextHolder;
import net.mehvahdjukaar.supplementaries.datagen.types.IWoodType;
import net.mehvahdjukaar.supplementaries.datagen.types.VanillaWoodTypes;
import net.mehvahdjukaar.supplementaries.datagen.types.WoodTypes;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class SignPostBlockTile
extends MimicBlockTile
implements ITextHolder,
IOwnerProtected {
    private UUID owner = null;
    public boolean framed = false;
    public static final ModelProperty<Boolean> FRAMED = BlockProperties.FRAMED;
    public TextHolder textHolder;
    public float yawUp = 0.0f;
    public float yawDown = 0.0f;
    public boolean leftUp = true;
    public boolean leftDown = false;
    public boolean up = false;
    public boolean down = false;
    public IWoodType woodTypeUp = VanillaWoodTypes.OAK;
    public IWoodType woodTypeDown = VanillaWoodTypes.OAK;

    public SignPostBlockTile() {
        super((TileEntityType)ModRegistry.SIGN_POST_TILE.get());
        this.textHolder = new TextHolder(2);
    }

    @Override
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(FRAMED, (Object)this.framed).withInitial(MIMIC, (Object)this.getHeldBlock()).build();
    }

    @Override
    public TextHolder getTextHolder() {
        return this.textHolder;
    }

    public double func_145833_n() {
        return 96.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177963_a(-0.25, 0.0, -0.25), this.func_174877_v().func_177963_a(1.25, 1.0, 1.25));
    }

    public void pointToward(BlockPos targetPos, boolean up) {
        float yaw = (float)(Math.atan2(targetPos.func_177958_n() - this.field_174879_c.func_177958_n(), targetPos.func_177952_p() - this.field_174879_c.func_177952_p()) * 180.0 / Math.PI);
        if (up) {
            this.yawUp = MathHelper.func_76142_g((float)(yaw - (float)(this.leftUp ? 180 : 0)));
        } else {
            this.yawDown = MathHelper.func_76142_g((float)(yaw - (float)(this.leftDown ? 180 : 0)));
        }
    }

    public float getPointingYaw(boolean up) {
        if (up) {
            return MathHelper.func_76142_g((float)(-this.yawUp - (float)(this.leftUp ? 180 : 0)));
        }
        return MathHelper.func_76142_g((float)(-this.yawDown - (float)(this.leftDown ? 180 : 0)));
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.framed = compound.func_74767_n("Framed");
        this.textHolder.read(compound);
        if (compound.func_74764_b("Fence")) {
            this.mimic = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("Fence"));
        }
        this.yawUp = compound.func_74760_g("YawUp");
        this.yawDown = compound.func_74760_g("YawDown");
        this.leftUp = compound.func_74767_n("LeftUp");
        this.leftDown = compound.func_74767_n("LeftDown");
        this.up = compound.func_74767_n("Up");
        this.down = compound.func_74767_n("Down");
        this.woodTypeUp = WoodTypes.fromNBT(compound.func_74779_i("TypeUp"));
        this.woodTypeDown = WoodTypes.fromNBT(compound.func_74779_i("TypeDown"));
        this.loadOwner(compound);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("Framed", this.framed);
        this.textHolder.write(compound);
        compound.func_74776_a("YawUp", this.yawUp);
        compound.func_74776_a("YawDown", this.yawDown);
        compound.func_74757_a("LeftUp", this.leftUp);
        compound.func_74757_a("LeftDown", this.leftDown);
        compound.func_74757_a("Up", this.up);
        compound.func_74757_a("Down", this.down);
        compound.func_74778_a("TypeUp", this.woodTypeUp.toNBT());
        compound.func_74778_a("TypeDown", this.woodTypeDown.toNBT());
        this.saveOwner(compound);
        return compound;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }
}

