/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.color;

import java.util.Random;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.math.MathHelper;

public class HSLColor {
    public static int getRainbowColorPost(float division) {
        float scale = 3600.0f / division;
        float h = (float)((int)(System.currentTimeMillis() % (long)((int)scale))) / scale;
        float[] hsl = HSLColor.postProcess(new float[]{h, 0.6f, 0.5f});
        return HSLColor.hslToRgb(hsl[0], hsl[1], hsl[2]);
    }

    public static int getRandomBrightColor(Random random) {
        float h = random.nextFloat();
        float[] hsl = HSLColor.postProcess(new float[]{h, 0.62f + random.nextFloat() * 0.3f, 0.43f + random.nextFloat() * 0.15f});
        return HSLColor.hslToRgb(hsl[0], hsl[1], hsl[2]);
    }

    public static int getRainbowColor(float division) {
        float scale = 3600.0f / division;
        float h = (float)((int)(System.currentTimeMillis() % (long)((int)scale))) / scale;
        return HSLColor.hslToRgb(h, 0.6f, 0.5f);
    }

    public static float[] postProcess(float[] hsl) {
        float h = hsl[0];
        float s = hsl[1];
        float l = hsl[2];
        float c = 1.0f - Math.abs(2.0f * l - 1.0f);
        if (s > c) {
            s = c;
        }
        float minLightness = 0.47f;
        l = Math.max(l, minLightness);
        float j = 1.0f - l;
        float scaling = 0.15f;
        float angle = 90.0f;
        float n = (float)((double)scaling * Math.exp((double)(-angle) * Math.pow(h - 0.6666f, 2.0)));
        return new float[]{h, s -= n, l};
    }

    public static int hslToRgb(float h, float s, float l) {
        float r;
        float g;
        float b;
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = HSLColor.hueToRgb(p, q, h + 0.33333334f);
            g = HSLColor.hueToRgb(p, q, h);
            b = HSLColor.hueToRgb(p, q, h - 0.33333334f);
        }
        return ColorHelper.PackedColor.func_233006_a_((int)MathHelper.func_76141_d((float)255.0f), (int)MathHelper.func_76141_d((float)(r * 255.0f)), (int)MathHelper.func_76141_d((float)(g * 255.0f)), (int)MathHelper.func_76141_d((float)(b * 255.0f)));
    }

    public static int to255(float v) {
        return (int)Math.min(255.0f, 256.0f * v);
    }

    public static float hueToRgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }

    public static float[] rgbToHsl(int rgb) {
        int r = ColorHelper.PackedColor.func_233007_b_((int)rgb);
        int g = ColorHelper.PackedColor.func_233008_c_((int)rgb);
        int b = ColorHelper.PackedColor.func_233009_d_((int)rgb);
        return HSLColor.rgbToHsl(r, g, b);
    }

    public static float[] rgbToHsl(int pR, int pG, int pB) {
        float h;
        float s;
        float r = (float)pR / 255.0f;
        float g = (float)pG / 255.0f;
        float b = (float)pB / 255.0f;
        float max = r > g && r > b ? r : Math.max(g, b);
        float min = r < g && r < b ? r : Math.min(g, b);
        float l = (max + min) / 2.0f;
        if (max == min) {
            s = 0.0f;
            h = 0.0f;
        } else {
            float d = max - min;
            float f = s = l > 0.5f ? d / (2.0f - max - min) : d / (max + min);
            h = r > g && r > b ? (g - b) / d + (g < b ? 6.0f : 0.0f) : (g > b ? (b - r) / d + 2.0f : (r - g) / d + 4.0f);
            h /= 6.0f;
        }
        return new float[]{h, s, l};
    }

    public static float[] fromRGB(int rgb) {
        float r = (float)ColorHelper.PackedColor.func_233007_b_((int)rgb) / 255.0f;
        float g = (float)ColorHelper.PackedColor.func_233008_c_((int)rgb) / 255.0f;
        float b = (float)ColorHelper.PackedColor.func_233009_d_((int)rgb) / 255.0f;
        return HSLColor.fromRGB(r, g, b);
    }

    public static float[] fromRGB(float r, float g, float b) {
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        float h = 0.0f;
        if (max == min) {
            h = 0.0f;
        } else if (max == r) {
            h = (60.0f * (g - b) / (max - min) + 360.0f) % 360.0f;
        } else if (max == g) {
            h = 60.0f * (b - r) / (max - min) + 120.0f;
        } else if (max == b) {
            h = 60.0f * (r - g) / (max - min) + 240.0f;
        }
        float l = (max + min) / 2.0f;
        float s = 0.0f;
        s = max == min ? 0.0f : (l <= 0.5f ? (max - min) / (max + min) : (max - min) / (2.0f - max - min));
        return new float[]{h, s * 100.0f, l * 100.0f};
    }

    public static int toRGB(float h, float s, float l) {
        return HSLColor.toRGB(h, s, l, 1.0f);
    }

    public static int toRGB(float h, float s, float l, float alpha) {
        s = MathHelper.func_76131_a((float)s, (float)0.0f, (float)100.0f);
        l = MathHelper.func_76131_a((float)l, (float)0.0f, (float)100.0f);
        h %= 360.0f;
        float q = 0.0f;
        q = (double)l < 0.5 ? l * (1.0f + s) : (l /= 100.0f) + (s /= 100.0f) - s * l;
        float p = 2.0f * l - q;
        float r = Math.max(0.0f, HSLColor.HueToRGB(p, q, (h /= 360.0f) + 0.33333334f));
        float g = Math.max(0.0f, HSLColor.HueToRGB(p, q, h));
        float b = Math.max(0.0f, HSLColor.HueToRGB(p, q, h - 0.33333334f));
        r = Math.min(r, 1.0f);
        g = Math.min(g, 1.0f);
        b = Math.min(b, 1.0f);
        return ColorHelper.PackedColor.func_233006_a_((int)MathHelper.func_76141_d((float)(alpha * 255.0f)), (int)MathHelper.func_76141_d((float)(r * 255.0f)), (int)MathHelper.func_76141_d((float)(g * 255.0f)), (int)MathHelper.func_76141_d((float)(b * 255.0f)));
    }

    private static float HueToRGB(float p, float q, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (6.0f * h < 1.0f) {
            return p + (q - p) * 6.0f * h;
        }
        if (2.0f * h < 1.0f) {
            return q;
        }
        if (3.0f * h < 2.0f) {
            return p + (q - p) * 6.0f * (0.6666667f - h);
        }
        return p;
    }
}

