/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.mehvahdjukaar.supplementaries.block.tiles.GobletBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorldReader;

public class GobletBlockTileRenderer
extends TileEntityRenderer<GobletBlockTile> {
    public GobletBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public static void renderFluid(float h, int color, int luminosity, ResourceLocation texture, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int light, int combinedOverlayIn, boolean shading) {
        matrixStackIn.func_227860_a_();
        float opacity = 1.0f;
        if (luminosity != 0) {
            light = light & 0xF00000 | luminosity << 4;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(texture);
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_239269_g_());
        matrixStackIn.func_227861_a_(0.5, 0.0625, 0.5);
        float w = 0.25f;
        int lu = light & 0xFFFF;
        int lv = light >> 16 & 0xFFFF;
        float atlasscaleU = sprite.func_94212_f() - sprite.func_94209_e();
        float atlasscaleV = sprite.func_94210_h() - sprite.func_94206_g();
        float minu = sprite.func_94209_e();
        float minv = sprite.func_94206_g();
        float maxu = minu + atlasscaleU * w;
        float maxv = minv + atlasscaleV * h;
        float maxv2 = minv + atlasscaleV * w;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float hw = w / 2.0f;
        RendererUtil.addQuadTop(builder, matrixStackIn, -hw, h, hw, hw, h, -hw, minu, minv, maxu, maxv2, r, g, b, opacity, lu, lv, 0.0f, 1.0f, 0.0f);
        matrixStackIn.func_227865_b_();
    }

    public void render(GobletBlockTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.fluidHolder.isEmpty()) {
            GobletBlockTileRenderer.renderFluid(0.4375f, tile.fluidHolder.getTintColor((IWorldReader)tile.func_145831_w(), tile.func_174877_v()), tile.fluidHolder.getFluid().getLuminosity(), tile.fluidHolder.getFluid().getStillTexture(), matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, true);
        }
    }
}

