/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.AbstractRegion;
import com.sk89q.worldedit.regions.FlatRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionIntersection;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.world.World;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class CuboidRegion
extends AbstractRegion
implements FlatRegion {
    private BlockVector3 pos1;
    private BlockVector3 pos2;

    public CuboidRegion(BlockVector3 pos1, BlockVector3 pos2) {
        this(null, pos1, pos2);
    }

    public CuboidRegion(World world, BlockVector3 pos1, BlockVector3 pos2) {
        super(world);
        Preconditions.checkNotNull((Object)pos1);
        Preconditions.checkNotNull((Object)pos2);
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.recalculate();
    }

    public BlockVector3 getPos1() {
        return this.pos1;
    }

    public void setPos1(BlockVector3 pos1) {
        this.pos1 = pos1;
    }

    public BlockVector3 getPos2() {
        return this.pos2;
    }

    public void setPos2(BlockVector3 pos2) {
        this.pos2 = pos2;
    }

    private void recalculate() {
        this.pos1 = this.pos1.clampY(this.getWorldMinY(), this.getWorldMaxY());
        this.pos2 = this.pos2.clampY(this.getWorldMinY(), this.getWorldMaxY());
    }

    public Region getFaces() {
        BlockVector3 min = this.getMinimumPoint();
        BlockVector3 max = this.getMaximumPoint();
        return new RegionIntersection(new CuboidRegion(this.pos1.withX(min.getX()), this.pos2.withX(min.getX())), new CuboidRegion(this.pos1.withX(max.getX()), this.pos2.withX(max.getX())), new CuboidRegion(this.pos1.withZ(min.getZ()), this.pos2.withZ(min.getZ())), new CuboidRegion(this.pos1.withZ(max.getZ()), this.pos2.withZ(max.getZ())), new CuboidRegion(this.pos1.withY(min.getY()), this.pos2.withY(min.getY())), new CuboidRegion(this.pos1.withY(max.getY()), this.pos2.withY(max.getY())));
    }

    public Region getWalls() {
        BlockVector3 min = this.getMinimumPoint();
        BlockVector3 max = this.getMaximumPoint();
        return new RegionIntersection(new CuboidRegion(this.pos1.withX(min.getX()), this.pos2.withX(min.getX())), new CuboidRegion(this.pos1.withX(max.getX()), this.pos2.withX(max.getX())), new CuboidRegion(this.pos1.withZ(min.getZ()), this.pos2.withZ(min.getZ())), new CuboidRegion(this.pos1.withZ(max.getZ()), this.pos2.withZ(max.getZ())));
    }

    @Override
    public BlockVector3 getMinimumPoint() {
        return this.pos1.getMinimum(this.pos2);
    }

    @Override
    public BlockVector3 getMaximumPoint() {
        return this.pos1.getMaximum(this.pos2);
    }

    @Override
    public CuboidRegion getBoundingBox() {
        return this;
    }

    @Override
    public int getMinimumY() {
        return Math.min(this.pos1.getBlockY(), this.pos2.getBlockY());
    }

    @Override
    public int getMaximumY() {
        return Math.max(this.pos1.getBlockY(), this.pos2.getBlockY());
    }

    @Override
    public void expand(BlockVector3 ... changes) {
        Preconditions.checkNotNull((Object)changes);
        for (BlockVector3 change : changes) {
            if (change.getX() > 0) {
                if (Math.max(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                    this.pos1 = this.pos1.add(change.getX(), 0, 0);
                } else {
                    this.pos2 = this.pos2.add(change.getX(), 0, 0);
                }
            } else if (Math.min(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                this.pos1 = this.pos1.add(change.getX(), 0, 0);
            } else {
                this.pos2 = this.pos2.add(change.getX(), 0, 0);
            }
            if (change.getY() > 0) {
                if (Math.max(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                    this.pos1 = this.pos1.add(0, change.getY(), 0);
                } else {
                    this.pos2 = this.pos2.add(0, change.getY(), 0);
                }
            } else if (Math.min(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                this.pos1 = this.pos1.add(0, change.getY(), 0);
            } else {
                this.pos2 = this.pos2.add(0, change.getY(), 0);
            }
            if (change.getZ() > 0) {
                if (Math.max(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                    this.pos1 = this.pos1.add(0, 0, change.getZ());
                    continue;
                }
                this.pos2 = this.pos2.add(0, 0, change.getZ());
                continue;
            }
            if (Math.min(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                this.pos1 = this.pos1.add(0, 0, change.getZ());
                continue;
            }
            this.pos2 = this.pos2.add(0, 0, change.getZ());
        }
        this.recalculate();
    }

    @Override
    public void contract(BlockVector3 ... changes) {
        Preconditions.checkNotNull((Object)changes);
        for (BlockVector3 change : changes) {
            if (change.getX() < 0) {
                if (Math.max(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                    this.pos1 = this.pos1.add(change.getX(), 0, 0);
                } else {
                    this.pos2 = this.pos2.add(change.getX(), 0, 0);
                }
            } else if (Math.min(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                this.pos1 = this.pos1.add(change.getX(), 0, 0);
            } else {
                this.pos2 = this.pos2.add(change.getX(), 0, 0);
            }
            if (change.getY() < 0) {
                if (Math.max(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                    this.pos1 = this.pos1.add(0, change.getY(), 0);
                } else {
                    this.pos2 = this.pos2.add(0, change.getY(), 0);
                }
            } else if (Math.min(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                this.pos1 = this.pos1.add(0, change.getY(), 0);
            } else {
                this.pos2 = this.pos2.add(0, change.getY(), 0);
            }
            if (change.getZ() < 0) {
                if (Math.max(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                    this.pos1 = this.pos1.add(0, 0, change.getZ());
                    continue;
                }
                this.pos2 = this.pos2.add(0, 0, change.getZ());
                continue;
            }
            if (Math.min(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                this.pos1 = this.pos1.add(0, 0, change.getZ());
                continue;
            }
            this.pos2 = this.pos2.add(0, 0, change.getZ());
        }
        this.recalculate();
    }

    @Override
    public void shift(BlockVector3 change) throws RegionOperationException {
        this.pos1 = this.pos1.add(change);
        this.pos2 = this.pos2.add(change);
        this.recalculate();
    }

    @Override
    public Set<BlockVector2> getChunks() {
        HashSet<BlockVector2> chunks = new HashSet<BlockVector2>();
        BlockVector3 min = this.getMinimumPoint();
        BlockVector3 max = this.getMaximumPoint();
        for (int x = min.getBlockX() >> 4; x <= max.getBlockX() >> 4; ++x) {
            for (int z = min.getBlockZ() >> 4; z <= max.getBlockZ() >> 4; ++z) {
                chunks.add(BlockVector2.at(x, z));
            }
        }
        return chunks;
    }

    @Override
    public Set<BlockVector3> getChunkCubes() {
        HashSet<BlockVector3> chunks = new HashSet<BlockVector3>();
        BlockVector3 min = this.getMinimumPoint();
        BlockVector3 max = this.getMaximumPoint();
        for (int x = min.getBlockX() >> 4; x <= max.getBlockX() >> 4; ++x) {
            for (int z = min.getBlockZ() >> 4; z <= max.getBlockZ() >> 4; ++z) {
                for (int y = min.getBlockY() >> 4; y <= max.getBlockY() >> 4; ++y) {
                    chunks.add(BlockVector3.at(x, y, z));
                }
            }
        }
        return chunks;
    }

    @Override
    public boolean contains(BlockVector3 position) {
        BlockVector3 min = this.getMinimumPoint();
        BlockVector3 max = this.getMaximumPoint();
        return position.containedWithin(min, max);
    }

    @Override
    public Iterator<BlockVector3> iterator() {
        return new Iterator<BlockVector3>(){
            private final BlockVector3 min;
            private final BlockVector3 max;
            private int nextX;
            private int nextY;
            private int nextZ;
            {
                this.min = CuboidRegion.this.getMinimumPoint();
                this.max = CuboidRegion.this.getMaximumPoint();
                this.nextX = this.min.getBlockX();
                this.nextY = this.min.getBlockY();
                this.nextZ = this.min.getBlockZ();
            }

            @Override
            public boolean hasNext() {
                return this.nextX != Integer.MIN_VALUE;
            }

            @Override
            public BlockVector3 next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                BlockVector3 answer = BlockVector3.at(this.nextX, this.nextY, this.nextZ);
                if (++this.nextX > this.max.getBlockX()) {
                    this.nextX = this.min.getBlockX();
                    if (++this.nextZ > this.max.getBlockZ()) {
                        this.nextZ = this.min.getBlockZ();
                        if (++this.nextY > this.max.getBlockY()) {
                            this.nextX = Integer.MIN_VALUE;
                        }
                    }
                }
                return answer;
            }
        };
    }

    @Override
    public Iterable<BlockVector2> asFlatRegion() {
        return () -> new Iterator<BlockVector2>(){
            private final BlockVector3 min;
            private final BlockVector3 max;
            private int nextX;
            private int nextZ;
            {
                this.min = CuboidRegion.this.getMinimumPoint();
                this.max = CuboidRegion.this.getMaximumPoint();
                this.nextX = this.min.getBlockX();
                this.nextZ = this.min.getBlockZ();
            }

            @Override
            public boolean hasNext() {
                return this.nextX != Integer.MIN_VALUE;
            }

            @Override
            public BlockVector2 next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                BlockVector2 answer = BlockVector2.at(this.nextX, this.nextZ);
                if (++this.nextX > this.max.getBlockX()) {
                    this.nextX = this.min.getBlockX();
                    if (++this.nextZ > this.max.getBlockZ()) {
                        this.nextX = Integer.MIN_VALUE;
                    }
                }
                return answer;
            }
        };
    }

    public String toString() {
        return this.getMinimumPoint() + " - " + this.getMaximumPoint();
    }

    @Override
    public CuboidRegion clone() {
        return (CuboidRegion)super.clone();
    }

    public static CuboidRegion makeCuboid(Region region) {
        Preconditions.checkNotNull((Object)region);
        return new CuboidRegion(region.getMinimumPoint(), region.getMaximumPoint());
    }

    public static CuboidRegion fromCenter(BlockVector3 origin, int apothem) {
        Preconditions.checkNotNull((Object)origin);
        Preconditions.checkArgument((apothem >= 0 ? 1 : 0) != 0, (Object)"apothem => 0 required");
        BlockVector3 size = BlockVector3.ONE.multiply(apothem);
        return new CuboidRegion(origin.subtract(size), origin.add(size));
    }
}

