/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.block.charger.ChargerTileEntity;
import net.silentchaos512.gear.block.grader.GraderTileEntity;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.AbstractGearPart;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.init.ModTags;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.event.ClientTicks;
import net.silentchaos512.lib.util.TagUtils;
import net.silentchaos512.utils.Color;

public final class TooltipHandler {
    public static final TooltipHandler INSTANCE = new TooltipHandler();
    private static final boolean TRAIT_DISPLAY_CYCLE = false;
    public static final Color MC_DARK_GRAY;
    public static final Color MC_GRAY;

    private TooltipHandler() {
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onTooltip(ItemTooltipEvent event) {
        MaterialInstance material;
        ItemStack stack = event.getItemStack();
        if (TagUtils.containsSafe(ModTags.Items.GRADER_CATALYSTS, (ItemStack)stack)) {
            TooltipHandler.onGraderCatalystTooltip(event);
        }
        if (TagUtils.containsSafe(ModTags.Items.STARLIGHT_CHARGER_CATALYSTS, (ItemStack)stack)) {
            TooltipHandler.onStarlightChargerCatalystTooltip(event);
        }
        if ((material = MaterialInstance.from(stack)) != null) {
            TooltipHandler.onMaterialTooltip(event, stack, material);
            return;
        }
        PartData part = PartData.from(stack);
        if (part != null) {
            TooltipHandler.onPartTooltip(event, stack, part);
            return;
        }
        if (Config.Common.isNerfedItem(stack.func_77973_b())) {
            List toolTip = event.getToolTip();
            toolTip.add(Math.min(1, toolTip.size()), new TranslationTextComponent("misc.silentgear.poorlyMade").func_240699_a_(TextFormatting.RED));
        }
    }

    private static void onGraderCatalystTooltip(ItemTooltipEvent event) {
        int tier = GraderTileEntity.getCatalystTier(event.getItemStack());
        event.getToolTip().add(TextUtil.withColor(TextUtil.misc("graderCatalyst", tier), Color.DARKORANGE));
    }

    private static void onStarlightChargerCatalystTooltip(ItemTooltipEvent event) {
        int tier = ChargerTileEntity.getStarlightChargerCatalystTier(event.getItemStack());
        event.getToolTip().add(TextUtil.withColor(TextUtil.misc("starlightChargerCataylst", tier), Color.REBECCAPURPLE));
    }

    private static void onMaterialTooltip(ItemTooltipEvent event, ItemStack stack, MaterialInstance material) {
        boolean keyHeld = KeyTracker.isDisplayStatsDown();
        if (event.getFlags().func_194127_a()) {
            event.getToolTip().add(new StringTextComponent("Material ID: " + material.getId()).func_240699_a_(TextFormatting.DARK_GRAY));
            event.getToolTip().add(new StringTextComponent("Material data pack: " + material.get().getPackName()).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        if (!((Boolean)Config.Client.showMaterialTooltips.get()).booleanValue()) {
            return;
        }
        if (keyHeld) {
            event.getToolTip().add(TextUtil.withColor(TextUtil.misc("tooltip.material", new Object[0]), Color.GOLD));
        } else {
            event.getToolTip().add(TextUtil.withColor(TextUtil.misc("tooltip.material", new Object[0]), Color.GOLD).func_230529_a_((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)TextUtil.withColor(TextUtil.keyBinding(KeyTracker.DISPLAY_STATS), TextFormatting.GRAY))));
        }
        if (keyHeld) {
            TooltipHandler.getGradeLine(event, material.getGrade());
            TooltipHandler.getMaterialCategoriesLine(material).ifPresent(t -> event.getToolTip().add(t));
            ArrayList<PartType> partTypes = new ArrayList<PartType>(material.getPartTypes());
            if (!partTypes.isEmpty()) {
                int index = KeyTracker.getMaterialCycleIndex(partTypes.size());
                PartType partType = (PartType)partTypes.get(index);
                event.getToolTip().add(TooltipHandler.buildPartTypeHeader(partTypes, partType));
                event.getToolTip().add(TextUtil.withColor(TextUtil.misc("tier", material.getTier(partType)), Color.DEEPSKYBLUE));
                TooltipHandler.getMaterialTraitLines(event, partType, material);
                event.getToolTip().add(new TranslationTextComponent("misc.silentgear.tooltip.stats").func_240699_a_(TextFormatting.GOLD));
                TooltipHandler.getMaterialStatLines(event, partType, material);
            }
        } else {
            if (material.getGrade() != MaterialGrade.NONE) {
                TooltipHandler.getGradeLine(event, material.getGrade());
            }
            if (event.getFlags().func_194127_a()) {
                TooltipHandler.addJeiSearchTerms(event, material);
            }
        }
    }

    private static void addJeiSearchTerms(ItemTooltipEvent event, MaterialInstance material) {
        StringBuilder b = new StringBuilder();
        for (IMaterialCategory category : material.getCategories()) {
            b.append(category.getName()).append(" ");
        }
        HashSet<String> traits = new HashSet<String>();
        for (PartType partType : material.getPartTypes()) {
            b.append(partType.getDisplayName(0).getString()).append(" ");
            for (TraitInstance trait : material.getTraits(partType)) {
                traits.add(trait.getTrait().getDisplayName(0).getString());
            }
        }
        for (String str : traits) {
            b.append(str).append(" ");
        }
        event.getToolTip().add(new StringTextComponent(b.toString().toLowerCase(Locale.ROOT)).func_240699_a_(TextFormatting.DARK_GRAY).func_240699_a_(TextFormatting.ITALIC));
    }

    private static Optional<ITextComponent> getMaterialCategoriesLine(MaterialInstance material) {
        Collection<IMaterialCategory> categories = material.getCategories();
        if (!categories.isEmpty()) {
            IFormattableTextComponent text = new StringTextComponent(categories.stream().map(IMaterialCategory::getName).collect(Collectors.joining(", "))).func_240699_a_(TextFormatting.ITALIC);
            return Optional.of(TextUtil.misc("materialCategories", text));
        }
        return Optional.empty();
    }

    private static ITextComponent buildPartTypeHeader(Collection<PartType> types, PartType selectedType) {
        IFormattableTextComponent ret = new StringTextComponent("| ").func_240699_a_(TextFormatting.GRAY);
        for (PartType type : types) {
            Color color = type == selectedType ? Color.AQUAMARINE : MC_DARK_GRAY;
            IFormattableTextComponent text = TextUtil.withColor(type.getDisplayName(-1), color);
            ret.func_230529_a_((ITextComponent)text).func_240702_b_(" | ");
        }
        IFormattableTextComponent keyHint = TextUtil.misc("tooltip.material.keyHint", TextUtil.withColor(TextUtil.keyBinding(KeyTracker.CYCLE_BACK), Color.AQUAMARINE), TextUtil.withColor(TextUtil.keyBinding(KeyTracker.CYCLE_NEXT), Color.AQUAMARINE));
        return ret.func_230529_a_((ITextComponent)keyHint);
    }

    private static void onPartTooltip(ItemTooltipEvent event, ItemStack stack, PartData part) {
        List<GearType> blacklist;
        if (event.getFlags().func_194127_a() && KeyTracker.isControlDown()) {
            event.getToolTip().add(new StringTextComponent("* Part ID: " + part.getId()).func_240699_a_(TextFormatting.DARK_GRAY));
            event.getToolTip().add(new StringTextComponent("* Part data pack: " + part.get().getPackName()).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        if (!((Boolean)Config.Client.showPartTooltips.get()).booleanValue()) {
            return;
        }
        event.getToolTip().add(TextUtil.withColor(part.getType().getDisplayName(part.getTier()), Color.AQUAMARINE));
        ArrayList<TraitInstance> traits = new ArrayList<TraitInstance>();
        for (TraitInstance traitInstance : part.getTraits()) {
            if (!traitInstance.getTrait().showInTooltip(event.getFlags())) continue;
            traits.add(traitInstance);
        }
        int numTraits = traits.size();
        int traitIndex = TooltipHandler.getTraitDisplayIndex(numTraits);
        int i = 0;
        for (TraitInstance inst : traits) {
            if (traitIndex < 0 || traitIndex == i) {
                inst.addInformation(event.getToolTip(), event.getFlags());
            }
            ++i;
        }
        if (KeyTracker.isControlDown()) {
            event.getToolTip().add(new TranslationTextComponent("misc.silentgear.tooltip.stats").func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new StringTextComponent(" (Silent Gear)").func_240699_a_(TextFormatting.RESET).func_240699_a_(TextFormatting.ITALIC)));
            TooltipHandler.getPartStatLines(event, stack, part);
        } else {
            event.getToolTip().add(new TranslationTextComponent("misc.silentgear.tooltip.ctrlForStats").func_240699_a_(TextFormatting.GOLD));
        }
        if (part.get() instanceof AbstractGearPart && !(blacklist = ((AbstractGearPart)part.get()).getBlacklistedGearTypes()).isEmpty()) {
            int index = ClientTicks.ticksInGame() / 20 % blacklist.size();
            GearType gearType = blacklist.get(index);
            ITextComponent blacklistedType = gearType.getDisplayName();
            event.getToolTip().add(new TranslationTextComponent("misc.silentgear.tooltip.blacklist", new Object[]{blacklistedType}).func_240699_a_(TextFormatting.RED));
        }
    }

    private static int getTraitDisplayIndex(int numTraits) {
        return -1;
    }

    private static void getGradeLine(ItemTooltipEvent event, MaterialGrade grade) {
        IFormattableTextComponent text = TextUtil.withColor(grade.getDisplayName(), Color.DEEPSKYBLUE);
        event.getToolTip().add(new TranslationTextComponent("part.silentgear.gradeOnPart", new Object[]{text}));
    }

    private static void getMaterialTraitLines(ItemTooltipEvent event, PartType partType, MaterialInstance material) {
        Collection<TraitInstance> traits = material.getTraits(partType);
        if (traits.isEmpty()) {
            return;
        }
        IFormattableTextComponent header = TextUtil.misc("tooltip.traits", new Object[0]).func_240699_a_(TextFormatting.GOLD);
        if (!KeyTracker.isDisplayTraitsDown()) {
            IFormattableTextComponent keyHint = TextUtil.withColor(TextUtil.keyBinding(KeyTracker.DISPLAY_TRAITS), Color.AQUAMARINE);
            header.func_240702_b_(" ").func_230529_a_((ITextComponent)keyHint);
        }
        event.getToolTip().add(header);
        TextListBuilder builder = new TextListBuilder();
        for (TraitInstance trait : traits) {
            builder.add((ITextComponent)trait.getDisplayName());
            if (!event.getFlags().func_194127_a() && !KeyTracker.isDisplayTraitsDown()) continue;
            builder.indent();
            builder.add((ITextComponent)trait.getTrait().getDescription(trait.getLevel()).func_240699_a_(TextFormatting.DARK_GRAY));
            if (!trait.getConditions().isEmpty()) {
                builder.add((ITextComponent)TextUtil.withColor(trait.getConditionsText(), TextFormatting.DARK_GRAY));
            }
            builder.unindent();
        }
        event.getToolTip().addAll(builder.build());
    }

    private static void getPartStatLines(ItemTooltipEvent event, ItemStack stack, PartData part) {
        GearType gearType = TooltipHandler.getPartGearType(part);
        TextListBuilder builder = new TextListBuilder();
        ArrayList<ItemStat> relevantStats = new ArrayList<ItemStat>(part.getGearType().getRelevantStats());
        if (part.getGearType().isArmor() && relevantStats.contains(ItemStats.DURABILITY)) {
            int index = relevantStats.indexOf(ItemStats.DURABILITY);
            relevantStats.remove(ItemStats.DURABILITY);
            relevantStats.add(index, ItemStats.ARMOR_DURABILITY);
        }
        for (ItemStat stat : relevantStats) {
            ArrayList<StatInstance> modifiers = new ArrayList<StatInstance>();
            for (StatInstance mod : part.getStatModifiers(StatGearKey.of(stat, gearType), ItemStack.field_190927_a)) {
                if (mod.getOp() == StatInstance.Operation.AVG) {
                    float computed = stat.compute(Collections.singleton(mod));
                    modifiers.add(StatInstance.of(computed, StatInstance.Operation.AVG, mod.getKey()));
                    continue;
                }
                modifiers.add(mod);
            }
            TooltipHandler.getStatTooltipLine(event, part.getType(), stat, modifiers).ifPresent(builder::add);
        }
        event.getToolTip().addAll(builder.build());
    }

    private static GearType getPartGearType(PartData part) {
        GearType gearType;
        if (part.getItem().func_77973_b() instanceof CompoundPartItem && (gearType = ((CompoundPartItem)part.getItem().func_77973_b()).getGearType()).isGear()) {
            return gearType;
        }
        return GearType.ALL;
    }

    private static void getMaterialStatLines(ItemTooltipEvent event, PartType partType, MaterialInstance material) {
        TextListBuilder builder = new TextListBuilder();
        for (ItemStat stat : ItemStats.allStatsOrdered()) {
            if (!stat.isVisible()) continue;
            TooltipHandler.getMaterialStatModLines(event, partType, material, builder, stat);
        }
        event.getToolTip().addAll(builder.build());
    }

    private static void getMaterialStatModLines(ItemTooltipEvent event, PartType partType, MaterialInstance material, TextListBuilder builder, ItemStat stat) {
        Collection<StatInstance> modsAll = material.getStatModifiers(partType, StatGearKey.of(stat, GearType.ALL));
        Optional<IFormattableTextComponent> head = TooltipHandler.getStatTooltipLine(event, partType, stat, modsAll);
        builder.add((ITextComponent)head.orElseGet(() -> TextUtil.withColor(stat.getDisplayName(), stat.getNameColor())));
        builder.indent();
        int subCount = 0;
        List keysForStat = material.get().getStatKeys(material, partType).stream().filter(key -> key.getStat().equals(stat)).collect(Collectors.toList());
        for (StatGearKey key2 : keysForStat) {
            ItemStat stat1;
            if (key2.getGearType() == GearType.ALL || (stat1 = ItemStats.get(key2.getStat())) == null) continue;
            Collection<StatInstance> mods = material.getStatModifiers(partType, key2);
            Optional<IFormattableTextComponent> line = TooltipHandler.getSubStatTooltipLine(event, partType, stat1, key2.getGearType(), mods);
            if (!line.isPresent()) continue;
            builder.add((ITextComponent)line.get());
            ++subCount;
        }
        if (subCount == 0 && !head.isPresent()) {
            builder.removeLast();
        }
        builder.unindent();
    }

    private static Optional<IFormattableTextComponent> getStatTooltipLine(ItemTooltipEvent event, PartType partType, ItemStat stat, Collection<StatInstance> modifiers) {
        StatInstance inst;
        if (!modifiers.isEmpty() && (inst = stat.computeForDisplay(0.0f, GearType.ALL, modifiers)).shouldList(partType, stat, event.getFlags().func_194127_a())) {
            boolean isZero = inst.getValue() == 0.0f;
            Color nameColor = isZero ? MC_DARK_GRAY : stat.getNameColor();
            Color statColor = isZero ? MC_DARK_GRAY : Color.WHITE;
            IFormattableTextComponent nameStr = TextUtil.withColor(stat.getDisplayName(), nameColor);
            int decimalPlaces = stat.isDisplayAsInt() && inst.getOp() != StatInstance.Operation.MUL1 && inst.getOp() != StatInstance.Operation.MUL2 ? 0 : 2;
            IFormattableTextComponent statListText = TextUtil.withColor(StatModifierMap.formatText(modifiers, stat, decimalPlaces), statColor);
            IFormattableTextComponent textWithAdditions = stat == ItemStats.HARVEST_LEVEL && modifiers.size() == 1 ? TooltipHandler.harvestLevelWithHint(statListText, inst.getValue()) : statListText;
            return Optional.of(new TranslationTextComponent("stat.silentgear.displayFormat", new Object[]{nameStr, textWithAdditions}));
        }
        return Optional.empty();
    }

    private static Optional<IFormattableTextComponent> getSubStatTooltipLine(ItemTooltipEvent event, PartType partType, ItemStat stat, GearType gearType, Collection<StatInstance> modifiers) {
        StatInstance inst;
        if (!modifiers.isEmpty() && (inst = stat.computeForDisplay(0.0f, gearType, modifiers)).shouldList(partType, stat, event.getFlags().func_194127_a())) {
            boolean isZero = inst.getValue() == 0.0f;
            Color color = isZero ? MC_DARK_GRAY : Color.WHITE;
            IFormattableTextComponent nameStr = TextUtil.withColor(gearType.getDisplayName().func_230532_e_(), color);
            int decimalPlaces = stat.isDisplayAsInt() && inst.getOp() != StatInstance.Operation.MUL1 && inst.getOp() != StatInstance.Operation.MUL2 ? 0 : 2;
            IFormattableTextComponent statListText = TextUtil.withColor(StatModifierMap.formatText(modifiers, stat, decimalPlaces), color);
            IFormattableTextComponent textWithAdditions = stat == ItemStats.HARVEST_LEVEL && modifiers.size() == 1 ? TooltipHandler.harvestLevelWithHint(statListText, inst.getValue()) : statListText;
            return Optional.of(new TranslationTextComponent("stat.silentgear.displayFormat", new Object[]{nameStr, textWithAdditions}));
        }
        return Optional.empty();
    }

    public static IFormattableTextComponent harvestLevelWithHint(IFormattableTextComponent statValueText, float statValue) {
        String key = "misc.silentgear.harvestLevel." + Math.round(statValue);
        if (I18n.func_188566_a((String)key)) {
            return statValueText.func_230529_a_((ITextComponent)TextUtil.misc("spaceBrackets", new TranslationTextComponent(key)));
        }
        return statValueText;
    }

    static {
        assert (TextFormatting.DARK_GRAY.func_211163_e() != null);
        assert (TextFormatting.GRAY.func_211163_e() != null);
        MC_DARK_GRAY = new Color(TextFormatting.DARK_GRAY.func_211163_e().intValue());
        MC_GRAY = new Color(TextFormatting.GRAY.func_211163_e().intValue());
    }
}

