/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.material;

import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.IMaterialLayerList;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.material.MaterialLayerList;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.client.material.MaterialDisplayManager;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.item.CompoundMaterialItem;
import net.silentchaos512.gear.item.IColoredMaterialItem;
import net.silentchaos512.gear.util.Const;

public class CompoundMaterialDisplay
implements IMaterialDisplay {
    public static final CompoundMaterialDisplay INSTANCE = new CompoundMaterialDisplay();

    @Override
    public ResourceLocation getMaterialId() {
        return Const.NULL_ID;
    }

    @Override
    public IMaterialLayerList getLayerList(GearType gearType, IPartData part, IMaterialInstance material) {
        IMaterialInstance primary;
        ItemStack stack = material.getItem();
        if (!material.isSimple() && stack.func_77973_b() instanceof IColoredMaterialItem && (primary = ((IColoredMaterialItem)stack.func_77973_b()).getPrimarySubMaterial(stack)) != null) {
            IMaterialDisplay model = MaterialDisplayManager.get(primary);
            return model.getLayerList(gearType, part, material);
        }
        return MaterialLayerList.DEFAULT;
    }

    @Override
    public int getLayerColor(GearType gearType, IPartData part, IMaterialInstance materialIn, int layer) {
        ItemStack stack;
        List<MaterialLayer> layers = this.getLayerList(gearType, part, materialIn).getLayers();
        if (layer < layers.size() && (stack = materialIn.getItem()).func_77973_b() instanceof CompoundMaterialItem) {
            MaterialList subMaterials = CompoundMaterialItem.getSubMaterials(stack);
            int color = ColorUtils.getBlendedColor((CompoundMaterialItem)stack.func_77973_b(), (Collection<? extends IMaterialInstance>)subMaterials, layer);
            return color;
        }
        return 0xFFFFFF;
    }
}

