/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.model.gear;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.part.IPartDisplay;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.material.MaterialDisplayManager;
import net.silentchaos512.gear.client.model.BakedPerspectiveModel;
import net.silentchaos512.gear.client.model.BakedWrapper;
import net.silentchaos512.gear.client.model.LayeredModel;
import net.silentchaos512.gear.client.model.PartTextures;
import net.silentchaos512.gear.client.model.gear.GearModelOverrideList;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.FakePartData;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearHelper;

public class GearModel
extends LayeredModel<GearModel> {
    private final ItemCameraTransforms cameraTransforms;
    final GearType gearType;
    private final ICoreItem item;
    private GearModelOverrideList overrideList;
    private final String texturePath;
    private final String brokenTexturePath;
    private final Set<PartType> brokenTextureTypes = new HashSet<PartType>();

    GearModel(ItemCameraTransforms cameraTransforms, GearType gearType, String texturePath, String brokenTexturePath, Collection<PartType> brokenTextureTypes) {
        this.cameraTransforms = cameraTransforms;
        this.gearType = gearType;
        this.texturePath = texturePath;
        this.brokenTexturePath = brokenTexturePath;
        this.brokenTextureTypes.addAll(brokenTextureTypes);
        this.item = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof ICoreItem && ((ICoreItem)item).getGearType() == this.gearType).map(item -> (ICoreItem)item).findFirst().orElseThrow(() -> new NullPointerException("No item for gear type: " + this.gearType.getName()));
    }

    public void clearCache() {
        if (this.overrideList != null) {
            this.overrideList.clearCache();
        }
    }

    private String getTexturePath(boolean broken) {
        return broken ? this.brokenTexturePath : this.texturePath;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        this.overrideList = new GearModelOverrideList(this, owner, bakery, spriteGetter, modelTransform, modelLocation);
        return new BakedWrapper(this, owner, bakery, spriteGetter, modelTransform, modelLocation, this.overrideList);
    }

    public IBakedModel bake(ItemStack stack, List<MaterialLayer> layers, int animationFrame, String transformVariant, IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrideList, ResourceLocation modelLocation) {
        ImmutableList.Builder builder = ImmutableList.builder();
        TransformationMatrix rotation = modelTransform.func_225615_b_();
        ImmutableMap transforms = PerspectiveMapWrapper.getTransforms((IModelTransform)modelTransform);
        boolean broken = GearHelper.isBroken(stack);
        for (int i = 0; i < layers.size(); ++i) {
            MaterialLayer layer = layers.get(i);
            RenderMaterial renderMaterial = this.getTexture(layer, animationFrame, broken);
            TextureAtlasSprite texture = spriteGetter.apply(renderMaterial);
            builder.addAll(GearModel.getQuadsForSprite(i, texture, rotation, layer.getColor()));
            if (!GearModelOverrideList.isDebugLoggingEnabled()) continue;
            SilentGear.LOGGER.info("  - {} -> {}", (Object)layer.getTextureId(), (Object)renderMaterial.func_229313_b_());
        }
        if (layers.isEmpty()) {
            if (Const.Materials.EXAMPLE.isPresent()) {
                this.buildFakeModel(spriteGetter, (ImmutableList.Builder<BakedQuad>)builder, rotation, Const.Materials.EXAMPLE.get());
            } else {
                SilentGear.LOGGER.error("Example material is missing?");
                TextureAtlasSprite texture = spriteGetter.apply(new RenderMaterial(PlayerContainer.field_226615_c_, (ResourceLocation)SilentGear.getId("item/error")));
                builder.addAll(GearModel.getQuadsForSprite(0, texture, rotation, 0xFFFFFF));
            }
        }
        TextureAtlasSprite particle = spriteGetter.apply(owner.resolveTexture("particle"));
        return new BakedPerspectiveModel((ImmutableList<BakedQuad>)builder.build(), particle, (ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix>)transforms, overrideList, rotation.isIdentity(), owner.isSideLit(), this.getCameraTransforms(transformVariant));
    }

    private void buildFakeModel(Function<RenderMaterial, TextureAtlasSprite> spriteGetter, ImmutableList.Builder<BakedQuad> builder, TransformationMatrix rotation, IMaterial material) {
        MaterialLayer exampleBowstring;
        MaterialLayer exampleMain;
        MaterialLayer exampleRod;
        MaterialInstance mat = MaterialInstance.of(material);
        IMaterialDisplay model = MaterialDisplayManager.get(mat);
        if (!this.gearType.isArmor() && (exampleRod = model.getLayerList(this.gearType, PartType.ROD, (IMaterialInstance)mat).getFirstLayer()) != null) {
            builder.addAll(GearModel.getQuadsForSprite(0, spriteGetter.apply(new RenderMaterial(PlayerContainer.field_226615_c_, exampleRod.getTexture(this.gearType, 0))), rotation, exampleRod.getColor()));
        }
        if ((exampleMain = model.getLayerList(this.gearType, PartType.MAIN, (IMaterialInstance)mat).getFirstLayer()) != null) {
            builder.addAll(GearModel.getQuadsForSprite(0, spriteGetter.apply(new RenderMaterial(PlayerContainer.field_226615_c_, exampleMain.getTexture(this.gearType, 0))), rotation, exampleMain.getColor()));
        }
        if (this.gearType.matches(GearType.RANGED_WEAPON) && (exampleBowstring = model.getLayerList(this.gearType, PartType.BOWSTRING, (IMaterialInstance)mat).getFirstLayer()) != null) {
            builder.addAll(GearModel.getQuadsForSprite(0, spriteGetter.apply(new RenderMaterial(PlayerContainer.field_226615_c_, exampleBowstring.getTexture(this.gearType, 0))), rotation, exampleBowstring.getColor()));
        }
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<RenderMaterial> ret = new HashSet<RenderMaterial>();
        ret.add(new RenderMaterial(PlayerContainer.field_226615_c_, (ResourceLocation)SilentGear.getId("item/error")));
        for (PartTextures tex : PartTextures.getTextures(this.gearType)) {
            int animationFrames = tex.isAnimated() ? this.item.getAnimationFrames() : 1;
            for (int i = 0; i < animationFrames; ++i) {
                MaterialLayer layer = new MaterialLayer(tex, 0xFFFFFF);
                ret.add(this.getTexture(layer, i, false));
                ret.add(this.getTexture(layer, 0, true));
            }
        }
        for (IMaterialDisplay materialDisplay : MaterialDisplayManager.getMaterials()) {
            for (PartType partType : PartType.getValues()) {
                if (!this.item.hasTexturesFor(partType)) continue;
                for (MaterialLayer layer : materialDisplay.getLayerList(this.gearType, partType, (IMaterialInstance)LazyMaterialInstance.of(materialDisplay.getMaterialId()))) {
                    int animationFrames = layer.isAnimated() ? this.item.getAnimationFrames() : 1;
                    ret.addAll(this.getTexturesForAllFrames(layer, animationFrames, false));
                    ret.addAll(this.getTexturesForAllFrames(layer, 1, true));
                }
            }
        }
        for (IPartDisplay partDisplay : MaterialDisplayManager.getParts()) {
            for (MaterialLayer layer : partDisplay.getLayers(this.gearType, FakePartData.of(PartType.NONE))) {
                int animationFrames = layer.isAnimated() ? this.item.getAnimationFrames() : 1;
                ret.addAll(this.getTexturesForAllFrames(layer, animationFrames, false));
                ret.addAll(this.getTexturesForAllFrames(layer, animationFrames, true));
            }
        }
        if (GearModelOverrideList.isDebugLoggingEnabled()) {
            SilentGear.LOGGER.info("Textures for gear model '{}' ({})", (Object)this.getTexturePath(false), (Object)this.gearType.getName());
            for (RenderMaterial mat : ret) {
                SilentGear.LOGGER.info("- {}", (Object)mat.func_229313_b_());
            }
        }
        return ret;
    }

    private Collection<RenderMaterial> getTexturesForAllFrames(MaterialLayer layer, int animationFrameCount, boolean broken) {
        return IntStream.range(0, animationFrameCount).mapToObj(frame -> this.getTexture(layer, frame, broken)).collect(Collectors.toList());
    }

    private RenderMaterial getTexture(MaterialLayer layer, int animationFrame, boolean broken) {
        ResourceLocation tex = layer.getTextureId();
        String path = "item/" + this.getTexturePath(broken) + "/" + tex.func_110623_a();
        String suffix = animationFrame > 0 && layer.isAnimated() ? "_" + animationFrame : "";
        ResourceLocation location = new ResourceLocation(tex.func_110624_b(), path + suffix);
        if (broken && !this.hasBrokenTexture(layer.getPartType())) {
            return this.getTexture(layer, animationFrame, false);
        }
        return GearModel.getMaterial(location);
    }

    private boolean hasBrokenTexture(PartType type) {
        return this.brokenTextureTypes.contains(type);
    }

    private static RenderMaterial getMaterial(ResourceLocation tex) {
        return new RenderMaterial(PlayerContainer.field_226615_c_, tex);
    }

    public Collection<? extends IModelGeometryPart> getParts() {
        return Collections.emptyList();
    }

    public Optional<? extends IModelGeometryPart> getPart(String name) {
        return Optional.empty();
    }

    private ItemCameraTransforms getCameraTransforms(String transformVariant) {
        return this.cameraTransforms;
    }
}

