/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe.smithing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.crafting.recipe.smithing.GearSmithingRecipe;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class CoatingSmithingRecipe
extends GearSmithingRecipe {
    public CoatingSmithingRecipe(ResourceLocation recipeIdIn, ItemStack gearItem, Ingredient additionIn) {
        super(recipeIdIn, gearItem, additionIn);
    }

    @Override
    protected ItemStack applyUpgrade(ItemStack gear, ItemStack upgradeItem) {
        GearType gearType;
        MaterialInstance material = MaterialInstance.from(upgradeItem);
        if (material != null && (gearType = GearHelper.getType(gear)).isGear()) {
            ItemStack result = gear.func_77946_l();
            PartType.COATING.getCompoundPartItem(gearType).ifPresent(cpi -> {
                ItemStack partItem = cpi.create(material, 1);
                GearData.addOrReplacePart(result, Objects.requireNonNull(PartData.from(partItem)));
            });
            result.func_196085_b(0);
            GearData.removeExcessParts(result, PartType.COATING);
            GearData.recalculateStats(result, ForgeHooks.getCraftingPlayer());
            return result;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.SMITHING_COATING.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CoatingSmithingRecipe> {
        public CoatingSmithingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ItemStack gearItem = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"gear"));
            Ingredient upgradeItem = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"addition"));
            return new CoatingSmithingRecipe(recipeId, gearItem, upgradeItem);
        }

        public CoatingSmithingRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            ItemStack itemstack = buffer.func_150791_c();
            Ingredient ingredient1 = Ingredient.func_199566_b((PacketBuffer)buffer);
            return new CoatingSmithingRecipe(recipeId, itemstack, ingredient1);
        }

        public void toNetwork(PacketBuffer buffer, CoatingSmithingRecipe recipe) {
            buffer.func_150788_a(recipe.gearItem);
            recipe.field_234838_b_.func_199564_a(buffer);
        }
    }
}

