/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.ITraitConditionSerializer;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.trait.AttributeTrait;
import net.silentchaos512.gear.gear.trait.BlockFillerTrait;
import net.silentchaos512.gear.gear.trait.BlockPlacerTrait;
import net.silentchaos512.gear.gear.trait.BonusDropsTrait;
import net.silentchaos512.gear.gear.trait.CancelEffectsTrait;
import net.silentchaos512.gear.gear.trait.DamageTypeTrait;
import net.silentchaos512.gear.gear.trait.DurabilityTrait;
import net.silentchaos512.gear.gear.trait.EnchantmentTrait;
import net.silentchaos512.gear.gear.trait.NBTTrait;
import net.silentchaos512.gear.gear.trait.PotionEffectTrait;
import net.silentchaos512.gear.gear.trait.SelfRepairTrait;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.gear.trait.StatModifierTrait;
import net.silentchaos512.gear.gear.trait.StellarTrait;
import net.silentchaos512.gear.gear.trait.SynergyTrait;
import net.silentchaos512.gear.gear.trait.TargetEffectTrait;
import net.silentchaos512.gear.gear.trait.TraitManager;
import net.silentchaos512.gear.gear.trait.condition.AndTraitCondition;
import net.silentchaos512.gear.gear.trait.condition.GearTypeTraitCondition;
import net.silentchaos512.gear.gear.trait.condition.MaterialCountTraitCondition;
import net.silentchaos512.gear.gear.trait.condition.MaterialRatioTraitCondition;
import net.silentchaos512.gear.gear.trait.condition.NotTraitCondition;
import net.silentchaos512.gear.gear.trait.condition.OrTraitCondition;
import net.silentchaos512.gear.gear.trait.condition.PrimaryMaterialTraitCondition;

public final class TraitSerializers {
    private static final Map<ResourceLocation, ITraitSerializer<?>> REGISTRY = new HashMap();
    private static final Map<ResourceLocation, ITraitConditionSerializer<?>> CONDITIONS = new HashMap();

    private TraitSerializers() {
    }

    public static <S extends ITraitConditionSerializer<T>, T extends ITraitCondition> S registerCondition(S serializer) {
        if (CONDITIONS.containsKey(serializer.getId())) {
            throw new IllegalArgumentException("Duplicate trait condition serializer " + serializer.getId());
        }
        SilentGear.LOGGER.info(TraitManager.MARKER, "Registered condition serializer '{}'", (Object)serializer.getId());
        CONDITIONS.put(serializer.getId(), serializer);
        return serializer;
    }

    public static <S extends ITraitSerializer<T>, T extends ITrait> S register(S serializer) {
        if (REGISTRY.containsKey(serializer.getName())) {
            throw new IllegalArgumentException("Duplicate trait serializer " + serializer.getName());
        }
        SilentGear.LOGGER.info(TraitManager.MARKER, "Registered serializer '{}'", (Object)serializer.getName());
        REGISTRY.put(serializer.getName(), serializer);
        return serializer;
    }

    public static ITraitCondition deserializeCondition(JsonObject json) {
        ResourceLocation type = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"type"));
        ITraitConditionSerializer<?> serializer = CONDITIONS.get(type);
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown trait condition type: " + type);
        }
        return serializer.deserialize(json);
    }

    public static <T extends ITraitCondition> JsonObject serializeCondition(T condition) {
        ITraitConditionSerializer<?> serializer = CONDITIONS.get(condition.getId());
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown trait condition type: " + condition.getId());
        }
        return serializer.serialize(condition);
    }

    public static ITraitCondition readCondition(PacketBuffer buffer) {
        ResourceLocation type = buffer.func_192575_l();
        ITraitConditionSerializer<?> serializer = CONDITIONS.get(type);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown trait condition type: " + type);
        }
        return serializer.read(buffer);
    }

    public static <T extends ITraitCondition> void writeCondition(T condition, PacketBuffer buffer) {
        ITraitConditionSerializer<?> serializer = condition.getSerializer();
        buffer.func_192572_a(serializer.getId());
        serializer.write(condition, buffer);
    }

    public static ITrait deserialize(ResourceLocation id, JsonObject json) {
        String typeStr = JSONUtils.func_151200_h((JsonObject)json, (String)"type");
        ResourceLocation type = SilentGear.getIdWithDefaultNamespace(typeStr);
        TraitSerializers.log(() -> "deserialize " + id + " (type " + type + ")");
        ITraitSerializer<?> serializer = REGISTRY.get(type);
        if (serializer == null) {
            throw new JsonParseException("Invalid or unsupported trait type " + type);
        }
        return serializer.read(id, json);
    }

    public static ITrait read(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        ResourceLocation type = buffer.func_192575_l();
        TraitSerializers.log(() -> "read " + id + " (type " + type + ")");
        ITraitSerializer<?> serializer = REGISTRY.get(type);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown trait serializer " + type);
        }
        return serializer.read(id, buffer);
    }

    public static <T extends ITrait> void write(T trait, PacketBuffer buffer) {
        ResourceLocation id = trait.getId();
        ResourceLocation type = trait.getSerializer().getName();
        TraitSerializers.log(() -> "write " + id + " (type " + type + ")");
        buffer.func_192572_a(id);
        buffer.func_192572_a(type);
        ITraitSerializer<?> serializer = trait.getSerializer();
        serializer.write(buffer, trait);
    }

    private static void log(Supplier<?> msg) {
        if (((Boolean)Config.Common.extraPartAndTraitLogging.get()).booleanValue()) {
            SilentGear.LOGGER.info(TraitManager.MARKER, msg.get());
        }
    }

    public static Collection<ITraitSerializer<?>> getSerializers() {
        return REGISTRY.values();
    }

    static {
        TraitSerializers.registerCondition(NotTraitCondition.SERIALIZER);
        TraitSerializers.registerCondition(AndTraitCondition.SERIALIZER);
        TraitSerializers.registerCondition(OrTraitCondition.SERIALIZER);
        TraitSerializers.registerCondition(GearTypeTraitCondition.SERIALIZER);
        TraitSerializers.registerCondition(MaterialCountTraitCondition.SERIALIZER);
        TraitSerializers.registerCondition(MaterialRatioTraitCondition.SERIALIZER);
        TraitSerializers.registerCondition(PrimaryMaterialTraitCondition.SERIALIZER);
        TraitSerializers.register(SimpleTrait.SERIALIZER);
        TraitSerializers.register(DamageTypeTrait.SERIALIZER);
        TraitSerializers.register(DurabilityTrait.SERIALIZER);
        TraitSerializers.register(EnchantmentTrait.SERIALIZER);
        TraitSerializers.register(NBTTrait.SERIALIZER);
        TraitSerializers.register(PotionEffectTrait.SERIALIZER);
        TraitSerializers.register(StatModifierTrait.SERIALIZER);
        TraitSerializers.register(AttributeTrait.SERIALIZER);
        TraitSerializers.register(BlockPlacerTrait.SERIALIZER);
        TraitSerializers.register(BlockFillerTrait.SERIALIZER);
        TraitSerializers.register(SynergyTrait.SERIALIZER);
        TraitSerializers.register(TargetEffectTrait.SERIALIZER);
        TraitSerializers.register(BonusDropsTrait.SERIALIZER);
        TraitSerializers.register(CancelEffectsTrait.SERIALIZER);
        TraitSerializers.register(SelfRepairTrait.SERIALIZER);
        TraitSerializers.register(StellarTrait.SERIALIZER);
    }
}

