/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.silentchaos512.gear.block.charger.ChargerTileEntity;
import net.silentchaos512.gear.block.compounder.CompounderTileEntity;
import net.silentchaos512.gear.block.grader.GraderTileEntity;
import net.silentchaos512.gear.block.press.MetalPressTileEntity;
import net.silentchaos512.gear.block.salvager.SalvagerTileEntity;
import net.silentchaos512.gear.crafting.recipe.compounder.FabricCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.GemCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.MetalCompoundingRecipe;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.block.IBlockProvider;

public final class ModTileEntities {
    public static final RegistryObject<TileEntityType<GraderTileEntity>> MATERIAL_GRADER = ModTileEntities.register("material_grader", GraderTileEntity::new, new IBlockProvider[]{ModBlocks.MATERIAL_GRADER});
    public static final RegistryObject<TileEntityType<CompounderTileEntity>> METAL_ALLOYER = ModTileEntities.register("metal_alloyer", () -> new CompounderTileEntity<MetalCompoundingRecipe>(Const.METAL_COMPOUNDER_INFO), new IBlockProvider[]{ModBlocks.METAL_ALLOYER});
    public static final RegistryObject<TileEntityType<MetalPressTileEntity>> METAL_PRESS = ModTileEntities.register("metal_press", () -> new MetalPressTileEntity(), new IBlockProvider[]{ModBlocks.METAL_PRESS});
    public static final RegistryObject<TileEntityType<CompounderTileEntity>> RECRYSTALLIZER = ModTileEntities.register("recrystallizer", () -> new CompounderTileEntity<GemCompoundingRecipe>(Const.GEM_COMPOUNDER_INFO), new IBlockProvider[]{ModBlocks.RECRYSTALLIZER});
    public static final RegistryObject<TileEntityType<CompounderTileEntity>> REFABRICATOR = ModTileEntities.register("refabricator", () -> new CompounderTileEntity<FabricCompoundingRecipe>(Const.FABRIC_COMPOUNDER_INFO), new IBlockProvider[]{ModBlocks.REFABRICATOR});
    public static final RegistryObject<TileEntityType<SalvagerTileEntity>> SALVAGER = ModTileEntities.register("salvager", SalvagerTileEntity::new, new IBlockProvider[]{ModBlocks.SALVAGER});
    public static final RegistryObject<TileEntityType<ChargerTileEntity>> STARLIGHT_CHARGER = ModTileEntities.register("starlight_charger", ChargerTileEntity::createStarlightCharger, new IBlockProvider[]{ModBlocks.STARLIGHT_CHARGER});

    private ModTileEntities() {
    }

    static void register() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderers(FMLClientSetupEvent event) {
    }

    private static <T extends TileEntity> RegistryObject<TileEntityType<T>> register(String name, Supplier<T> factory, IBlockProvider ... blocks) {
        return Registration.TILE_ENTITIES.register(name, () -> {
            Block[] validBlocks = (Block[])Arrays.stream(blocks).map(IBlockProvider::asBlock).toArray(Block[]::new);
            return TileEntityType.Builder.func_223042_a((Supplier)factory, (Block[])validBlocks).func_206865_a(null);
        });
    }
}

