/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.item.gear.CoreAxe;

public class CoreSaw
extends CoreAxe {
    @Override
    public GearType getGearType() {
        return GearType.SAW;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        BlockState state;
        World world = player.field_70170_p;
        if (!world.field_72995_K && CoreSaw.isLog(state = world.func_180495_p(pos)) && CoreSaw.detectTree((IBlockReader)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), state.func_177230_c())) {
            if (player.field_71075_bZ.field_75098_d) {
                return false;
            }
            TreeBreakResult result = new TreeBreakResult(stack, player);
            this.breakTree(result, world, pos, pos, 0);
            SilentGear.LOGGER.debug("{} chopped down a tree with {} blocks using {}. Max recursion depth: {}", (Object)player.func_195047_I_(), (Object)result.blocksBroken, (Object)stack.func_200301_q().getString(), (Object)result.maxDepth);
            return true;
        }
        return false;
    }

    private static boolean detectTree(IBlockReader world, int x, int y, int z, Block wood) {
        BlockPos.Mutable pos = new BlockPos.Mutable(x, y, z);
        int height = y;
        boolean foundTop = false;
        do {
            if (CoreSaw.checkForLogs(world, pos.func_177967_a(Direction.UP, ++height - y))) continue;
            --height;
            foundTop = true;
        } while (!foundTop);
        int foliageCount = 0;
        if (height - y < 50) {
            for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                for (int yPos = height - 1; yPos <= height + 1; ++yPos) {
                    for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                        BlockState leaves = world.func_180495_p((BlockPos)pos.func_181079_c(xPos, yPos, zPos));
                        if (!CoreSaw.isFoliage(leaves)) continue;
                        ++foliageCount;
                    }
                }
            }
        }
        return foliageCount > 3;
    }

    private static boolean checkForLogs(IBlockReader world, BlockPos pos) {
        return CoreSaw.isLog(world.func_180495_p(pos)) || CoreSaw.isLog(world.func_180495_p(pos.func_177972_a(Direction.NORTH))) || CoreSaw.isLog(world.func_180495_p(pos.func_177972_a(Direction.SOUTH))) || CoreSaw.isLog(world.func_180495_p(pos.func_177972_a(Direction.EAST))) || CoreSaw.isLog(world.func_180495_p(pos.func_177972_a(Direction.WEST))) || CoreSaw.isLog(world.func_180495_p(pos.func_177972_a(Direction.NORTH).func_177972_a(Direction.EAST))) || CoreSaw.isLog(world.func_180495_p(pos.func_177972_a(Direction.NORTH).func_177972_a(Direction.WEST))) || CoreSaw.isLog(world.func_180495_p(pos.func_177972_a(Direction.SOUTH).func_177972_a(Direction.EAST))) || CoreSaw.isLog(world.func_180495_p(pos.func_177972_a(Direction.SOUTH).func_177972_a(Direction.WEST)));
    }

    private static boolean isLog(BlockState state) {
        return CoreSaw.isLog(state, null);
    }

    private static boolean isLog(BlockState state, @Nullable TreeBreakResult result) {
        if (result != null && result.firstLog != null) {
            return state.func_177230_c() == result.firstLog;
        }
        return state.func_235714_a_((ITag)BlockTags.field_200031_h);
    }

    private static boolean isFoliage(BlockState state) {
        return CoreSaw.isFoliage(state, null);
    }

    private static boolean isFoliage(BlockState state, @Nullable TreeBreakResult result) {
        if (state.func_177230_c() == Blocks.field_235383_mw_) {
            return true;
        }
        if (state.func_235901_b_((Property)LeavesBlock.field_208495_b) && ((Boolean)state.func_177229_b((Property)LeavesBlock.field_208495_b)).booleanValue()) {
            return false;
        }
        if (result != null && result.firstFoliage != null) {
            return state.func_177230_c() == result.firstFoliage;
        }
        return state.func_235714_a_((ITag)BlockTags.field_206952_E) || state.func_235714_a_((ITag)BlockTags.field_232874_ao_);
    }

    private void breakTree(TreeBreakResult result, World world, BlockPos pos, BlockPos startPos, int recursionDepth) {
        result.maxDepth = recursionDepth;
        if (recursionDepth > (Integer)Config.Common.sawRecursionDepth.get()) {
            return;
        }
        for (int xPos = pos.func_177958_n() - 1; xPos <= pos.func_177958_n() + 1; ++xPos) {
            for (int yPos = pos.func_177956_o() - 1; yPos <= pos.func_177956_o() + 1; ++yPos) {
                for (int zPos = pos.func_177952_p() - 1; zPos <= pos.func_177952_p() + 1; ++zPos) {
                    BlockPos localPos = new BlockPos(xPos, yPos, zPos);
                    BlockState localState = world.func_180495_p(localPos);
                    Block localBlock = localState.func_177230_c();
                    boolean isLog = CoreSaw.isLog(localState, result);
                    boolean isFoliage = CoreSaw.isFoliage(localState, result);
                    if (!isLog && !isFoliage) continue;
                    if (isLog && result.firstLog == null) {
                        result.firstLog = localBlock;
                    }
                    if (isFoliage && result.firstFoliage == null) {
                        result.firstFoliage = localBlock;
                    }
                    int harvestLevel = localBlock.getHarvestLevel(localState);
                    float localHardness = localState.func_185887_b((IBlockReader)world, localPos);
                    if (harvestLevel > this.getHarvestLevel(result.tool, ToolType.AXE, result.player, localState) || !(localHardness >= 0.0f)) continue;
                    BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, localPos, localState, result.player);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    boolean cancel = event.isCanceled();
                    int xDist = xPos - startPos.func_177958_n();
                    int yDist = yPos - startPos.func_177956_o();
                    int zDist = zPos - startPos.func_177952_p();
                    if (9 * xDist * xDist + yDist * yDist + 9 * zDist * zDist >= 1000) continue;
                    if (cancel) {
                        this.breakTree(result, world, localPos, startPos, recursionDepth + 1);
                        continue;
                    }
                    if (!result.player.field_71075_bZ.field_75098_d) {
                        localBlock.func_180657_a(world, result.player, pos, localState, world.func_175625_s(pos), result.tool);
                        this.func_179218_a(result.tool, world, localState, localPos, (LivingEntity)result.player);
                        ++result.blocksBroken;
                    }
                    world.func_217377_a(localPos, false);
                    this.breakTree(result, world, localPos, startPos, recursionDepth + 1);
                }
            }
        }
    }

    private static final class TreeBreakResult {
        final ItemStack tool;
        final PlayerEntity player;
        int blocksBroken;
        int maxDepth;
        Block firstLog;
        Block firstFoliage;

        private TreeBreakResult(ItemStack tool, PlayerEntity player) {
            this.tool = tool;
            this.player = player;
        }
    }
}

