/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class RecalculateStatsPacket {
    private final int slot;
    private final IItemStat triggerStat;

    private RecalculateStatsPacket(int slot, IItemStat triggerStat) {
        this.slot = slot;
        this.triggerStat = triggerStat;
    }

    public RecalculateStatsPacket(World level, ItemStack stack, IItemStat triggerStat) {
        this.slot = RecalculateStatsPacket.findSlotOnClientPlayer(level, stack);
        this.triggerStat = triggerStat;
    }

    private static int findSlotOnClientPlayer(World level, ItemStack stack) {
        PlayerEntity player;
        if (level instanceof ClientWorld && (player = SilentGear.PROXY.getClientPlayer()) != null) {
            return player.field_71071_by.func_184429_b(stack);
        }
        return -1;
    }

    public ItemStack getItem(Supplier<NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        if (player != null && player.field_71071_by != null && this.slot >= 0 && this.slot < player.field_71071_by.func_70302_i_()) {
            return player.field_71071_by.func_70301_a(this.slot);
        }
        return ItemStack.field_190927_a;
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        ItemStack stack = this.getItem(context);
        if (GearHelper.isGear(stack)) {
            GearData.recalculateStats(stack, (PlayerEntity)context.get().getSender());
            GearData.putStatInNbtIfMissing(stack, this.triggerStat);
        }
    }

    public static RecalculateStatsPacket decode(PacketBuffer buffer) {
        int slot = buffer.func_150792_a();
        ItemStat stat = ItemStats.byName(buffer.func_192575_l());
        return new RecalculateStatsPacket(slot, Objects.requireNonNull(stat));
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.slot);
        buffer.func_192572_a(this.triggerStat.getStatId());
    }
}

