/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.blocks.FlagBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.FlagBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.quark.api.IRotationLockable;

public class StickBlock
extends WaterBlock
implements IRotationLockable {
    protected static final VoxelShape Y_AXIS_AABB = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0);
    protected static final VoxelShape X_AXIS_AABB = Block.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    protected static final VoxelShape Y_Z_AXIS_AABB = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0));
    protected static final VoxelShape Y_X_AXIS_AABB = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0));
    protected static final VoxelShape X_Z_AXIS_AABB = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0));
    protected static final VoxelShape X_Y_Z_AXIS_AABB = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)});
    public static final BooleanProperty AXIS_X = BlockProperties.AXIS_X;
    public static final BooleanProperty AXIS_Y = BlockProperties.AXIS_Y;
    public static final BooleanProperty AXIS_Z = BlockProperties.AXIS_Z;
    protected final Map<Direction.Axis, BooleanProperty> AXIS2PROPERTY = ImmutableMap.of((Object)Direction.Axis.X, (Object)AXIS_X, (Object)Direction.Axis.Y, (Object)AXIS_Y, (Object)Direction.Axis.Z, (Object)AXIS_Z);

    public StickBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).func_206870_a((Property)AXIS_Y, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)AXIS_X, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)AXIS_Z, (Comparable)Boolean.valueOf(false)));
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 60;
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new StringTextComponent("You shouldn't have this").func_240699_a_(TextFormatting.GRAY));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{AXIS_X, AXIS_Y, AXIS_Z});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        boolean x = (Boolean)state.func_177229_b((Property)AXIS_X);
        boolean y = (Boolean)state.func_177229_b((Property)AXIS_Y);
        boolean z = (Boolean)state.func_177229_b((Property)AXIS_Z);
        if (x) {
            if (y) {
                if (z) {
                    return X_Y_Z_AXIS_AABB;
                }
                return Y_X_AXIS_AABB;
            }
            if (z) {
                return X_Z_AXIS_AABB;
            }
            return X_AXIS_AABB;
        }
        if (z) {
            if (y) {
                return Y_Z_AXIS_AABB;
            }
            return Z_AXIS_AABB;
        }
        return Y_AXIS_AABB;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        BooleanProperty axis = this.AXIS2PROPERTY.get(context.func_196000_l().func_176740_k());
        if (blockstate.func_203425_a((Block)this)) {
            return (BlockState)blockstate.func_206870_a((Property)axis, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)AXIS_Y, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)axis, (Comparable)Boolean.valueOf(true));
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext context) {
        BooleanProperty axis;
        Item item2 = context.func_195996_i().func_77973_b();
        if (!(item2 != Items.field_151055_y && item2 != this.func_199767_j() || ((Boolean)state.func_177229_b((Property)(axis = this.AXIS2PROPERTY.get(context.func_196000_l().func_176740_k())))).booleanValue())) {
            return true;
        }
        return super.func_196253_a(state, context);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)Items.field_151055_y);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player.func_184586_b(hand).func_190926_b() && hand == Hand.MAIN_HAND && ServerConfigs.cached.STICK_POLE) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            Direction moveDir = player.func_225608_bj_() ? Direction.DOWN : Direction.UP;
            StickBlock.findConnectedFlag(world, pos, Direction.UP, moveDir, 0);
            StickBlock.findConnectedFlag(world, pos, Direction.DOWN, moveDir, 0);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    private static boolean isVertical(BlockState state) {
        return (Boolean)state.func_177229_b((Property)AXIS_Y) != false && (Boolean)state.func_177229_b((Property)AXIS_X) == false && (Boolean)state.func_177229_b((Property)AXIS_Z) == false;
    }

    public static boolean findConnectedFlag(World world, BlockPos pos, Direction searchDir, Direction moveDir, int it) {
        if (it > ServerConfigs.cached.STICK_POLE_LENGTH) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b == ModRegistry.STICK_BLOCK.get() && StickBlock.isVertical(state)) {
            return StickBlock.findConnectedFlag(world, pos.func_177972_a(searchDir), searchDir, moveDir, it + 1);
        }
        if (b instanceof FlagBlock && it != 0) {
            BlockPos toPos = pos.func_177972_a(moveDir);
            BlockState stick = world.func_180495_p(toPos);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof FlagBlockTile && stick.func_177230_c() == ModRegistry.STICK_BLOCK.get() && StickBlock.isVertical(stick)) {
                world.func_175656_a(pos, stick);
                world.func_175656_a(toPos, state);
                tile.func_145843_s();
                if (tile != null) {
                    tile.func_174878_a(toPos);
                    TileEntity target = TileEntity.func_235657_b_((BlockState)state, (CompoundNBT)tile.func_189515_b(new CompoundNBT()));
                    if (target != null) {
                        world.func_175690_a(toPos, target);
                        target.func_145836_u();
                    }
                }
                world.func_184133_a(null, toPos, SoundEvents.field_187552_ah, SoundCategory.BLOCKS, 1.0f, 1.4f);
                return true;
            }
        }
        return false;
    }

    @Override
    public BlockState applyRotationLock(World world, BlockPos blockPos, BlockState state, Direction dir, int half) {
        int i = 0;
        if (((Boolean)state.func_177229_b((Property)AXIS_X)).booleanValue()) {
            ++i;
        }
        if (((Boolean)state.func_177229_b((Property)AXIS_Y)).booleanValue()) {
            ++i;
        }
        if (((Boolean)state.func_177229_b((Property)AXIS_Z)).booleanValue()) {
            ++i;
        }
        if (i == 1) {
            ((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)AXIS_Z, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)AXIS_X, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)AXIS_Y, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)this.AXIS2PROPERTY.get(dir.func_176740_k()), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }
}

